package com.zurrtum.create.client.content.decoration.placard;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.content.decoration.placard.PlacardBlock;
import com.zurrtum.create.content.decoration.placard.PlacardBlockEntity;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2738;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class PlacardRenderer implements class_827<PlacardBlockEntity, PlacardRenderer.PlacardRenderState> {
    protected final class_10442 itemModelManager;

    public PlacardRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public PlacardRenderState method_74335() {
        return new PlacardRenderState();
    }

    @Override
    public void extractRenderState(
        PlacardBlockEntity be,
        PlacardRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_1799 heldItem = be.getHeldItem();
        if (heldItem.method_7960()) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        class_2350 facing = state.field_62674.method_11654(PlacardBlock.field_11177);
        class_2738 face = state.field_62674.method_11654(PlacardBlock.field_11007);
        class_10444 item = state.item = new class_10444();
        item.field_55337 = class_811.field_4319;
        itemModelManager.method_65596(item, heldItem, item.field_55337, be.method_10997(), null, 0);
        boolean isCeiling = face == class_2738.field_12473;
        state.upAngle = (isCeiling ? class_3532.field_29844 : 0) + AngleHelper.rad(180 + AngleHelper.horizontalAngle(facing));
        state.eastAngle = isCeiling ? -class_3532.field_29844 / 2 : face == class_2738.field_12475 ? class_3532.field_29844 / 2 : 0;
        state.scale = item.method_65608() ? 0.5f : 0.375f;
    }

    @Override
    public void submit(PlacardRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(new Quaternionf().setAngleAxis(state.upAngle, 0, 1, 0));
        matrices.method_22907(new Quaternionf().setAngleAxis(state.eastAngle, 1, 0, 0));
        matrices.method_46416(0, 0, 0.28125f);
        float scale = state.scale;
        matrices.method_22905(scale, scale, scale);
        state.item.method_65604(matrices, queue, state.field_62676, class_4608.field_21444, 0);
    }

    public static class PlacardRenderState extends class_11954 {
        public class_10444 item;
        public float upAngle;
        public float eastAngle;
        public float scale;
    }
}
