package com.zurrtum.create.client.content.equipment.armor;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.equipment.armor.BacktankBlock;
import com.zurrtum.create.content.equipment.armor.BacktankItem;
import net.minecraft.class_10034;
import net.minecraft.class_11659;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4722;
import net.minecraft.class_572;

public class BacktankFeatureRenderer<S extends class_10034, M extends class_572<? super S>> extends class_3887<S, M> {
    public BacktankFeatureRenderer(class_3883<S, M> context) {
        super(context);
    }

    @Override
    public void submit(class_4587 ms, class_11659 queue, int light, S entityState, float limbAngle, float limbDistance) {
        if (entityState.field_53465 == class_4050.field_18078 || !(entityState.field_53418.method_7909() instanceof BacktankItem item)) {
            return;
        }
        BacktankRenderState state = new BacktankRenderState();
        class_2680 blockState = item.method_7711().method_9564().method_11657(BacktankBlock.HORIZONTAL_FACING, class_2350.field_11035);
        state.backtank = CachedBuffers.block(blockState);
        state.cogs = CachedBuffers.partial(BacktankRenderer.getCogsModel(blockState), blockState);
        state.nob = CachedBuffers.partial(BacktankRenderer.getShaftModel(blockState), blockState);
        state.light = light;
        state.yRot = class_3532.field_29847 * 180;
        state.angle = AngleHelper.rad(2 * AnimationTickHolder.getRenderTime() % 360);

        ms.method_22903();
        method_17165().field_3391.method_22703(ms);
        ms.method_46416(-1 / 2f, 10 / 16f, 1f);
        ms.method_22905(1, -1, -1);
        queue.method_73483(ms, class_4722.method_24074(), state);
        ms.method_22909();
    }

    public static class BacktankRenderState implements class_11659.class_11660 {
        public SuperByteBuffer backtank;
        public SuperByteBuffer cogs;
        public SuperByteBuffer nob;
        public int light;
        public float yRot;
        public float angle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            backtank.disableDiffuse().light(light).renderInto(matricesEntry, vertexConsumer);
            nob.disableDiffuse().translate(0, -0.1875f, 0).light(light).renderInto(matricesEntry, vertexConsumer);
            cogs.center().rotateY(yRot).uncenter().translate(0, 0.40625f, 0.6875f).rotate(angle, class_2350.field_11034).translate(0, -0.40625f, -0.6875f);
            cogs.disableDiffuse().light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
