package com.zurrtum.create.client.content.equipment.armor;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.equipment.armor.BacktankBlock;
import com.zurrtum.create.content.equipment.armor.BacktankBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class BacktankRenderer extends KineticBlockEntityRenderer<BacktankBlockEntity, BacktankRenderer.BacktankRenderState> {
    public BacktankRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public BacktankRenderState createRenderState() {
        return new BacktankRenderState();
    }

    @Override
    public void extractRenderState(
        BacktankBlockEntity be,
        BacktankRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            class_11954.method_74399(be, state, crumblingOverlay);
            state.layer = class_12249.method_75965();
        }
        state.cogs = CachedBuffers.partial(getCogsModel(state.blockState), state.blockState);
        state.yRot = class_3532.field_29847 * (180 + AngleHelper.horizontalAngle(state.blockState.getValue(BacktankBlock.HORIZONTAL_FACING)));
        state.rotate = AngleHelper.rad(be.getSpeed() / 4f * AnimationTickHolder.getRenderTime(be.method_10997()) % 360);
    }

    @Override
    public void submit(BacktankRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    @Override
    protected class_1921 getRenderType(BacktankBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(BacktankBlockEntity be, BacktankRenderState state) {
        return CachedBuffers.partial(getShaftModel(state.blockState), state.blockState);
    }

    public static PartialModel getCogsModel(class_2680 state) {
        if (state.method_27852(AllBlocks.NETHERITE_BACKTANK)) {
            return AllPartialModels.NETHERITE_BACKTANK_COGS;
        }
        return AllPartialModels.COPPER_BACKTANK_COGS;
    }

    public static PartialModel getShaftModel(class_2680 state) {
        if (state.method_27852(AllBlocks.NETHERITE_BACKTANK)) {
            return AllPartialModels.NETHERITE_BACKTANK_SHAFT;
        }
        return AllPartialModels.COPPER_BACKTANK_SHAFT;
    }

    public static class BacktankRenderState extends KineticRenderState {
        public SuperByteBuffer cogs;
        public float yRot;
        public float rotate;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            cogs.center().rotateY(yRot).uncenter();
            cogs.translate(0, 0.40625f, 0.6875f).rotate(rotate, class_2350.field_11034).translate(0, -0.40625f, -0.6875f);
            cogs.light(lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
