package com.zurrtum.create.client.content.equipment.blueprint;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.equipment.blueprint.BlueprintEntity;
import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BlueprintRenderer extends class_897<BlueprintEntity, BlueprintRenderer.BlueprintState> {
    protected final class_10442 itemModelManager;

    public BlueprintRenderer(class_5617.class_5618 context) {
        super(context);
        itemModelManager = context.method_65566();
    }

    @Override
    public BlueprintState method_55269() {
        return new BlueprintState();
    }

    @Override
    public void extractRenderState(BlueprintEntity entity, BlueprintState state, float tickProgress) {
        super.method_62354(entity, state, tickProgress);
        float yaw = entity.method_61415(tickProgress);
        float pitch = entity.method_36455();
        int size = entity.size;
        state.layer = class_4722.method_24073();
        PartialModel partialModel = size == 3 ? AllPartialModels.CRAFTING_BLUEPRINT_3x3 : size == 2 ? AllPartialModels.CRAFTING_BLUEPRINT_2x2 : AllPartialModels.CRAFTING_BLUEPRINT_1x1;
        state.model = CachedBuffers.partial(partialModel, class_2246.field_10124.method_9564());
        state.yRot = class_3532.field_29847 * -yaw;
        state.xRot = class_3532.field_29847 * (90.0F + pitch);
        class_243 offset = new class_243(-.5, -1 / 32f, -.5);
        if (size == 2) {
            offset = offset.method_1031(.5, 0, -.5);
        }
        state.offset = offset;
        class_1937 level = entity.method_73183();
        int itemSize = size * size * 2;
        class_10444[] items = new class_10444[itemSize];
        boolean empty = true;
        for (int i = 0; i < itemSize; ) {
            Couple<class_1799> displayItems = entity.getSection(i >> 1).getDisplayItems();
            class_1799 firstStack = displayItems.getFirst();
            if (!firstStack.method_7960()) {
                empty = false;
                items[i] = createItemRenderState(itemModelManager, firstStack, level);
            }
            i++;
            class_1799 secondStack = displayItems.getSecond();
            if (!secondStack.method_7960()) {
                empty = false;
                items[i] = createItemRenderState(itemModelManager, secondStack, level);
            }
            i++;
        }
        if (empty) {
            return;
        }
        state.items = items;
        state.size = size;
        int bl = state.field_61820 >> 4 & 0xf;
        int sl = state.field_61820 >> 20 & 0xf;
        state.normalYRot = pitch != 0 ? 0 : state.yRot;
        if (pitch == -90) {
            state.normalXRot = class_3532.field_29847 * -45;
        } else if (pitch == 90 || yaw % 180 != 0) {
            state.normalXRot = class_3532.field_29847 * -15;
            bl = (int) (bl / 1.35);
            sl = (int) (sl / 1.35);
        } else {
            state.normalXRot = class_3532.field_29847 * -15;
        }
        state.itemXRot = class_3532.field_29847 * pitch;
        state.itemOffsetZ = 1 / 32f + .001f;
        if (size == 3) {
            state.itemOffsetXY = -1;
        }
        state.itemLight = class_3532.method_15357(sl + .5) << 20 | (class_3532.method_15357(bl + .5) & 0xf) << 4;
    }

    private static class_10444 createItemRenderState(class_10442 itemModelManager, class_1799 stack, class_1937 world) {
        class_10444 state = new class_10444();
        state.field_55337 = class_811.field_4317;
        itemModelManager.method_65596(state, stack, state.field_55337, world, null, 0);
        return state;
    }

    @Override
    public void submit(BlueprintState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
        class_10444[] items = state.items;
        if (items == null) {
            return;
        }
        matrices.method_22903();
        class_4587.class_4665 entry = matrices.method_23760();
        Matrix3f normal = entry.method_23762();
        if (state.normalYRot != 0) {
            normal.rotate(class_7833.field_40716.rotation(state.normalYRot));
        }
        normal.rotate(class_7833.field_40714.rotation(state.normalXRot));
        Matrix4f pose = entry.method_23761();
        pose.rotate(class_7833.field_40716.rotation(state.yRot));
        pose.rotate(class_7833.field_40714.rotation(state.itemXRot));
        pose.translate(state.itemOffsetXY, state.itemOffsetXY, state.itemOffsetZ);
        Matrix4f copy = new Matrix4f(pose);
        int light = state.itemLight;
        for (int i = 0, size = items.length, n = 0, w = state.size - 1; i < size; ) {
            class_10444 firstState = items[i++];
            class_10444 secondState = items[i++];
            if (firstState != null || secondState != null) {
                pose.scale(0.5f, 0.5f, 0.0009765625f);
                if (firstState != null) {
                    firstState.method_65604(matrices, queue, light, class_4608.field_21444, 0);
                }
                if (secondState != null) {
                    pose.translate(0.325f, -0.325f, 1);
                    pose.scale(.625f, .625f, 1);
                    secondState.method_65604(matrices, queue, light, class_4608.field_21444, 0);
                }
            }
            if (n < w) {
                copy.translate(1, 0, 0);
                n++;
            } else {
                copy.translate(-w, 1, 0);
                n = 0;
            }
            pose.set(copy);
        }
        matrices.method_22909();
    }

    public static class BlueprintState extends class_10017 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        public float yRot;
        public float xRot;
        public class_243 offset;
        public class_10444[] items;
        public int size;
        public float normalYRot;
        public float normalXRot;
        public float itemXRot;
        public int itemOffsetXY;
        public float itemOffsetZ;
        public int itemLight;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.rotateY(yRot).rotateX(xRot).translate(offset).disableDiffuse().light(field_61820).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
