package com.zurrtum.create.client.content.equipment.clipboard;

import com.google.common.collect.Lists;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.infrastructure.component.ClipboardContent;
import com.zurrtum.create.infrastructure.component.ClipboardEntry;
import com.zurrtum.create.infrastructure.component.ClipboardType;
import com.zurrtum.create.infrastructure.packet.c2s.ClipboardEditPacket;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3728;
import net.minecraft.class_474;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_634;
import net.minecraft.class_768;
import net.minecraft.class_9323;

public class ClipboardScreen extends AbstractSimiScreen {
    public ClipboardContent content;
    public class_2338 targetedBlock;

    List<List<ClipboardEntry>> pages;
    List<ClipboardEntry> currentEntries;
    int editingIndex;
    int frameTick;
    class_474 forward;
    class_474 backward;
    int currentPage = 0;
    long lastClickTime;
    int lastIndex = -1;

    int hoveredEntry;
    boolean hoveredCheck;
    boolean readonly;

    DisplayCache displayCache = DisplayCache.EMPTY;
    class_3728 editContext;

    IconButton closeBtn;
    IconButton clearBtn;

    private final int targetSlot;

    public ClipboardScreen(int targetSlot, class_9323 components, @Nullable class_2338 pos) {
        this.targetSlot = targetSlot;
        this.targetedBlock = pos;
        reopenWith(components.method_58695(AllDataComponents.CLIPBOARD_CONTENT, ClipboardContent.EMPTY));
    }

    public void reopenWith(ClipboardContent content) {
        this.content = content;
        pages = ClipboardEntry.readAll(content);
        if (pages.isEmpty())
            pages.add(new ArrayList<>());
        if (clearBtn == null) {
            if (content != null) {
                currentPage = content.previouslyOpenedPage();
            }
            currentPage = class_3532.method_15340(currentPage, 0, pages.size() - 1);
        }
        currentEntries = pages.get(currentPage);
        boolean startEmpty = currentEntries.isEmpty();
        if (startEmpty)
            currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
        editingIndex = 0;
        editContext = new class_3728(
            this::getCurrentEntryText,
            this::setCurrentEntryText,
            this::getClipboard,
            this::setClipboard,
            this::validateTextForEntry
        );
        editingIndex = startEmpty ? 0 : -1;
        readonly = content != null && content.readOnly();
        if (readonly)
            editingIndex = -1;
        if (clearBtn != null)
            method_25426();
    }

    @Override
    protected void method_25426() {
        setWindowSize(256, 256);
        super.method_25426();
        clearDisplayCache();

        int x = guiLeft;
        int y = guiTop - 8;

        method_37067();
        clearBtn = new IconButton(x + 234, y + 153, AllIcons.I_CLEAR_CHECKED).withCallback(() -> {
            editingIndex = -1;
            currentEntries.removeIf(ce -> ce.checked);
            if (currentEntries.isEmpty())
                currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
            sendIfEditingBlock();
        });
        clearBtn.setToolTip(CreateLang.translateDirect("gui.clipboard.erase_checked"));
        closeBtn = new IconButton(x + 234, y + 175, AllIcons.I_PRIORITY_VERY_LOW).withCallback(() -> field_22787.method_1507(null));
        closeBtn.setToolTip(CreateLang.translateDirect("station.close"));
        method_37063(closeBtn);
        method_37063(clearBtn);

        forward = new class_474(x + 176, y + 229, true, $ -> changePage(true), true);
        backward = new class_474(x + 53, y + 229, false, $ -> changePage(false), true);
        method_37063(forward);
        method_37063(backward);

        forward.field_22764 = currentPage < 50 && (!readonly || currentPage + 1 < pages.size());
        backward.field_22764 = currentPage > 0;
    }

    private int getNumPages() {
        return pages.size();
    }

    public void method_25393() {
        super.method_25393();
        frameTick++;

        if (targetedBlock != null) {
            if (!field_22787.field_1724.method_24515().method_19771(targetedBlock, 10)) {
                method_25432();
                return;
            }
            if (!field_22787.field_1687.method_8320(targetedBlock).method_27852(AllBlocks.CLIPBOARD)) {
                method_25432();
                return;
            }
        }

        class_1041 window = field_22787.method_22683();
        int mx = (int) (field_22787.field_1729.method_1603() * (double) window.method_4486() / (double) window.method_4480());
        int my = (int) (field_22787.field_1729.method_1604() * (double) window.method_4502() / (double) window.method_4507());

        mx -= guiLeft + 35;
        my -= guiTop + 41;

        hoveredCheck = false;
        hoveredEntry = -1;

        if (mx > 0 && mx < 183 && my > 0 && my < 190) {
            hoveredCheck = mx < 20;
            int totalHeight = 0;
            for (int i = 0; i < currentEntries.size(); i++) {
                ClipboardEntry clipboardEntry = currentEntries.get(i);
                String text = clipboardEntry.text.getString();
                totalHeight += Math.max(12, field_22793.method_1728(class_2561.method_43470(text), clipboardEntry.icon.method_7960() ? 150 : 130).size() * 9 + 3);

                if (totalHeight > my) {
                    hoveredEntry = i;
                    return;
                }
            }
            hoveredEntry = currentEntries.size();
        }
    }

    private String getCurrentEntryText() {
        return currentEntries.get(editingIndex).text.getString();
    }

    private void setCurrentEntryText(String text) {
        currentEntries.get(editingIndex).text = class_2561.method_43470(text);
        sendIfEditingBlock();
    }

    private void setClipboard(String p_98148_) {
        if (field_22787 != null)
            class_3728.method_27551(field_22787, p_98148_);
    }

    private String getClipboard() {
        return field_22787 != null ? class_3728.method_27556(field_22787) : "";
    }

    private boolean validateTextForEntry(String newText) {
        int totalHeight = 0;
        for (int i = 0; i < currentEntries.size(); i++) {
            ClipboardEntry clipboardEntry = currentEntries.get(i);
            String text = i == editingIndex ? newText : clipboardEntry.text.getString();
            totalHeight += Math.max(12, field_22793.method_1728(class_2561.method_43470(text), 150).size() * 9 + 3);
        }
        return totalHeight < 185;
    }

    private int yOffsetOfEditingEntry() {
        int totalHeight = 0;
        for (int i = 0; i < currentEntries.size(); i++) {
            if (i == editingIndex)
                break;
            ClipboardEntry clipboardEntry = currentEntries.get(i);
            totalHeight += Math.max(12, field_22793.method_1728(clipboardEntry.text, 150).size() * 9 + 3);
        }
        return totalHeight;
    }

    private void changePage(boolean next) {
        int previously = currentPage;
        currentPage = class_3532.method_15340(currentPage + (next ? 1 : -1), 0, 50);
        if (currentPage == previously)
            return;
        editingIndex = -1;
        if (pages.size() <= currentPage) {
            if (readonly) {
                currentPage = previously;
                return;
            }
            pages.add(new ArrayList<>());
        }
        currentEntries = pages.get(currentPage);
        if (currentEntries.isEmpty()) {
            currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
            if (!readonly) {
                editingIndex = 0;
                editContext.method_16204();
                clearDisplayCacheAfterChange();
            }
        }

        forward.field_22764 = currentPage < 50 && (!readonly || currentPage + 1 < pages.size());
        backward.field_22764 = currentPage > 0;

        if (next)
            return;
        if (pages.get(currentPage + 1).stream().allMatch(ce -> ce.text.getString().isBlank()))
            pages.remove(currentPage + 1);
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop - 8;

        AllGuiTextures.CLIPBOARD.render(graphics, x, y);
        graphics.method_51439(field_22793, class_2561.method_43469("book.pageIndicator", currentPage + 1, getNumPages()), x + 150, y + 9, 0x43ffffff, false);

        for (int i = 0; i < currentEntries.size(); i++) {
            ClipboardEntry clipboardEntry = currentEntries.get(i);
            boolean checked = clipboardEntry.checked;
            int iconOffset = clipboardEntry.icon.method_7960() ? 0 : 16;

            class_5250 text = clipboardEntry.text;
            String string = text.getString();
            boolean isAddress = string.startsWith("#") && !string.substring(1).isBlank();

            if (isAddress) {
                (checked ? AllGuiTextures.CLIPBOARD_ADDRESS_INACTIVE : AllGuiTextures.CLIPBOARD_ADDRESS).render(graphics, x + 44, y + 50);
                text = class_2561.method_43470(string.substring(1).stripLeading());
            } else {
                graphics.method_51433(field_22793, "\u25A1", x + 45, y + 51, checked ? 0x668D7F6B : 0xff8D7F6B, false);
                if (checked)
                    graphics.method_51433(field_22793, "\u2714", x + 45, y + 50, 0xff31B25D, false);
            }

            List<class_5481> split = field_22793.method_1728(text, 150 - iconOffset);
            if (split.isEmpty()) {
                y += 12;
                continue;
            }

            if (!clipboardEntry.icon.method_7960())
                graphics.method_51427(clipboardEntry.icon, x + 54, y + 50);

            for (class_5481 sequence : split) {
                if (i != editingIndex)
                    graphics.method_51430(
                        field_22793,
                        sequence,
                        x + 58 + iconOffset,
                        y + 50,
                        checked ? isAddress ? 0x668D7F6B : 0xff31B25D : 0xff311A00,
                        false
                    );
                y += 9;
            }
            y += 3;
        }

        if (editingIndex == -1)
            return;

        method_25395(null);
        DisplayCache cache = getDisplayCache();

        for (LineInfo line : cache.lines)
            graphics.method_51439(field_22793, line.asComponent, line.x, line.y, 0xff311A00, false);

        renderHighlight(graphics, cache.selection);
        renderCursor(graphics, cache.cursor, cache.cursorAtEnd);
    }

    @Override
    public void method_25432() {
        pages.forEach(list -> list.removeIf(ce -> ce.text.getString().isBlank()));
        pages.removeIf(List::isEmpty);

        for (int i = 0; i < pages.size(); i++) {
            if (pages.get(i) == currentEntries) {
                content = content.setPreviouslyOpenedPage(i);
            }
        }

        send();

        super.method_25432();
    }

    private void sendIfEditingBlock() {
        class_634 handler = field_22787.field_1724.field_3944;
        if (handler.method_2880().size() > 1 && targetedBlock != null)
            send();
    }

    private void send() {
        content = content.setPages(pages);
        content = content.setType(ClipboardType.WRITTEN);

        if (pages.isEmpty()) {
            content = null;
        }

        field_22787.field_1724.field_3944.method_52787(new ClipboardEditPacket(targetSlot, content, targetedBlock));
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        changePage(pScrollY < 0);
        return true;
    }

    @Override
    public boolean method_25404(class_11908 input) {
        int pKeyCode = input.comp_4795();
        if (pKeyCode == 266) {
            backward.method_25306(input);
            return true;
        }
        if (pKeyCode == 267) {
            forward.method_25306(input);
            return true;
        }
        if (editingIndex != -1 && pKeyCode != 256) {
            keyPressedWhileEditing(input);
            clearDisplayCache();
            return true;
        }
        super.method_25404(input);
        return true;
    }

    @Override
    public boolean method_25400(class_11905 input) {
        if (super.method_25400(input))
            return true;
        if (!input.method_74227())
            return false;
        if (editingIndex == -1)
            return false;
        editContext.method_16197(input.method_74226());
        clearDisplayCache();
        return true;
    }

    private boolean keyPressedWhileEditing(class_11908 input) {
        if (input.method_74241()) {
            editContext.method_27563();
            return true;
        } else if (input.method_74242()) {
            editContext.method_27559();
            return true;
        } else if (input.method_74243()) {
            editContext.method_27554();
            return true;
        } else if (input.method_74244()) {
            editContext.method_27547();
            return true;
        } else {
            switch (input.comp_4795()) {
                case 257:
                case 335:
                    if (input.method_74239()) {
                        editContext.method_16197("\n");
                        return true;
                    } else if (!input.method_74240()) {
                        if (currentEntries.size() <= editingIndex + 1 || !currentEntries.get(editingIndex + 1).text.getString().isEmpty())
                            currentEntries.add(editingIndex + 1, new ClipboardEntry(false, class_2561.method_43473()));
                        editingIndex += 1;
                        editContext.method_16204();
                        if (validateTextForEntry(" "))
                            return true;
                        currentEntries.remove(editingIndex);
                        editingIndex -= 1;
                        editContext.method_16204();
                        return true;
                    }
                    editingIndex = -1;
                    return true;
                case 259:
                    if (currentEntries.get(editingIndex).text.getString().isEmpty() && currentEntries.size() > 1) {
                        currentEntries.remove(editingIndex);
                        editingIndex = Math.max(0, editingIndex - 1);
                        editContext.method_16204();
                        return true;
                    } else if (input.method_74240()) {
                        int prevPos = editContext.method_16201();
                        editContext.method_35728(-1);
                        if (prevPos != editContext.method_16201())
                            editContext.method_27564(prevPos - editContext.method_16201());
                        return true;
                    }
                    editContext.method_27564(-1);
                    return true;
                case 261:
                    if (input.method_74240()) {
                        int prevPos = editContext.method_16201();
                        editContext.method_35728(1);
                        if (prevPos != editContext.method_16201())
                            editContext.method_27564(prevPos - editContext.method_16201());
                        return true;
                    }
                    editContext.method_27564(1);
                    return true;
                case 262:
                    if (input.method_74240()) {
                        editContext.method_27555(1, input.method_74239());
                        return true;
                    }
                    editContext.method_27549(1, input.method_74239());
                    return true;
                case 263:
                    if (input.method_74240()) {
                        editContext.method_27555(-1, input.method_74239());
                        return true;
                    }
                    editContext.method_27549(-1, input.method_74239());
                    return true;
                case 264:
                    keyDown(input);
                    return true;
                case 265:
                    keyUp(input);
                    return true;
                case 268:
                    keyHome(input);
                    return true;
                case 269:
                    keyEnd(input);
                    return true;
                default:
                    return false;
            }
        }
    }

    private void keyUp(class_11908 input) {
        changeLine(input, -1);
    }

    private void keyDown(class_11908 input) {
        changeLine(input, 1);
    }

    private void changeLine(class_11908 input, int pYChange) {
        int i = editContext.method_16201();
        int j = getDisplayCache().changeLine(i, pYChange);
        editContext.method_27560(j, input.method_74239());
    }

    private void keyHome(class_11908 input) {
        int i = editContext.method_16201();
        int j = getDisplayCache().findLineStart(i);
        editContext.method_27560(j, input.method_74239());
    }

    private void keyEnd(class_11908 input) {
        DisplayCache cache = getDisplayCache();
        int i = editContext.method_16201();
        int j = cache.findLineEnd(i);
        editContext.method_27560(j, input.method_74239());
    }

    private void renderCursor(class_332 graphics, Pos2i pCursorPos, boolean pIsEndOfText) {
        if (frameTick / 6 % 2 != 0)
            return;
        pCursorPos = convertLocalToScreen(pCursorPos);
        if (!pIsEndOfText) {
            graphics.method_25294(pCursorPos.x, pCursorPos.y - 1, pCursorPos.x + 1, pCursorPos.y + 9, -16777216);
        } else {
            graphics.method_51433(field_22793, "_", pCursorPos.x, pCursorPos.y, 0xFF000000, false);
        }
    }

    private void renderHighlight(class_332 graphics, class_768[] pSelected) {
        for (class_768 rect2i : pSelected) {
            int i = rect2i.method_3321();
            int j = rect2i.method_3322();
            int k = i + rect2i.method_3319();
            int l = j + rect2i.method_3320();
            graphics.method_72238(i, j, k, l, true);
        }
    }

    private Pos2i convertScreenToLocal(Pos2i pScreenPos) {
        return new Pos2i(pScreenPos.x - (field_22789 - 192) / 2 - 36 + 10, pScreenPos.y - 32 - 24 - yOffsetOfEditingEntry() - guiTop + 14);
    }

    private Pos2i convertLocalToScreen(Pos2i pLocalScreenPos) {
        return new Pos2i(pLocalScreenPos.x + (field_22789 - 192) / 2 + 36 - 10, pLocalScreenPos.y + 32 + 24 + yOffsetOfEditingEntry() + guiTop - 14);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (super.method_25402(click, doubled))
            return true;
        if (click.method_74245() != 0)
            return true;

        if (hoveredEntry != -1) {
            if (hoveredCheck) {
                editingIndex = -1;
                if (hoveredEntry < currentEntries.size()) {
                    currentEntries.get(hoveredEntry).checked ^= true;
                    if (currentEntries.get(hoveredEntry).checked == true)
                        field_22787.method_1483().method_4873(class_1109.method_4758(
                            AllSoundEvents.CLIPBOARD_CHECKMARK.getMainEvent(),
                            0.95f + (float) Math.random() * 0.05f
                        ));
                    else
                        field_22787.method_1483()
                            .method_4873(class_1109.method_4758(AllSoundEvents.CLIPBOARD_ERASE.getMainEvent(), 0.90f + (float) Math.random() * 0.2f));
                }
                sendIfEditingBlock();
                return true;
            }

            if (hoveredEntry != editingIndex && !readonly) {
                editingIndex = hoveredEntry;
                if (hoveredEntry >= currentEntries.size()) {
                    currentEntries.add(new ClipboardEntry(false, class_2561.method_43473()));
                    if (!validateTextForEntry(" ")) {
                        currentEntries.remove(hoveredEntry);
                        editingIndex = -1;
                        return true;
                    }
                }
                clearDisplayCacheAfterChange();
            }
        }

        if (editingIndex == -1)
            return false;

        double pMouseX = click.comp_4798();
        double pMouseY = click.comp_4799();
        if (pMouseX < guiLeft + 50 || pMouseX > guiLeft + 220 || pMouseY < guiTop + 30 || pMouseY > guiTop + 230) {
            method_25395(null);
            clearDisplayCache();
            editingIndex = -1;
            return false;
        }

        long i = class_156.method_658();
        DisplayCache cache = getDisplayCache();
        int j = cache.getIndexAtPosition(field_22793, convertScreenToLocal(new Pos2i((int) pMouseX, (int) pMouseY)));
        if (j >= 0) {
            if (j == lastIndex && i - lastClickTime < 250L) {
                if (!editContext.method_27568()) {
                    selectWord(j);
                } else {
                    editContext.method_27563();
                }
            } else {
                editContext.method_27560(j, click.method_74239());
            }

            clearDisplayCache();
        }

        lastIndex = j;
        lastClickTime = i;
        return true;
    }

    private void selectWord(int pIndex) {
        String s = getCurrentEntryText();
        editContext.method_27548(class_5225.method_27483(s, -1, pIndex, false), class_5225.method_27483(s, 1, pIndex, false));
    }

    public boolean method_25403(class_11909 click, double pDragX, double pDragY) {
        if (super.method_25403(click, pDragX, pDragY))
            return true;
        if (click.method_74245() != 0)
            return true;
        if (editingIndex == -1)
            return false;

        DisplayCache cache = getDisplayCache();
        int i = cache.getIndexAtPosition(field_22793, convertScreenToLocal(new Pos2i((int) click.comp_4798(), (int) click.comp_4799())));
        editContext.method_27560(i, true);
        clearDisplayCache();
        return true;
    }

    private DisplayCache getDisplayCache() {
        if (displayCache == null)
            displayCache = rebuildDisplayCache();
        return displayCache;
    }

    private void clearDisplayCache() {
        displayCache = null;
    }

    private void clearDisplayCacheAfterChange() {
        editContext.method_16204();
        clearDisplayCache();
    }

    private DisplayCache rebuildDisplayCache() {
        String current = getCurrentEntryText();
        boolean address = current.startsWith("#") && !current.substring(1).isBlank();
        int offset = 0;

        if (address) {
            String stripped = current.substring(1).stripLeading();
            offset = current.length() - stripped.length();
            current = stripped;
        }

        if (current.isEmpty())
            return DisplayCache.EMPTY;

        String s = current;
        int i = editContext.method_16201();
        int j = editContext.method_16203();
        i = class_3532.method_15340(i - offset, 0, s.length());
        j = class_3532.method_15340(j - offset, 0, s.length());

        IntList intlist = new IntArrayList();
        List<LineInfo> list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        class_5225 stringsplitter = field_22793.method_27527();
        stringsplitter.method_27485(
            s, 150, class_2583.field_24360, true, (p_98132_, p_98133_, p_98134_) -> {
                int k3 = mutableint.getAndIncrement();
                String s2 = s.substring(p_98133_, p_98134_);
                mutableboolean.setValue(s2.endsWith("\n"));
                String s3 = StringUtils.stripEnd(s2, " \n");
                int l3 = k3 * 9;
                Pos2i pos1 = convertLocalToScreen(new Pos2i(0, l3));
                intlist.add(p_98133_);
                list.add(new LineInfo(p_98132_, s3, pos1.x, pos1.y));
            }
        );

        int[] aint = intlist.toIntArray();
        boolean flag = i == s.length();
        Pos2i pos;
        if (flag && mutableboolean.isTrue()) {
            pos = new Pos2i(0, list.size() * 9);
        } else {
            int k = findLineFromPos(aint, i);
            int l = field_22793.method_1727(s.substring(aint[k], i));
            pos = new Pos2i(l, k * 9);
        }

        List<class_768> list1 = Lists.newArrayList();
        if (i != j) {
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = findLineFromPos(aint, l2);
            int k1 = findLineFromPos(aint, i1);
            if (j1 == k1) {
                int l1 = j1 * 9;
                int i2 = aint[j1];
                list1.add(createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > aint.length ? s.length() : aint[j1 + 1];
                list1.add(createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, aint[j1]));

                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(aint[j3], aint[j3 + 1]);
                    int k2 = (int) stringsplitter.method_27482(s1);
                    list1.add(createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }

                list1.add(createPartialLineSelection(s, stringsplitter, aint[k1], i1, k1 * 9, aint[k1]));
            }
        }

        return new DisplayCache(s, pos, flag, aint, list.toArray(new LineInfo[0]), list1.toArray(new class_768[0]));
    }

    static int findLineFromPos(int[] pLineStarts, int pFind) {
        int i = Arrays.binarySearch(pLineStarts, pFind);
        return i < 0 ? -(i + 2) : i;
    }

    private class_768 createPartialLineSelection(String pInput, class_5225 pSplitter, int p_98122_, int p_98123_, int p_98124_, int p_98125_) {
        String s = pInput.substring(p_98125_, p_98122_);
        String s1 = pInput.substring(p_98125_, p_98123_);
        Pos2i firstPos = new Pos2i((int) pSplitter.method_27482(s), p_98124_);
        Pos2i secondPos = new Pos2i((int) pSplitter.method_27482(s1), p_98124_ + 9);
        return createSelection(firstPos, secondPos);
    }

    private class_768 createSelection(Pos2i pCorner1, Pos2i pCorner2) {
        Pos2i firstPos = convertLocalToScreen(pCorner1);
        Pos2i secondPos = convertLocalToScreen(pCorner2);
        int i = Math.min(firstPos.x, secondPos.x);
        int j = Math.max(firstPos.x, secondPos.x);
        int k = Math.min(firstPos.y, secondPos.y);
        int l = Math.max(firstPos.y, secondPos.y);
        return new class_768(i, k, j - i, l - k);
    }

    static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache(
            "",
            new Pos2i(0, 0),
            true,
            new int[]{0},
            new LineInfo[]{new LineInfo(class_2583.field_24360, "", 0, 0)},
            new class_768[0]
        );
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final class_768[] selection;

        public DisplayCache(String pFullText, Pos2i pCursor, boolean pCursorAtEnd, int[] pLineStarts, LineInfo[] pLines, class_768[] pSelection) {
            fullText = pFullText;
            cursor = pCursor;
            cursorAtEnd = pCursorAtEnd;
            lineStarts = pLineStarts;
            lines = pLines;
            selection = pSelection;
        }

        public int getIndexAtPosition(class_327 pFont, Pos2i pCursorPosition) {
            int i = pCursorPosition.y / 9;
            if (i < 0)
                return 0;
            if (i >= lines.length)
                return fullText.length();
            LineInfo line = lines[i];
            return lineStarts[i] + pFont.method_27527().method_27484(line.contents, pCursorPosition.x, line.style);
        }

        public int changeLine(int pXChange, int pYChange) {
            int i = findLineFromPos(lineStarts, pXChange);
            int j = i + pYChange;
            int k;
            if (0 <= j && j < lineStarts.length) {
                int l = pXChange - lineStarts[i];
                int i1 = lines[j].contents.length();
                k = lineStarts[j] + Math.min(l, i1);
            } else {
                k = pXChange;
            }

            return k;
        }

        public int findLineStart(int pLine) {
            int i = findLineFromPos(lineStarts, pLine);
            return lineStarts[i];
        }

        public int findLineEnd(int pLine) {
            int i = findLineFromPos(lineStarts, pLine);
            return lineStarts[i] + lines[i].contents.length();
        }
    }

    static class LineInfo {
        final class_2583 style;
        final String contents;
        final class_2561 asComponent;
        final int x;
        final int y;

        public LineInfo(class_2583 pStyle, String pContents, int pX, int pY) {
            style = pStyle;
            contents = pContents;
            x = pX;
            y = pY;
            asComponent = class_2561.method_43470(pContents).method_10862(pStyle);
        }
    }

    record Pos2i(int x, int y) {
    }

}
