package com.zurrtum.create.client.content.equipment.zapper;

import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.content.equipment.zapper.ZapperItem;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;

public class ZapperRenderHandler extends ShootableGadgetRenderHandler {

    public List<LaserBeam> cachedBeams;

    @Override
    protected boolean appliesTo(class_1799 stack) {
        return stack.method_7909() instanceof ZapperItem;
    }

    @Override
    public void tick() {
        super.tick();

        if (cachedBeams == null)
            cachedBeams = new LinkedList<>();

        cachedBeams.removeIf(b -> b.itensity < .1f);
        if (cachedBeams.isEmpty())
            return;

        cachedBeams.forEach(beam -> {
            Outliner.getInstance().endChasingLine(beam, beam.start, beam.end, 1 - beam.itensity, false).disableLineNormals().colored(0xffffff)
                .lineWidth(beam.itensity * 1 / 8f);
        });

        cachedBeams.forEach(b -> b.itensity *= .6f);
    }

    @Override
    protected void transformTool(class_4587 ms, float flip, float equipProgress, float recoil, float pt) {
        ms.method_46416(flip * -0.1f, 0.1f, -0.4f);
        ms.method_22907(class_7833.field_40716.rotationDegrees(flip * 5.0F));
    }

    @Override
    protected void transformHand(class_4587 ms, float flip, float equipProgress, float recoil, float pt) {
    }

    @Override
    public void playSound(class_1268 hand, class_243 position) {
        float pitch = hand == class_1268.field_5808 ? 0.1f : 0.9f;
        class_310 mc = class_310.method_1551();
        AllSoundEvents.WORLDSHAPER_PLACE.play(mc.field_1687, mc.field_1724, position, 0.1f, pitch);
    }

    public void addBeam(class_310 mc, LaserBeam beam) {
        class_638 world = mc.field_1687;
        class_5819 random = world.field_9229;
        double x = beam.end.field_1352;
        double y = beam.end.field_1351;
        double z = beam.end.field_1350;
        Supplier<Double> randomSpeed = () -> (random.method_43058() - .5d) * .2f;
        Supplier<Double> randomOffset = () -> (random.method_43058() - .5d) * .2f;
        for (int i = 0; i < 10; i++) {
            world.method_8406(class_2398.field_11207, x, y, z, randomSpeed.get(), randomSpeed.get(), randomSpeed.get());
            world.method_8406(class_2398.field_11248, x + randomOffset.get(), y + randomOffset.get(), z + randomOffset.get(), 0, 0, 0);
        }

        cachedBeams.add(beam);
    }

    public static class LaserBeam {
        float itensity;
        class_243 start;
        class_243 end;

        public LaserBeam(class_243 start, class_243 end) {
            this.start = start;
            this.end = end;
            itensity = 1;
        }
    }

}