package com.zurrtum.create.client.content.equipment.zapper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.equipment.zapper.ConfigureZapperPacket;
import com.zurrtum.create.infrastructure.component.PlacementPatterns;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5244;

public abstract class ZapperScreen extends AbstractSimiScreen {

    protected final class_2561 patternSection = CreateLang.translateDirect("gui.terrainzapper.patternSection");

    protected AllGuiTextures background;
    protected class_1799 zapper;
    protected class_1268 hand;

    protected float animationProgress;

    protected ElementWidget renderedItem;
    protected ElementWidget renderedBlock;
    protected class_2561 field_22785;
    protected List<IconButton> patternButtons = new ArrayList<>(6);
    private IconButton confirmButton;
    protected int brightColor;
    protected int fontColor;

    protected PlacementPatterns currentPattern;

    public ZapperScreen(AllGuiTextures background, class_1799 zapper, class_1268 hand) {
        this.background = background;
        this.zapper = zapper;
        this.hand = hand;
        field_22785 = class_5244.field_39003;
        brightColor = 0xFEFEFE;
        fontColor = AllGuiTextures.FONT_COLOR;

        currentPattern = zapper.method_58695(AllDataComponents.PLACEMENT_PATTERN, PlacementPatterns.Solid);
    }

    public AllIcons getIcon(PlacementPatterns pattern) {
        return switch (pattern) {
            case Solid -> AllIcons.I_PATTERN_SOLID;
            case Checkered -> AllIcons.I_PATTERN_CHECKERED;
            case InverseCheckered -> AllIcons.I_PATTERN_CHECKERED_INVERSED;
            case Chance25 -> AllIcons.I_PATTERN_CHANCE_25;
            case Chance50 -> AllIcons.I_PATTERN_CHANCE_50;
            case Chance75 -> AllIcons.I_PATTERN_CHANCE_75;
        };
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight());
        setWindowOffset(-10, 0);
        super.method_25426();

        animationProgress = 0;

        int x = guiLeft;
        int y = guiTop;

        confirmButton = new IconButton(x + background.getWidth() - 33, y + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(this::method_25419);
        method_37063(confirmButton);

        patternButtons.clear();
        for (int row = 0; row <= 1; row++) {
            for (int col = 0; col <= 2; col++) {
                int id = patternButtons.size();
                PlacementPatterns pattern = PlacementPatterns.values()[id];
                IconButton patternButton = new IconButton(x + background.getWidth() - 76 + col * 18, y + 21 + row * 18, getIcon(pattern));
                patternButton.withCallback(() -> {
                    patternButtons.forEach(b -> b.green = false);
                    patternButton.green = true;
                    currentPattern = pattern;
                });
                patternButton.setToolTip(CreateLang.translateDirect("gui.terrainzapper.pattern." + pattern.translationKey));
                patternButtons.add(patternButton);
            }
        }

        patternButtons.get(currentPattern.ordinal()).green = true;

        addRenderableWidgets(patternButtons);

        renderedItem = new ElementWidget(x + background.getWidth(), y + background.getHeight() - 48).showingElement(GuiGameElement.of(zapper)
            .scale(4));
        method_37063(renderedItem);
        renderedBlock = new ElementWidget(x + 17, y + 24).showingElement(GuiGameElement.of(zapper.method_58695(
            AllDataComponents.SHAPER_BLOCK_USED,
            class_2246.field_10124.method_9564()
        )).scale(1.25f).rotate(-25f, -45f, 0).padding(10));
        method_37063(renderedBlock);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
        renderedBlock.getRenderElement().clear();
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int x = guiLeft;
        int y = guiTop;

        background.render(graphics, x, y);
        drawOnBackground(graphics, x, y);
    }

    protected void drawOnBackground(class_332 graphics, int x, int y) {
        graphics.method_51439(field_22793, field_22785, x + (background.getWidth() - field_22793.method_27525(field_22785)) / 2, y + 4, 0xFF54214F, false);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        animationProgress += 5;
    }

    @Override
    public void method_25432() {
        ConfigureZapperPacket packet = getConfigurationPacket();
        packet.configureZapper(zapper);
        field_22787.field_1724.field_3944.method_52787(packet);
    }

    protected abstract ConfigureZapperPacket getConfigurationPacket();

}
