package com.zurrtum.create.client.content.equipment.zapper.terrainzapper;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.content.equipment.zapper.terrainzapper.Brush;
import com.zurrtum.create.infrastructure.component.PlacementOptions;
import com.zurrtum.create.infrastructure.component.TerrainBrushes;
import com.zurrtum.create.infrastructure.component.TerrainTools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_3965;
import net.minecraft.class_746;

public class WorldshaperRenderHandler {

    private static Supplier<Collection<class_2338>> renderedPositions;

    public static void tick(class_310 mc) {
        gatherSelectedBlocks(mc);
        if (renderedPositions == null)
            return;

        Outliner.getInstance().showCluster("terrainZapper", renderedPositions.get()).colored(0xbfbfbf).disableLineNormals().lineWidth(1 / 32f)
            .withFaceTexture(AllSpecialTextures.CHECKERED);
    }

    protected static void gatherSelectedBlocks(class_310 mc) {
        class_746 player = mc.field_1724;
        class_1799 heldMain = player.method_6047();
        class_1799 heldOff = player.method_6079();
        boolean zapperInMain = heldMain.method_31574(AllItems.WORLDSHAPER);
        boolean zapperInOff = heldOff.method_31574(AllItems.WORLDSHAPER);

        if (zapperInMain) {
            if (!heldMain.method_57826(AllDataComponents.SHAPER_SWAP) || !zapperInOff) {
                createBrushOutline(player, heldMain);
                return;
            }
        }

        if (zapperInOff) {
            createBrushOutline(player, heldOff);
            return;
        }

        renderedPositions = null;
    }

    public static void createBrushOutline(class_746 player, class_1799 zapper) {
        if (!zapper.method_57826(AllDataComponents.SHAPER_BRUSH_PARAMS)) {
            renderedPositions = null;
            return;
        }

        Brush brush = zapper.method_58695(AllDataComponents.SHAPER_BRUSH, TerrainBrushes.Cuboid).get();
        PlacementOptions placement = zapper.method_58695(AllDataComponents.SHAPER_PLACEMENT_OPTIONS, PlacementOptions.Merged);
        TerrainTools tool = zapper.method_58695(AllDataComponents.SHAPER_TOOL, TerrainTools.Fill);
        class_2338 params = zapper.method_58694(AllDataComponents.SHAPER_BRUSH_PARAMS);
        brush.set(params.method_10263(), params.method_10264(), params.method_10260());

        class_243 start = player.method_73189().method_1031(0, player.method_5751(), 0);
        class_243 rotationVector = player.method_5720();
        class_243 range = rotationVector.method_1021(128);
        class_1937 world = player.method_73183();
        class_3965 raytrace = world.method_17742(new class_3959(start, start.method_1019(range), class_3960.field_17559, class_242.field_1348, player));
        if (raytrace == null || raytrace.method_17783() == class_240.field_1333) {
            renderedPositions = null;
            return;
        }

        class_2338 pos = raytrace.method_17777().method_10081(brush.getOffset(rotationVector, raytrace.method_17780(), placement));
        renderedPositions = () -> brush.addToGlobalPositions(world, pos, raytrace.method_17780(), new ArrayList<>(), tool);
    }

}