package com.zurrtum.create.client.content.fluids.tank;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.content.fluids.tank.FluidTankBlockEntity;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;

public class FluidTankRenderer implements class_827<FluidTankBlockEntity, FluidTankRenderer.FluidTankRenderState> {
    public FluidTankRenderer(class_5614.class_5615 context) {
    }

    @Override
    public FluidTankRenderState method_74335() {
        return new FluidTankRenderState();
    }

    @Override
    public void extractRenderState(
        FluidTankBlockEntity be,
        FluidTankRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        if (!be.isController()) {
            return;
        }
        if (be.window) {
            updateFluidTankState(be, state, tickProgress, crumblingOverlay);
        } else if (be.boiler.isActive()) {
            updateBoilerState(be, state, tickProgress, crumblingOverlay);
        }
    }

    public void updateFluidTankState(
        FluidTankBlockEntity be,
        FluidTankRenderState state,
        float tickProgress,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 1 / 4f;
        float minPuddleHeight = 1 / 16f;
        float totalHeight = be.getHeight() - 2 * capHeight - minPuddleHeight;
        float level = fluidLevel.getValue(tickProgress);
        if (level < 1 / (512f * totalHeight)) {
            return;
        }
        FluidStack fluidStack = be.getTankInventory().getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_12249.method_75977();
        FluidTankRenderData data = new FluidTankRenderData();
        state.data = data;
        float clampedLevel = class_3532.method_15363(level * totalHeight, 0, totalHeight);
        data.translateY = clampedLevel - totalHeight;
        data.light = state.field_62676;
        data.fluid = fluidStack.getFluid();
        data.changes = fluidStack.getComponentChanges();

        //TODO
        boolean top = false;//fluidStack.getFluid()
        //			.getFluidType()
        //            .isLighterThanAir();

        int width = be.getWidth();
        float tankHullWidth = 1 / 16f + 1 / 128f;
        data.xMin = tankHullWidth;
        data.xMax = data.xMin + width - 2 * tankHullWidth;
        data.yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
        data.yMax = data.yMin + clampedLevel;

        if (top) {
            data.yMin += totalHeight - clampedLevel;
            data.yMax += totalHeight - clampedLevel;
        }

        data.zMin = tankHullWidth;
        data.zMax = data.zMin + width - 2 * tankHullWidth;
    }

    public void updateBoilerState(
        FluidTankBlockEntity be,
        FluidTankRenderState state,
        float tickProgress,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        boolean[] occludedDirections = be.boiler.occludedDirections;
        if (occludedDirections[0] && occludedDirections[1] && occludedDirections[2] && occludedDirections[3]) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_12249.method_75972();
        BoilerRenderData data = new BoilerRenderData();
        state.data = data;
        data.translateXZ = be.getWidth() / 2f;
        data.light = state.field_62676;
        data.translateX = data.translateXZ - 6 / 16f;
        data.dialPivotY = 6f / 16;
        data.dialPivotZ = 8f / 16;
        data.progress = -145 * be.boiler.gauge.getValue(tickProgress) + 90;
        data.gauge = CachedBuffers.partial(AllPartialModels.BOILER_GAUGE, state.field_62674);
        data.gaugeDial = CachedBuffers.partial(AllPartialModels.BOILER_GAUGE_DIAL, state.field_62674);
        data.south = !occludedDirections[0];
        data.west = !occludedDirections[1];
        data.north = !occludedDirections[2];
        data.east = !occludedDirections[3];
    }

    @Override
    public void submit(FluidTankRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.data != null) {
            state.data.translate(matrices);
            queue.method_73483(matrices, state.layer, state.data);
        }
    }

    @Override
    public boolean method_3563(/*FluidTankBlockEntity be*/) {
        //TODO
        //        return be.isController();
        return true;
    }

    public static class FluidTankRenderState extends class_11954 {
        public class_1921 layer;
        public RenderData data;
    }

    public interface RenderData extends class_11659.class_11660 {
        void translate(class_4587 matrices);
    }

    public static class FluidTankRenderData implements RenderData {
        public class_3611 fluid;
        public class_9326 changes;
        public float xMin, xMax, yMin, yMax, zMin, zMax, translateY;
        public int light;

        @Override
        public void translate(class_4587 matrices) {
            matrices.method_46416(0, translateY, 0);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            FluidRenderHelper.renderFluidBox(fluid, changes, xMin, yMin, zMin, xMax, yMax, zMax, vertexConsumer, matricesEntry, light, false, true);
        }
    }

    public static class BoilerRenderData implements RenderData {
        public float translateX, dialPivotY, dialPivotZ, progress, translateXZ;
        public SuperByteBuffer gauge, gaugeDial;
        public boolean south, west, north, east;
        public int light;

        @Override
        public void translate(class_4587 matrices) {
            matrices.method_22904(translateXZ, 0.5, translateXZ);
        }

        public void render(int yRot, class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            gauge.rotateYDegrees(yRot).uncenter().translate(translateX, 0, 0).light(light).renderInto(matricesEntry, vertexConsumer);
            gaugeDial.rotateYDegrees(yRot).uncenter().translate(translateX, 0, 0).translate(0, dialPivotY, dialPivotZ).rotateXDegrees(progress)
                .translate(0, -dialPivotY, -dialPivotZ).light(light).renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (south) {
                render(-90, matricesEntry, vertexConsumer);
            }
            if (west) {
                render(-180, matricesEntry, vertexConsumer);
            }
            if (north) {
                render(-270, matricesEntry, vertexConsumer);
            }
            if (east) {
                render(-360, matricesEntry, vertexConsumer);
            }
        }
    }
}
