package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.kinetics.KineticDebugger;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class KineticBlockEntityRenderer<T extends KineticBlockEntity, S extends KineticBlockEntityRenderer.KineticRenderState> implements class_827<T, S> {

    public static final SuperByteBufferCache.Compartment<class_2680> KINETIC_BLOCK = new SuperByteBufferCache.Compartment<>();
    public static boolean rainbowMode = false;

    public KineticBlockEntityRenderer(class_5614.class_5615 context) {
    }

    @Override
    @SuppressWarnings("unchecked")
    public S method_74335() {
        return (S) new KineticRenderState();
    }

    @Override
    public void extractRenderState(
        T be,
        S state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_1937 world = be.method_10997();
        state.support = VisualizationManager.supportsVisualization(world);
        if (state.support) {
            return;
        }
        updateBaseRenderState(be, state, world, crumblingOverlay);
        state.model = getRotatedModel(be, state);
        state.angle = getAngleForBe(be, state.field_62673, state.axis);
    }

    public void updateBaseRenderState(T be, S state, class_1937 world, @Nullable class_11683.class_11792 crumblingOverlay) {
        state.field_62673 = be.method_11016();
        state.field_62674 = getRenderedBlockState(be);
        state.field_62675 = be.method_11017();
        state.field_62676 = world != null ? class_761.method_23794(world, state.field_62673) : class_765.field_32767;
        state.field_62677 = crumblingOverlay;
        state.layer = getRenderType(be, state.field_62674);
        state.axis = ((IRotate) state.field_62674.method_26204()).getRotationAxis(state.field_62674);
        state.direction = class_2350.method_10169(state.axis, class_2352.field_11056);
        state.color = getColor(be);
    }

    @Override
    public void submit(S state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.support) {
            return;
        }
        queue.method_73483(matrices, state.layer, state);
    }

    protected class_2680 getRenderedBlockState(T be) {
        return be.method_11010();
    }

    protected class_1921 getRenderType(T be, class_2680 state) {
        return class_4696.method_29359(state);
    }

    protected SuperByteBuffer getRotatedModel(T be, S state) {
        return CachedBuffers.block(KINETIC_BLOCK, state.field_62674);
    }

    public static float getAngleForBe(KineticBlockEntity be, final class_2338 pos, class_2351 axis) {
        float time = AnimationTickHolder.getRenderTime(be.method_10997());
        float offset = getRotationOffsetForPosition(be, pos, axis);
        return ((time * be.getSpeed() * 3f / 10 + offset) % 360) / 180 * (float) Math.PI;
    }

    public static Color getColor(KineticBlockEntity be) {
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            return be.network != null ? Color.generateFromLong(be.network) : Color.WHITE;
        } else {
            float overStressedEffect = be.effects.overStressedEffect;
            if (overStressedEffect != 0) {
                boolean overstressed = overStressedEffect > 0;
                Color color = overstressed ? Color.RED : Color.SPRING_GREEN;
                float weight = overstressed ? overStressedEffect : -overStressedEffect;
                return Color.WHITE.mixWith(color, weight);
            } else {
                return Color.WHITE;
            }
        }
    }

    public static float getRotationOffsetForPosition(KineticBlockEntity be, final class_2338 pos, final class_2351 axis) {
        return KineticBlockEntityVisual.rotationOffset(be.method_11010(), axis, pos) + be.getRotationAngleOffset(axis);
    }

    public static class_2680 shaft(class_2351 axis) {
        return AllBlocks.SHAFT.method_9564().method_11657(class_2741.field_12496, axis);
    }

    public static class_2351 getRotationAxisOf(KineticBlockEntity be) {
        return ((IRotate) be.method_11010().method_26204()).getRotationAxis(be.method_11010());
    }

    public static class KineticRenderState extends class_11954 implements class_11659.class_11660 {
        public boolean support;
        public class_1921 layer;
        public SuperByteBuffer model;
        public float angle;
        public class_2351 axis;
        public class_2350 direction;
        public Color color;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.light(field_62676);
            model.rotateCentered(angle, direction);
            model.color(color);
            model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
