package com.zurrtum.create.client.content.kinetics.belt;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.ShadowRenderHelper;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.belt.*;
import com.zurrtum.create.content.kinetics.belt.transport.BeltInventory;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class BeltRenderer implements class_827<BeltBlockEntity, BeltRenderer.BeltRenderState> {
    protected final class_10442 itemModelManager;

    public BeltRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public BeltRenderState method_74335() {
        return new BeltRenderState();
    }

    @Override
    public void extractRenderState(
        BeltBlockEntity be,
        BeltRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        class_1937 world = be.method_10997();
        float speed = be.getSpeed();
        boolean stopped = speed == 0;
        state.render = !VisualizationManager.supportsVisualization(world) && state.field_62674.method_27852(AllBlocks.BELT);
        if (state.render) {
            BeltSlope beltSlope = state.field_62674.method_11654(BeltBlock.SLOPE);
            BeltPart part = state.field_62674.method_11654(BeltBlock.PART);
            class_2350 facing = state.field_62674.method_11654(BeltBlock.HORIZONTAL_FACING);
            class_2352 axisDirection = facing.method_10171();

            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.method_10166() == class_2351.field_11048;

            state.localTransforms = new class_4587();
            var msr = TransformStack.of(state.localTransforms);
            state.layer = class_12249.method_75965();

            msr.center().rotateYDegrees(AngleHelper.horizontalAngle(facing) + (upward ? 180 : 0) + (sideways ? 270 : 0))
                .rotateZDegrees(sideways ? 90 : 0).rotateXDegrees(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90 : 0).uncenter();

            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == class_2352.field_11056) {
                boolean b = start;
                start = end;
                end = b;
            }
            class_1767 color = be.color.orElse(null);
            state.top = CachedBuffers.partial(getBeltPartial(diagonal, start, end, false), state.field_62674);
            boolean needScroll = !stopped || color != null;
            double scroll = 0;
            if (needScroll) {
                float time = AnimationTickHolder.getRenderTime(world) * axisDirection.method_10181();
                if (diagonal && (downward ^ alongX) || !sideways && !diagonal && alongX || sideways && axisDirection == class_2352.field_11060) {
                    speed = -speed;
                }
                scroll = speed * time / (31.5 * 16);
                float scrollMult = diagonal ? 3f / 8f : 0.5f;
                state.topShift = getSpriteShiftEntry(color, diagonal, false);
                class_1058 target = state.topShift.getTarget();
                float spriteSize = target.method_4575() - target.method_4593();
                state.topScroll = (float) ((scroll - Math.floor(scroll)) * spriteSize * scrollMult);
            }
            if (!diagonal) {
                state.bottom = CachedBuffers.partial(getBeltPartial(false, start, end, true), state.field_62674);
                if (needScroll) {
                    scroll += 0.5;
                    state.bottomShift = getSpriteShiftEntry(color, false, true);
                    class_1058 target = state.bottomShift.getTarget();
                    float spriteSize = target.method_4575() - target.method_4593();
                    state.bottomScroll = (float) ((scroll - Math.floor(scroll)) * spriteSize * 0.5f);
                }
            }
            if (be.hasPulley()) {
                class_2350 dir = sideways ? class_2350.field_11036 : facing.method_10170();

                Supplier<class_4587> matrixStackSupplier = () -> {
                    class_4587 stack = new class_4587();
                    var stacker = TransformStack.of(stack);
                    stacker.center();
                    if (dir.method_10166() == class_2351.field_11048)
                        stacker.rotateYDegrees(90);
                    if (dir.method_10166() == class_2351.field_11052)
                        stacker.rotateXDegrees(90);
                    stacker.rotateXDegrees(90);
                    stacker.uncenter();
                    return stack;
                };

                state.pulley = CachedBuffers.partialDirectional(AllPartialModels.BELT_PULLEY, state.field_62674, dir, matrixStackSupplier);
                class_2351 axis = ((IRotate) state.field_62674.method_26204()).getRotationAxis(state.field_62674);
                state.pulleyAngle = KineticBlockEntityRenderer.getAngleForBe(be, state.field_62673, axis);
                state.pulleyDirection = class_2350.method_10156(class_2352.field_11056, axis);
                state.pulleyColor = KineticBlockEntityRenderer.getColor(be);
            }
        }
        state.beltLength = be.isController() ? be.beltLength : 0;
        if (state.beltLength != 0) {
            BeltInventory inventory = be.getInventory();
            List<TransportedItemStack> transportedItems = inventory.getTransportedItems();
            TransportedItemStack lazyClientItem = inventory.getLazyClientItem();
            int transportedSize = transportedItems.size();
            BeltItemState[] items;
            if (transportedSize == 0 && lazyClientItem == null) {
                state.beltLength = 0;
                return;
            }
            items = new BeltItemState[lazyClientItem == null ? transportedSize : transportedSize + 1];
            state.items = items;
            state.beltFacing = be.getBeltFacing();
            state.directionVec = state.beltFacing.method_62675();
            state.beltStartOffset = class_243.method_24954(state.directionVec).method_1021(-.5).method_1031(.5, 15 / 16f, .5);
            state.slope = state.field_62674.method_11654(BeltBlock.SLOPE);
            state.verticality = state.slope == BeltSlope.DOWNWARD ? -1 : state.slope == BeltSlope.UPWARD ? 1 : 0;
            state.slopeAlongX = state.beltFacing.method_10166() == class_2351.field_11048;
            state.partialTicks = tickProgress;
            state.camera = cameraPos;
            state.onContraption = world instanceof WrappedLevel;
            state.onPonder = world instanceof PonderLevel;
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            for (int i = 0; i < transportedSize; i++) {
                items[i] = BeltItemState.create(itemModelManager, transportedItems.get(i), state, stopped, world, mutablePos);
            }
            if (lazyClientItem != null) {
                items[transportedSize] = BeltItemState.create(itemModelManager, lazyClientItem, state, stopped, world, mutablePos);
            }
        }
    }

    @Override
    public void submit(BeltRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.render) {
            queue.method_73483(matrices, state.layer, state);
        }
        if (state.beltLength != 0) {
            class_243 beltStartOffset = state.beltStartOffset;
            matrices.method_22904(beltStartOffset.field_1352, beltStartOffset.field_1351, beltStartOffset.field_1350);
            for (BeltItemState item : state.items) {
                renderItem(state, item, matrices, queue);
            }
        }
    }

    @Override
    public boolean method_3563(/*BeltBlockEntity be*/) {
        //TODO
        //        return be.isController();
        return true;
    }

    public static SpriteShiftEntry getSpriteShiftEntry(class_1767 color, boolean diagonal, boolean bottom) {
        if (color != null) {
            return (diagonal ? AllSpriteShifts.DYED_DIAGONAL_BELTS : bottom ? AllSpriteShifts.DYED_OFFSET_BELTS : AllSpriteShifts.DYED_BELTS).get(
                color);
        } else
            return diagonal ? AllSpriteShifts.BELT_DIAGONAL : bottom ? AllSpriteShifts.BELT_OFFSET : AllSpriteShifts.BELT;
    }

    public static PartialModel getBeltPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start)
                return AllPartialModels.BELT_DIAGONAL_START;
            if (end)
                return AllPartialModels.BELT_DIAGONAL_END;
            return AllPartialModels.BELT_DIAGONAL_MIDDLE;
        } else if (bottom) {
            if (start)
                return AllPartialModels.BELT_START_BOTTOM;
            if (end)
                return AllPartialModels.BELT_END_BOTTOM;
            return AllPartialModels.BELT_MIDDLE_BOTTOM;
        } else {
            if (start)
                return AllPartialModels.BELT_START;
            if (end)
                return AllPartialModels.BELT_END;
            return AllPartialModels.BELT_MIDDLE;
        }
    }

    @SuppressWarnings("SuspiciousNameCombination")
    private void renderItem(BeltRenderState state, BeltItemState item, class_4587 ms, class_11659 queue) {
        float offset = item.offset;
        float verticalMovement;
        if (offset < .5)
            verticalMovement = 0;
        else
            verticalMovement = state.verticality * (Math.min(offset, state.beltLength - .5f) - .5f);
        class_243 offsetVec = class_243.method_24954(state.directionVec).method_1021(offset);
        if (verticalMovement != 0)
            offsetVec = offsetVec.method_1031(0, verticalMovement, 0);
        boolean onSlope = state.slope != BeltSlope.HORIZONTAL && class_3532.method_15363(offset, .5f, state.beltLength - .5f) == offset;
        boolean tiltForward = (state.slope == BeltSlope.DOWNWARD ^ state.beltFacing.method_10171() == class_2352.field_11056) == (state.beltFacing.method_10166() == class_2351.field_11051);
        float slopeAngle = onSlope ? tiltForward ? -45 : 45 : 0;

        class_2338 pos = state.field_62673;
        class_243 itemPos = state.beltStartOffset.method_1031(pos.method_10263(), pos.method_10264(), pos.method_10260()).method_1019(offsetVec);

        ms.method_22903();
        TransformStack.of(ms).nudge(item.angle);
        ms.method_22904(offsetVec.field_1352, offsetVec.field_1351, offsetVec.field_1350);

        boolean alongX = state.beltFacing.method_10170().method_10166() == class_2351.field_11048;
        float sideOffset = item.sideOffset;
        if (!alongX)
            sideOffset *= -1;
        ms.method_46416(alongX ? sideOffset : 0, 0, alongX ? 0 : sideOffset);

        int stackLight;
        if (state.onContraption) {
            stackLight = state.field_62676;
        } else {
            stackLight = item.light;
        }

        boolean renderUpright = item.upright;
        boolean blockItem = item.state.method_65608();

        int count = 0;
        if (state.onPonder || state.camera.method_1022(itemPos) < 16)
            count = class_3532.method_15351(item.count) / 2;

        Random r = new Random(item.angle);

        boolean slopeShadowOnly = renderUpright && onSlope;
        float slopeOffset = 1 / 8f;
        if (slopeShadowOnly)
            ms.method_22903();
        if (!renderUpright || slopeShadowOnly)
            ms.method_22907((state.slopeAlongX ? net.minecraft.class_7833.field_40718 : net.minecraft.class_7833.field_40714).rotationDegrees(slopeAngle));
        if (onSlope)
            ms.method_46416(0, slopeOffset, 0);
        ms.method_22903();
        ms.method_46416(0, -1 / 8f + 0.005f, 0);
        ShadowRenderHelper.renderShadow(ms, queue, .75f, .2f);
        ms.method_22909();
        if (slopeShadowOnly) {
            ms.method_22909();
            ms.method_46416(0, slopeOffset, 0);
        }

        if (renderUpright) {
            class_243 vectorForOffset = BeltHelper.getVectorForOffset(
                state.field_62673,
                state.slope,
                state.verticality,
                state.beltLength,
                state.directionVec,
                offset
            );
            class_243 diff = vectorForOffset.method_1020(state.camera);
            float yRot = (float) (class_3532.method_15349(diff.field_1352, diff.field_1350) + Math.PI);
            ms.method_22907(net.minecraft.class_7833.field_40716.rotation(yRot));
            ms.method_22904(0, 3 / 32d, 1 / 16f);
        }

        for (int i = 0; i <= count; i++) {
            ms.method_22903();

            ms.method_22907(net.minecraft.class_7833.field_40716.rotationDegrees(item.angle));
            if (!blockItem && !renderUpright) {
                ms.method_22904(0, -.09375, 0);
                ms.method_22907(net.minecraft.class_7833.field_40714.rotationDegrees(90));
            }

            if (blockItem && !item.box)
                ms.method_46416(r.nextFloat() * .0625f * i, 0, r.nextFloat() * .0625f * i);

            if (item.box) {
                ms.method_46416(0, 4 / 16f, 0);
                ms.method_22905(1.5f, 1.5f, 1.5f);
            } else {
                ms.method_22905(.5f, .5f, .5f);
            }

            item.state.method_65604(ms, queue, stackLight, class_4608.field_21444, 0);
            ms.method_22909();

            if (!renderUpright) {
                if (!blockItem)
                    ms.method_22907(net.minecraft.class_7833.field_40716.rotationDegrees(10));
                ms.method_22904(0, blockItem ? 1 / 64d : 1 / 16d, 0);
            } else
                ms.method_46416(0, 0, -1 / 16f);

        }

        ms.method_22909();
    }

    public static class BeltRenderState extends class_11954 implements class_11659.class_11660 {
        public boolean render;
        public class_1921 layer;
        public class_4587 localTransforms;
        public SuperByteBuffer top;
        public SpriteShiftEntry topShift;
        public float topScroll;
        public SuperByteBuffer bottom;
        public SpriteShiftEntry bottomShift;
        public float bottomScroll;
        public SuperByteBuffer pulley;
        public float pulleyAngle;
        public class_2350 pulleyDirection;
        public Color pulleyColor;
        public int beltLength;
        public BeltItemState[] items;
        public class_2350 beltFacing;
        public boolean onContraption;
        public class_2382 directionVec;
        public class_243 beltStartOffset;
        public BeltSlope slope;
        public int verticality;
        public boolean slopeAlongX;
        public float partialTicks;
        public class_243 camera;
        boolean onPonder;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            top.light(field_62676);
            if (topShift != null) {
                top.shiftUVScrolling(topShift, topScroll);
            }
            top.transform(localTransforms);
            top.renderInto(matricesEntry, vertexConsumer);
            if (bottom != null) {
                bottom.light(field_62676);
                if (bottomShift != null) {
                    bottom.shiftUVScrolling(bottomShift, bottomScroll);
                }
                bottom.transform(localTransforms);
                bottom.renderInto(matricesEntry, vertexConsumer);
            }
            if (pulley != null) {
                pulley.light(field_62676);
                pulley.rotateCentered(pulleyAngle, pulleyDirection);
                pulley.color(pulleyColor);
                pulley.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    public record BeltItemState(
        class_10444 state, float offset, float sideOffset, Integer light, boolean upright, boolean box, int angle, int count
    ) {
        public static BeltItemState create(
            class_10442 itemModelManager,
            TransportedItemStack transported,
            BeltRenderState state,
            boolean stopped,
            class_1937 world,
            class_2338.class_2339 mutablePos
        ) {
            float offset, sideOffset;
            if (stopped) {
                offset = transported.beltPosition;
                sideOffset = transported.sideOffset;
            } else {
                offset = class_3532.method_16439(state.partialTicks, transported.prevBeltPosition, transported.beltPosition);
                sideOffset = class_3532.method_16439(state.partialTicks, transported.prevSideOffset, transported.sideOffset);
            }
            Integer light;
            if (state.onContraption) {
                light = null;
            } else {
                int segment = (int) Math.floor(offset);
                mutablePos.method_10101(state.field_62673)
                    .method_10100(state.directionVec.method_10263() * segment, state.verticality * segment, state.directionVec.method_10260() * segment);
                light = world != null ? class_761.method_23794(world, mutablePos) : class_765.field_32767;
            }
            class_1799 stack = transported.stack;
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(renderState, stack, class_811.field_4319, null, null, 0);
            boolean upright = BeltHelper.isItemUpright(transported.stack);
            boolean box = PackageItem.isPackage(transported.stack);
            return new BeltItemState(renderState, offset, sideOffset, light, upright, box, transported.angle, stack.method_7947());
        }
    }
}
