package com.zurrtum.create.client.content.kinetics.belt;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.content.processing.burner.ScrollInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

import java.util.function.Consumer;
import net.minecraft.class_1767;
import net.minecraft.class_2350;
import net.minecraft.class_3532;

public class BeltVisual extends KineticBlockEntityVisual<BeltBlockEntity> {
    public static final float MAGIC_SCROLL_MULTIPLIER = 1f / (31.5f * 16f);
    public static final float SCROLL_FACTOR_DIAGONAL = 3f / 8f;
    public static final float SCROLL_FACTOR_OTHERWISE = 0.5f;
    public static final float SCROLL_OFFSET_BOTTOM = 0.5f;
    public static final float SCROLL_OFFSET_OTHERWISE = 0f;

    protected final ScrollInstance[] belts;
    @Nullable
    protected final RotatingInstance pulley;

    public BeltVisual(VisualizationContext context, BeltBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);


        BeltPart part = blockState.method_11654(BeltBlock.PART);
        boolean start = part == BeltPart.START;
        boolean end = part == BeltPart.END;
        class_1767 color = blockEntity.color.orElse(null);

        boolean diagonal = blockState.method_11654(BeltBlock.SLOPE).isDiagonal();
        belts = new ScrollInstance[diagonal ? 1 : 2];

        for (boolean bottom : Iterate.trueAndFalse) {
            PartialModel beltPartial = BeltRenderer.getBeltPartial(diagonal, start, end, bottom);
            SpriteShiftEntry spriteShift = BeltRenderer.getSpriteShiftEntry(color, diagonal, bottom);

            Instancer<ScrollInstance> beltModel = instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial(beltPartial));

            belts[bottom ? 0 : 1] = setup(beltModel.createInstance(), bottom, spriteShift);

            if (diagonal)
                break;
        }

        if (blockEntity.hasPulley()) {
            pulley = instancerProvider().instancer(AllInstanceTypes.ROTATING, getPulleyModel()).createInstance();

            pulley.setup(BeltVisual.this.blockEntity).setPosition(getVisualPosition()).setChanged();
        } else {
            pulley = null;
        }
    }

    @Override
    public void update(float pt) {
        class_1767 color = blockEntity.color.orElse(null);

        boolean diagonal = blockState.method_11654(BeltBlock.SLOPE).isDiagonal();

        boolean bottom = true;
        for (ScrollInstance key : belts) {
            setup(key, bottom, BeltRenderer.getSpriteShiftEntry(color, diagonal, bottom));
            bottom = false;
        }

        if (pulley != null) {
            pulley.setup(blockEntity).setChanged();
        }
    }

    @Override
    public void updateLight(float partialTick) {
        relight(belts);

        if (pulley != null)
            relight(pulley);
    }

    @Override
    protected void _delete() {
        for (var key : belts) {
            key.delete();
        }
        if (pulley != null) {
            pulley.delete();
        }
    }

    private Model getPulleyModel() {
        class_2350 dir = getOrientation();

        return Models.partial(
            AllPartialModels.BELT_PULLEY, dir.method_10166(), (axis11, modelTransform1) -> {
                var msr = TransformStack.of(modelTransform1);
                msr.center();
                if (axis11 == class_2350.class_2351.field_11048)
                    msr.rotateYDegrees(90);
                if (axis11 == class_2350.class_2351.field_11052)
                    msr.rotateXDegrees(90);
                msr.rotateXDegrees(90);
                msr.uncenter();
            }
        );
    }

    private class_2350 getOrientation() {
        class_2350 dir = blockState.method_11654(BeltBlock.HORIZONTAL_FACING).method_10170();

        if (blockState.method_11654(BeltBlock.SLOPE) == BeltSlope.SIDEWAYS)
            dir = class_2350.field_11036;

        return dir;
    }

    private ScrollInstance setup(ScrollInstance key, boolean bottom, SpriteShiftEntry spriteShift) {
        BeltSlope beltSlope = blockState.method_11654(BeltBlock.SLOPE);
        class_2350 facing = blockState.method_11654(BeltBlock.HORIZONTAL_FACING);
        boolean diagonal = beltSlope.isDiagonal();
        boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
        boolean vertical = beltSlope == BeltSlope.VERTICAL;
        boolean upward = beltSlope == BeltSlope.UPWARD;
        boolean alongX = facing.method_10166() == class_2350.class_2351.field_11048;
        boolean alongZ = facing.method_10166() == class_2350.class_2351.field_11051;
        boolean downward = beltSlope == BeltSlope.DOWNWARD;

        float speed = blockEntity.getSpeed();
        if (((facing.method_10171() == class_2350.class_2352.field_11060) ^ upward) ^ ((alongX && !diagonal) || (alongZ && diagonal))) {
            speed = -speed;
        }
        if (sideways && (facing == class_2350.field_11035 || facing == class_2350.field_11039) || (vertical && facing == class_2350.field_11034)) {
            speed = -speed;
        }

        float rotX = (!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90 : 0) + (downward ? 180 : 0) + (sideways ? 90 : 0) + (vertical && alongZ ? 180 : 0);
        float rotY = facing.method_10144() + ((diagonal ^ alongX) && !downward ? 180 : 0) + (sideways && alongZ ? 180 : 0) + (vertical && alongX ? 90 : 0);
        float rotZ = (sideways ? 90 : 0) + (vertical && alongX ? 90 : 0);

        Quaternionf q = new Quaternionf().rotationXYZ(rotX * class_3532.field_29847, rotY * class_3532.field_29847, rotZ * class_3532.field_29847);

        key.setSpriteShift(spriteShift, 1f, (diagonal ? SCROLL_FACTOR_DIAGONAL : SCROLL_FACTOR_OTHERWISE)).position(getVisualPosition()).rotation(q)
            .speed(0, speed * MAGIC_SCROLL_MULTIPLIER).offset(0, bottom ? SCROLL_OFFSET_BOTTOM : SCROLL_OFFSET_OTHERWISE)
            .colorRgb(RotatingInstance.colorFromBE(blockEntity)).setChanged();

        return key;
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        if (pulley != null) {
            consumer.accept(pulley);
        }
        for (var key : belts) {
            consumer.accept(key);
        }
    }
}
