package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBehaviour;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class ChainConveyorClientBehaviour extends ChainConveyorBehaviour {
    // Client tracks physics data by id so it can travel between BEs
    private static final int ticksUntilExpired = 30;
    public static final WorldAttached<Cache<Integer, ChainConveyorPackagePhysicsData>> physicsDataCache = new WorldAttached<>($ -> new TickBasedCache<>(ticksUntilExpired,
        true
    ));

    public static ChainConveyorPackagePhysicsData physicsData(ChainConveyorPackage box, class_1936 level) {
        if (box.physicsData == null) {
            try {
                ChainConveyorPackagePhysicsData physicsData = physicsDataCache.get(level).get(box.netId, ChainConveyorPackagePhysicsData::new);
                box.physicsData = physicsData;
                return physicsData;
            } catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        physicsDataCache.get(level).getIfPresent(box.netId);
        return (ChainConveyorPackagePhysicsData) box.physicsData;
    }

    public ChainConveyorClientBehaviour(ChainConveyorBlockEntity be) {
        super(be);
    }

    @Override
    public void blockEntityTickBoxVisuals() {
        // We can use TickableVisuals if flywheel is enabled
        if (!VisualizationManager.supportsVisualization(blockEntity.method_10997()))
            tickBoxVisuals();
    }

    @Override
    public void tickBoxVisuals() {
        for (ChainConveyorPackage box : blockEntity.getLoopingPackages())
            tickBoxVisuals(box);
        for (Map.Entry<class_2338, List<ChainConveyorPackage>> entry : blockEntity.getTravellingPackages().entrySet())
            for (ChainConveyorPackage box : entry.getValue())
                tickBoxVisuals(box);
    }

    private void tickBoxVisuals(ChainConveyorPackage box) {
        if (box.worldPosition == null)
            return;

        ChainConveyorPackagePhysicsData physicsData = physicsData(box, blockEntity.method_10997());
        physicsData.setBE(blockEntity);

        if (!physicsData.shouldTick() && !blockEntity.isVirtual())
            return;

        physicsData.prevTargetPos = physicsData.targetPos;
        physicsData.prevPos = physicsData.pos;
        physicsData.prevYaw = physicsData.yaw;
        physicsData.flipped = blockEntity.reversed;

        if (physicsData.pos != null) {
            if (physicsData.pos.method_1025(box.worldPosition) > 1.5f * 1.5f)
                physicsData.pos = box.worldPosition.method_1019(physicsData.pos.method_1020(box.worldPosition).method_1029().method_1021(1.5));
            physicsData.motion = physicsData.motion.method_1031(0, -0.25, 0).method_1021(0.75).method_1019((box.worldPosition.method_1020(physicsData.pos)).method_1021(0.25));
            physicsData.pos = physicsData.pos.method_1019(physicsData.motion);
        }

        physicsData.targetPos = box.worldPosition.method_1023(0, 9 / 16f, 0);

        if (physicsData.pos == null) {
            physicsData.pos = physicsData.targetPos;
            physicsData.prevPos = physicsData.targetPos;
            physicsData.prevTargetPos = physicsData.targetPos;
        }

        physicsData.yaw = AngleHelper.angleLerp(.25, physicsData.yaw, box.yaw);
    }

    @Override
    public void updateChainShapes() {
        List<ChainConveyorShape> shapes = new ArrayList<>();
        shapes.add(new ChainConveyorShape.ChainConveyorBB(class_243.method_24955(class_2338.field_10980)));
        class_2338 pos = blockEntity.method_11016();
        for (class_2338 target : blockEntity.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = blockEntity.connectionStats.get(target);
            if (stats == null)
                continue;
            class_243 localStart = stats.start().method_1020(class_243.method_24954(pos));
            class_243 localEnd = stats.end().method_1020(class_243.method_24954(pos));
            shapes.add(new ChainConveyorShape.ChainConveyorOBB(target, localStart, localEnd));
        }
        ChainConveyorInteractionHandler.loadedChains.get(blockEntity.method_10997()).put(pos, shapes);
    }

    @Override
    public void invalidate() {
        ChainConveyorInteractionHandler.loadedChains.get(blockEntity.method_10997()).invalidate(blockEntity.method_11016());
    }
}
