package com.zurrtum.create.client.content.kinetics.deployer;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer.FilterRenderState;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.State;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

import static com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE;
import static com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock.FACING;

public class DeployerRenderer implements class_827<DeployerBlockEntity, DeployerRenderer.DeployerRenderState> {
    protected final class_10442 itemModelManager;

    public DeployerRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public DeployerRenderState method_74335() {
        return new DeployerRenderState();
    }

    @Override
    public void extractRenderState(
        DeployerBlockEntity be,
        DeployerRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        class_1937 world = be.method_10997();
        updateItemRenderState(be, state, itemModelManager, world, tickProgress);
        state.filter = FilteringRenderer.getFilterRenderState(
            be,
            state.field_62674,
            itemModelManager,
            be.isVirtual() ? -1 : cameraPos.method_1025(VecHelper.getCenterOf(state.field_62673))
        );
        updateComponentsRenderState(be, state, world, tickProgress);
    }

    public static void updateItemRenderState(
        DeployerBlockEntity be,
        DeployerRenderState state,
        class_10442 itemModelManager,
        class_1937 world,
        float tickProgress
    ) {
        class_1799 heldItem = be.heldItem;
        if (heldItem.method_7960()) {
            return;
        }
        DeployerItemRenderState data = state.item = new DeployerItemRenderState();
        data.offset = getHandOffset(state, be, tickProgress, state.field_62674).method_1019(VecHelper.getCenterOf(class_2338.field_10980));
        class_2350 facing = state.field_62674.method_11654(FACING);
        data.punching = be.mode == Mode.PUNCH;
        data.yRot = class_3532.field_29847 * (AngleHelper.horizontalAngle(facing) + 180);
        data.xRot = class_3532.field_29847 * (facing == class_2350.field_11036 ? 90 : facing == class_2350.field_11033 ? 270 : 0);
        data.displayMode = facing == class_2350.field_11036 && be.getSpeed() == 0 && !data.punching;
        class_10444 renderState = data.state = new class_10444();
        if (data.displayMode) {
            renderState.field_55337 = class_811.field_4318;
        } else {
            renderState.field_55337 = data.punching ? class_811.field_4320 : class_811.field_4319;
        }
        itemModelManager.method_65596(renderState, heldItem, renderState.field_55337, world, null, 0);
        boolean isBlockItem = (heldItem.method_7909() instanceof class_1747) && renderState.method_65608();
        if (data.displayMode) {
            data.translateY = isBlockItem ? 9 / 16f : 11 / 16f;
            data.scale = isBlockItem ? 1.25f : 1;
            data.yRot2 = class_3532.field_29847 * AnimationTickHolder.getRenderTime(world);
        } else {
            data.scale = data.punching ? .75f : isBlockItem ? .75f - 1 / 64f : .5f;
        }
    }

    public static void updateComponentsRenderState(DeployerBlockEntity be, DeployerRenderState state, class_1937 world, float tickProgress) {
        if (VisualizationManager.supportsVisualization(world)) {
            return;
        }
        ComponentsRenderState components = state.components = new ComponentsRenderState();
        components.layer = class_12249.method_75965();
        components.light = state.field_62676;
        class_2351 axis = ((IRotate) state.field_62674.method_26204()).getRotationAxis(state.field_62674);
        components.shaft = CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
        components.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.field_62673, axis);
        components.direction = class_2350.method_10169(axis, class_2352.field_11056);
        components.color = KineticBlockEntityRenderer.getColor(be);
        components.offset = getHandOffset(state, be, tickProgress, state.field_62674);
        components.pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, state.field_62674);
        components.hand = CachedBuffers.partial(getHandPose(be), state.field_62674);
        class_2350 facing = state.field_62674.method_11654(FACING);
        components.yRot = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
        components.xRot = class_3532.field_29847 * (facing == class_2350.field_11036 ? 270 : facing == class_2350.field_11033 ? 90 : 0);
        components.zRot = class_3532.field_29847 * ((state.field_62674.method_11654(AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2351.field_11051) ? 90 : 0);
    }

    @Override
    public void submit(DeployerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.item != null) {
            state.item.render(matrices, queue, state.field_62676);
        }
        if (state.filter != null) {
            state.filter.render(state.field_62674, queue, matrices, state.field_62676);
        }
        if (state.components != null) {
            queue.method_73483(matrices, state.components.layer, state.components);
        }
    }

    public static PartialModel getHandPose(DeployerBlockEntity be) {
        return be.mode == Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : be.heldItem.method_7960() ? AllPartialModels.DEPLOYER_HAND_POINTING : AllPartialModels.DEPLOYER_HAND_HOLDING;
    }

    public static class_243 getHandOffset(DeployerRenderState state, DeployerBlockEntity be, float partialTicks, class_2680 blockState) {
        if (state.offset != null) {
            return state.offset;
        }
        return state.offset = getHandOffset(be, partialTicks, blockState);
    }

    public static class_243 getHandOffset(DeployerBlockEntity be, float partialTicks, class_2680 blockState) {
        float distance = getHandOffset(be, partialTicks);
        return class_243.method_24954(blockState.method_11654(FACING).method_62675()).method_1021(distance);
    }

    public static float getHandOffset(DeployerBlockEntity be, float partialTicks) {
        if (be.isVirtual())
            return be.animatedOffset.getValue(partialTicks);

        float progress = 0;
        int timerSpeed = be.getTimerSpeed();
        PartialModel handPose = getHandPose(be);

        if (be.state == State.EXPANDING) {
            progress = 1 - (be.timer - partialTicks * timerSpeed) / 1000f;
            if (be.fistBump)
                progress *= progress;
        }
        if (be.state == State.RETRACTING)
            progress = (be.timer - partialTicks * timerSpeed) / 1000f;
        float handLength = handPose == AllPartialModels.DEPLOYER_HAND_POINTING ? 0 : handPose == AllPartialModels.DEPLOYER_HAND_HOLDING ? 4 / 16f : 3 / 16f;
        return Math.min(class_3532.method_15363(progress, 0, 1) * (be.reach + handLength), 21 / 16f);
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, class_2680 deployerState, boolean axisDirectionMatters) {
        class_2350 facing = deployerState.method_11654(FACING);

        float yRot = AngleHelper.horizontalAngle(facing);
        float xRot = facing == class_2350.field_11036 ? 270 : facing == class_2350.field_11033 ? 90 : 0;
        float zRot = axisDirectionMatters && (deployerState.method_11654(AXIS_ALONG_FIRST_COORDINATE) ^ facing.method_10166() == class_2351.field_11051) ? 90 : 0;

        buffer.rotateCentered((float) ((yRot) / 180 * Math.PI), class_2350.field_11036);
        buffer.rotateCentered((float) ((xRot) / 180 * Math.PI), class_2350.field_11034);
        buffer.rotateCentered((float) ((zRot) / 180 * Math.PI), class_2350.field_11035);
        return buffer;
    }

    static PartialModel getHandPose(Mode mode) {
        return mode == Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : AllPartialModels.DEPLOYER_HAND_POINTING;
    }

    public static class DeployerRenderState extends class_11954 {
        public class_243 offset;
        public DeployerItemRenderState item;
        public FilterRenderState filter;
        public ComponentsRenderState components;
    }

    public static class DeployerItemRenderState {
        public class_243 offset;
        public boolean punching;
        public float yRot;
        public float xRot;
        public boolean displayMode;
        public class_10444 state;
        public float translateY;
        public float scale;
        public float yRot2;

        public void render(class_4587 matrices, class_11659 queue, int light) {
            matrices.method_22903();
            matrices.method_61958(offset);
            matrices.method_22907(net.minecraft.class_7833.field_40716.rotation(yRot));
            if (!displayMode) {
                matrices.method_22907(net.minecraft.class_7833.field_40714.rotation(xRot));
                matrices.method_46416(0, 0, -11 / 16f);
            }
            if (punching) {
                matrices.method_46416(0, 1 / 8f, -1 / 16f);
            }
            if (displayMode) {
                matrices.method_46416(0, translateY, 0);
                matrices.method_22905(scale, scale, scale);
                matrices.method_22907(net.minecraft.class_7833.field_40716.rotation(yRot2));
            } else {
                matrices.method_22905(scale, scale, scale);
            }
            state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
            matrices.method_22909();
        }
    }

    public static class ComponentsRenderState implements class_11659.class_11660 {
        public class_1921 layer;
        public int light;
        public SuperByteBuffer shaft;
        public float angle;
        public class_2350 direction;
        public Color color;
        public class_243 offset;
        public SuperByteBuffer pole;
        public SuperByteBuffer hand;
        public float yRot;
        public float xRot;
        public float zRot;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            shaft.light(light).rotateCentered(angle, direction).color(color).renderInto(matricesEntry, vertexConsumer);
            pole.translate(offset).rotateCentered(yRot, class_2350.field_11036).rotateCentered(xRot, class_2350.field_11034).rotateCentered(zRot, class_2350.field_11035)
                .light(light).renderInto(matricesEntry, vertexConsumer);
            hand.translate(offset).rotateCentered(yRot, class_2350.field_11036).rotateCentered(xRot, class_2350.field_11034).light(light)
                .renderInto(matricesEntry, vertexConsumer);
        }
    }
}
