package com.zurrtum.create.client.content.kinetics.fan;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.fan.EncasedFanBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

import static net.minecraft.class_2741.field_12525;

public class EncasedFanRenderer implements class_827<EncasedFanBlockEntity, EncasedFanRenderer.EncasedFanRenderState> {
    public EncasedFanRenderer(class_5614.class_5615 context) {
    }

    @Override
    public EncasedFanRenderState method_74335() {
        return new EncasedFanRenderState();
    }

    @Override
    public void extractRenderState(
        EncasedFanBlockEntity be,
        EncasedFanRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        state.field_62673 = be.method_11016();
        state.field_62674 = be.method_11010();
        state.field_62675 = be.method_11017();
        state.field_62677 = crumblingOverlay;
        state.layer = class_12249.method_75972();
        class_2350 direction = state.field_62674.method_11654(field_12525);
        class_2350 opposite = direction.method_10153();
        class_1937 world = be.method_10997();
        if (world != null) {
            state.lightBehind = class_761.method_23794(world, state.field_62673.method_10093(opposite));
            state.lightInFront = class_761.method_23794(world, state.field_62673.method_10093(direction));
        } else {
            state.lightBehind = state.lightInFront = class_765.field_32767;
        }
        state.shaftHalf = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, opposite);
        state.fanInner = CachedBuffers.partialFacing(AllPartialModels.ENCASED_FAN_INNER, state.field_62674, opposite);
        float time = AnimationTickHolder.getRenderTime(world);
        float speed = be.getSpeed() * 5;
        if (speed > 0)
            speed = class_3532.method_15363(speed, 80, 64 * 20);
        if (speed < 0)
            speed = class_3532.method_15363(speed, -64 * 20, -80);
        float angle = (time * speed * 3 / 10f) % 360;
        class_2350.class_2351 axis = ((IRotate) state.field_62674.method_26204()).getRotationAxis(state.field_62674);
        state.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.field_62673, axis);
        state.direction = class_2350.method_10169(axis, class_2350.class_2352.field_11056);
        state.color = KineticBlockEntityRenderer.getColor(be);
        state.fanAngle = angle / 180f * (float) Math.PI;
    }

    @Override
    public void submit(EncasedFanRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static class EncasedFanRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public int lightBehind;
        public int lightInFront;
        public SuperByteBuffer shaftHalf;
        public float angle;
        public class_2350 direction;
        public Color color;
        public SuperByteBuffer fanInner;
        public float fanAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            shaftHalf.light(lightBehind);
            shaftHalf.rotateCentered(angle, direction);
            shaftHalf.color(color);
            shaftHalf.renderInto(matricesEntry, vertexConsumer);
            fanInner.light(lightInFront);
            fanInner.rotateCentered(fanAngle, direction);
            fanInner.color(color);
            fanInner.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
