package com.zurrtum.create.client.content.kinetics.mechanicalArm;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlock;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.zurrtum.create.content.kinetics.mechanicalArm.ArmBlockEntity.Phase;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;

public class ArmRenderer extends KineticBlockEntityRenderer<ArmBlockEntity, ArmRenderer.ArmRenderState> {
    protected static class_10442 itemModelManager;

    public ArmRenderer(class_5614.class_5615 context) {
        super(context);
        itemModelManager = context.comp_4536();
    }

    @Override
    public ArmRenderState createRenderState() {
        return new ArmRenderState();
    }

    @Override
    public void extractRenderState(
        ArmBlockEntity be,
        ArmRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1799 item = be.heldItem;
        boolean empty = item.method_7960();
        if (state.support) {
            if (empty) {
                return;
            }
            class_11954.method_74399(be, state, crumblingOverlay);
        }
        class_1937 world = be.method_10997();
        boolean isBlockItem;
        if (empty) {
            isBlockItem = false;
        } else {
            ArmItemData data = state.item = new ArmItemData();
            class_10444 renderState = new class_10444();
            renderState.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(renderState, item, renderState.field_55337, world, null, 0);
            isBlockItem = item.method_7909() instanceof class_1747 && renderState.method_65608();
            data.state = renderState;
            data.xRot = class_3532.field_29847 * 90;
            if (isBlockItem) {
                data.offset = -9 / 16f;
                data.scale = .5f;
            } else {
                data.offset = -10 / 16f;
                data.scale = .625f;
            }
        }
        boolean inverted = state.blockState.getValue(ArmBlock.CEILING);
        if (inverted) {
            state.rotate = class_3532.field_29847 * 180;
        }
        boolean rave = be.phase == Phase.DANCING && be.getSpeed() != 0;
        if (rave) {
            float renderTick = AnimationTickHolder.getRenderTime(world) + (be.hashCode() % 64);
            state.baseAngle = class_3532.field_29847 * ((renderTick * 10) % 360);
            state.lowerArmAngle = class_3532.field_29847 * (class_3532.method_48781((class_3532.method_15374(renderTick / 4) + 1) / 2, -45, 15) - 135);
            state.upperArmAngle = class_3532.field_29847 * (class_3532.method_48781((class_3532.method_15374(renderTick / 8) + 1) / 4, -45, 95) - 90);
            state.headAngle = class_3532.field_29847 * (-state.lowerArmAngle - 45);
        } else {
            state.baseAngle = class_3532.field_29847 * be.baseAngle.getValue(tickProgress);
            state.lowerArmAngle = class_3532.field_29847 * be.lowerArmAngle.getValue(tickProgress);
            state.upperArmAngle = class_3532.field_29847 * (be.upperArmAngle.getValue(tickProgress) - 180);
            state.headAngle = class_3532.field_29847 * (be.headAngle.getValue(tickProgress) - 45);
        }
        if (!state.support) {
            ArmRenderData data = state.arm = new ArmRenderData();
            boolean goggles = be.goggles;
            data.base = CachedBuffers.partial(AllPartialModels.ARM_BASE, state.blockState);
            data.lower = CachedBuffers.partial(AllPartialModels.ARM_LOWER_BODY, state.blockState);
            data.upper = CachedBuffers.partial(AllPartialModels.ARM_UPPER_BODY, state.blockState);
            data.claw = CachedBuffers.partial(goggles ? AllPartialModels.ARM_CLAW_BASE_GOGGLES : AllPartialModels.ARM_CLAW_BASE, state.blockState);
            data.clawUpper = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_UPPER, state.blockState);
            data.clawLower = CachedBuffers.partial(AllPartialModels.ARM_CLAW_GRIP_LOWER, state.blockState);
            data.light = state.lightCoords;
            if (rave) {
                data.color = Color.rainbowColor(AnimationTickHolder.getTicks() * 100).getRGB();
            } else {
                data.color = 0xFFFFFF;
            }
            data.inverted = inverted && goggles;
            data.clawOffset = empty ? 1 / 16f : isBlockItem ? 3 / 16f : 5 / 64f;
        }
    }

    @Override
    public void submit(ArmRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        if (state.rotate != 0) {
            matrices.method_22907(class_7833.field_40714.rotation(state.rotate));
        }
        matrices.method_46416(0, 0.25f, 0);
        matrices.method_22907(class_7833.field_40716.rotation(state.baseAngle));
        if (state.support) {
            matrices.method_46416(0, 0.125f, 0);
            matrices.method_22907(class_7833.field_40714.rotation(state.lowerArmAngle));
            matrices.method_46416(0, 0, -0.875f);
            matrices.method_22907(class_7833.field_40714.rotation(state.upperArmAngle));
            matrices.method_46416(0, 0, -0.9375f);
            matrices.method_22907(class_7833.field_40714.rotation(state.headAngle));
            state.item.render(matrices, queue, state.lightCoords);
        } else {
            queue.method_73483(matrices, state.layer, state.arm::renderBase);
            matrices.method_46416(0, 0.125f, 0);
            matrices.method_22907(class_7833.field_40714.rotation(state.lowerArmAngle));
            queue.method_73483(matrices, state.layer, state.arm::renderLower);
            matrices.method_46416(0, 0, -0.875f);
            matrices.method_22907(class_7833.field_40714.rotation(state.upperArmAngle));
            queue.method_73483(matrices, state.layer, state.arm::renderUpper);
            matrices.method_46416(0, 0, -0.9375f);
            matrices.method_22907(class_7833.field_40714.rotation(state.headAngle));
            if (state.arm.inverted) {
                matrices.method_22907(class_7833.field_40718.rotation(state.rotate));
                queue.method_73483(matrices, state.layer, state.arm::renderClaw);
                matrices.method_22907(class_7833.field_40718.rotation(state.rotate));
            } else {
                queue.method_73483(matrices, state.layer, state.arm::renderClaw);
            }
            matrices.method_22903();
            matrices.method_46416(0, -state.arm.clawOffset, -0.375f);
            queue.method_73483(matrices, state.layer, state.arm::renderClawLower);
            matrices.method_22909();
            matrices.method_22903();
            matrices.method_46416(0, state.arm.clawOffset, -0.375f);
            queue.method_73483(matrices, state.layer, state.arm::renderClawUpper);
            matrices.method_22909();
            if (state.item != null) {
                state.item.render(matrices, queue, state.lightCoords);
            }
        }
    }

    @Override
    protected class_1921 getRenderType(ArmBlockEntity be, class_2680 state) {
        return be.goggles ? class_12249.method_75972() : class_12249.method_75965();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ArmBlockEntity be, ArmRenderState state) {
        return CachedBuffers.partial(AllPartialModels.ARM_COG, state.blockState);
    }

    public static void transformClawHalf(TransformStack<?> msr, boolean hasItem, boolean isBlockItem, int flip) {
        msr.translate(0, -flip * (hasItem ? isBlockItem ? 3 / 16f : 5 / 64f : 1 / 16f), -6 / 16d);
    }

    public static void transformHead(TransformStack<?> msr, float headAngle) {
        msr.translate(0, 0, -15 / 16d);
        msr.rotateXDegrees(headAngle - 45f);
    }

    public static void transformUpperArm(TransformStack<?> msr, float upperArmAngle) {
        msr.translate(0, 0, -14 / 16d);
        msr.rotateXDegrees(upperArmAngle - 90);
    }

    public static void transformLowerArm(TransformStack<?> msr, float lowerArmAngle) {
        msr.translate(0, 2 / 16d, 0);
        msr.rotateXDegrees(lowerArmAngle + 135);
    }

    public static void transformBase(TransformStack<?> msr, float baseAngle) {
        msr.translate(0, 4 / 16d, 0);
        msr.rotateYDegrees(baseAngle);
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    public static class ArmRenderState extends KineticRenderState {
        public float rotate;
        public float baseAngle;
        public float lowerArmAngle;
        public float upperArmAngle;
        public float headAngle;
        public ArmRenderData arm;
        public ArmItemData item;
    }

    public static class ArmItemData {
        public class_10444 state;
        public float xRot;
        public float offset;
        public float scale;

        public void render(class_4587 matrices, class_11659 queue, int light) {
            matrices.method_22907(class_7833.field_40714.rotation(xRot));
            matrices.method_46416(0, offset, 0);
            matrices.method_22905(scale, scale, scale);
            state.method_65604(matrices, queue, light, class_4608.field_21444, 0);
        }
    }

    public static class ArmRenderData {
        public SuperByteBuffer base;
        public SuperByteBuffer lower;
        public SuperByteBuffer upper;
        public SuperByteBuffer claw;
        public SuperByteBuffer clawUpper;
        public SuperByteBuffer clawLower;
        public int light;
        public int color;
        public boolean inverted;
        public float clawOffset;

        public void renderBase(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            base.light(light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClaw(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            claw.light(light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClawLower(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            clawLower.light(light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderClawUpper(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            clawUpper.light(light).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderLower(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            lower.light(light).color(color).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderUpper(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            upper.light(light).color(color).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
