package com.zurrtum.create.client.content.kinetics.motor;


import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.kinetics.motor.CreativeMotorBlock;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;

public class MotorValueBox extends ValueBoxTransform.Sided {
    @Override
    protected class_243 getSouthLocation() {
        return VecHelper.voxelSpace(8, 8, 12.5);
    }

    @Override
    public class_243 getLocalOffset(class_2680 state) {
        class_2350 facing = state.method_11654(CreativeMotorBlock.FACING);
        return super.getLocalOffset(state).method_1019(class_243.method_24954(facing.method_62675()).method_1021(-1 / 16f));
    }

    @Override
    public void rotate(class_2680 state, class_4587 ms) {
        super.rotate(state, ms);
        class_2350 facing = state.method_11654(CreativeMotorBlock.FACING);
        if (facing.method_10166() == class_2350.class_2351.field_11052)
            return;
        if (getSide() != class_2350.field_11036)
            return;
        TransformStack.of(ms).rotateZDegrees(-AngleHelper.horizontalAngle(facing) + 180);
    }

    @Override
    protected boolean isSideActive(class_2680 state, class_2350 direction) {
        class_2350 facing = state.method_11654(CreativeMotorBlock.FACING);
        if (facing.method_10166() != class_2350.class_2351.field_11052 && direction == class_2350.field_11033)
            return false;
        return direction.method_10166() != facing.method_10166();
    }
}
