package com.zurrtum.create.client.content.kinetics.simpleRelays;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.zurrtum.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import net.minecraft.class_11683;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class BracketedKineticBlockEntityRenderer extends KineticBlockEntityRenderer<BracketedKineticBlockEntity, BracketedKineticBlockEntityRenderer.BracketedKineticRenderState> {
    public BracketedKineticBlockEntityRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public BracketedKineticRenderState createRenderState() {
        return new BracketedKineticRenderState();
    }

    @Override
    public void extractRenderState(
        BracketedKineticBlockEntity be,
        BracketedKineticRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        state.large = be.method_11010().method_27852(AllBlocks.LARGE_COGWHEEL);
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.large) {
            state.shaft = CachedBuffers.partialFacingVertical(AllPartialModels.COGWHEEL_SHAFT, state.blockState, state.direction);
            state.shaftAngle = getAngleForLargeCogShaft(be, state.axis);
        }
    }

    @Override
    protected class_1921 getRenderType(BracketedKineticBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(BracketedKineticBlockEntity be, BracketedKineticRenderState state) {
        if (state.large) {
            return CachedBuffers.partialFacingVertical(AllPartialModels.SHAFTLESS_LARGE_COGWHEEL, state.blockState, state.direction);
        }
        return super.getRotatedModel(be, state);
    }

    public static float getAngleForLargeCogShaft(SimpleKineticBlockEntity be, class_2351 axis) {
        class_2338 pos = be.method_11016();
        float offset = getShaftAngleOffset(axis, pos);
        float time = AnimationTickHolder.getRenderTime(be.method_10997());
        return ((time * be.getSpeed() * 3f / 10 + offset) % 360) / 180 * (float) Math.PI;
    }

    public static float getShaftAngleOffset(class_2351 axis, class_2338 pos) {
        if (KineticBlockEntityVisual.shouldOffset(axis, pos)) {
            return 22.5f;
        } else {
            return 0;
        }
    }

    public static class BracketedKineticRenderState extends KineticRenderState {
        public boolean large;
        public SuperByteBuffer shaft;
        public float shaftAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            if (shaft != null) {
                shaft.light(lightCoords);
                shaft.rotateCentered(shaftAngle, direction);
                shaft.color(color);
                shaft.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}
