package com.zurrtum.create.client.content.kinetics.transmission;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.transmission.SplitShaftBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class SplitShaftRenderer implements class_827<SplitShaftBlockEntity, SplitShaftRenderer.SplitShaftRenderState> {
    public SplitShaftRenderer(class_5614.class_5615 context) {
    }

    @Override
    public SplitShaftRenderState method_74335() {
        return new SplitShaftRenderState();
    }

    @Override
    public void extractRenderState(
        SplitShaftBlockEntity be,
        SplitShaftRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        state.layer = class_12249.method_75965();
        state.color = KineticBlockEntityRenderer.getColor(be);
        class_2351 boxAxis = ((IRotate) state.field_62674.method_26204()).getRotationAxis(state.field_62674);
        class_2338 pos = state.field_62673;
        float time = AnimationTickHolder.getRenderTime(be.method_10997());
        float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, boxAxis);
        float angle = (time * be.getSpeed() * 3f / 10) % 360;
        state.direction = switch (boxAxis) {
            case field_11052 -> class_2350.field_11036;
            case field_11051 -> class_2350.field_11035;
            case field_11048 -> class_2350.field_11034;
        };
        class_2350 bottom = switch (boxAxis) {
            case field_11052 -> class_2350.field_11033;
            case field_11051 -> class_2350.field_11043;
            case field_11048 -> class_2350.field_11039;
        };
        state.top = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, state.direction);
        state.topAngle = getAngle(be, angle, offset, state.direction);
        state.bottom = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.field_62674, bottom);
        state.bottomAngle = getAngle(be, angle, offset, bottom);
    }

    private static float getAngle(SplitShaftBlockEntity be, float angle, float offset, class_2350 direction) {
        angle *= be.getRotationSpeedModifier(direction);
        angle += offset;
        return angle / 180f * (float) Math.PI;
    }

    @Override
    public void submit(SplitShaftRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
    }

    public static class SplitShaftRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public Color color;
        public class_2350 direction;
        public SuperByteBuffer top;
        public float topAngle;
        public SuperByteBuffer bottom;
        public float bottomAngle;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            top.light(field_62676);
            top.rotateCentered(topAngle, direction);
            top.color(color);
            top.renderInto(matricesEntry, vertexConsumer);
            bottom.light(field_62676);
            bottom.rotateCentered(bottomAngle, direction);
            bottom.color(color);
            bottom.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
