package com.zurrtum.create.client.content.logistics.box;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class PackageVisual extends AbstractEntityVisual<PackageEntity> implements SimpleDynamicVisual {
    public final TransformedInstance instance;

    public PackageVisual(VisualizationContext ctx, PackageEntity entity, float partialTick) {
        super(ctx, entity, partialTick);

        class_1799 box = entity.box;
        if (box.method_7960() || !PackageItem.isPackage(box))
            box = AllItems.CARDBOARD_BLOCK.method_7854();
        PartialModel model = AllPartialModels.PACKAGES.get(class_7923.field_41178.method_10221(box.method_7909()));

        instance = instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(model)).createInstance();

        animate(partialTick);
    }

    @Override
    public void beginFrame(Context ctx) {
        animate(ctx.partialTick());
    }

    private void animate(float partialTick) {
        float yaw = class_3532.method_16439(partialTick, entity.field_5982, entity.method_36454());

        class_243 pos = entity.method_73189();
        var renderOrigin = renderOrigin();
        var x = (float) (class_3532.method_16436(partialTick, entity.field_6014, pos.field_1352) - renderOrigin.method_10263());
        var y = (float) (class_3532.method_16436(partialTick, entity.field_6036, pos.field_1351) - renderOrigin.method_10264());
        var z = (float) (class_3532.method_16436(partialTick, entity.field_5969, pos.field_1350) - renderOrigin.method_10260());

        long randomBits = (long) entity.method_5628() * 31L * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float) (randomBits >> 16 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;
        float yNudge = (((float) (randomBits >> 20 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;
        float zNudge = (((float) (randomBits >> 24 & 7L) + 0.5F) / 8.0F - 0.5F) * 0.004F;

        instance.setIdentityTransform().translate(x - 0.5 + xNudge, y + yNudge, z - 0.5 + zNudge).rotateYCenteredDegrees(-yaw - 90)
            .light(computePackedLight(partialTick)).setChanged();
    }

    @Override
    protected void _delete() {
        instance.delete();
    }
}
