package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.ShaftRenderer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer.DepotItemState;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer.DepotOutputItemState;
import com.zurrtum.create.client.flywheel.lib.transform.Rotate;
import com.zurrtum.create.client.flywheel.lib.transform.Translate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_7833;

public class EjectorRenderer extends ShaftRenderer<EjectorBlockEntity, EjectorRenderer.EjectorRenderState> {
    static final class_243 pivot = VecHelper.voxelSpace(0, 11.25, 0.75);
    protected final class_10442 itemModelManager;

    public EjectorRenderer(class_5614.class_5615 context) {
        super(context);
        itemModelManager = context.comp_4536();
    }

    @Override
    public EjectorRenderState createRenderState() {
        return new EjectorRenderState();
    }

    @Override
    public void extractRenderState(
        EjectorBlockEntity be,
        EjectorRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_2680 blockState = be.method_11010();
        if (!state.support) {
            state.top = CachedBuffers.partial(AllPartialModels.EJECTOR_TOP, blockState);
            state.lidAngle = class_3532.field_29847 * (be.getLidProgress(tickProgress) * -70);
            state.yRot = class_3532.field_29847 * (180 + AngleHelper.horizontalAngle(blockState.method_11654(EjectorBlock.HORIZONTAL_FACING)));
        }
        DepotBehaviour behaviour = be.getBehaviour(DepotBehaviour.TYPE);
        if (behaviour == null || behaviour.isEmpty())
            return;
        class_1937 world = be.method_10997();
        state.incoming = DepotRenderer.createIncomingStateList(behaviour, itemModelManager, tickProgress, world);
        state.outputs = DepotRenderer.createOutputStateList(behaviour, itemModelManager, world);
        if (state.support && (state.incoming != null || state.outputs != null)) {
            state.blockPos = be.method_11016();
            state.blockEntityType = be.method_11017();
            state.lightCoords = world != null ? class_761.method_23794(world, state.blockPos) : class_765.field_32767;
            state.lidAngle = class_3532.field_29847 * (be.getLidProgress(tickProgress) * -70);
            state.yRot = class_3532.field_29847 * (180 + AngleHelper.horizontalAngle(blockState.method_11654(EjectorBlock.HORIZONTAL_FACING)));
        }
    }

    @Override
    public void submit(EjectorRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.incoming != null || state.outputs != null) {
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(state.yRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            matrices.method_22904(pivot.field_1352, pivot.field_1351, pivot.field_1350);
            matrices.method_22907(class_7833.field_40714.rotation(state.lidAngle));
            matrices.method_22904(-pivot.field_1352, -pivot.field_1351, -pivot.field_1350);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(-state.yRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            DepotRenderer.renderItemsOf(state.incoming, state.outputs, state.blockPos, cameraState.field_63078, queue, matrices, state.lightCoords);
        }
    }

    @Override
    protected class_1921 getRenderType(EjectorBlockEntity be, class_2680 state) {
        return class_12249.method_75965();
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, float angle, T tr) {
        tr.center().rotateYDegrees(180 + AngleHelper.horizontalAngle(be.method_11010().method_11654(EjectorBlock.HORIZONTAL_FACING))).uncenter()
            .translate(pivot).rotateXDegrees(-angle).translateBack(pivot);
    }

    public static class EjectorRenderState extends KineticRenderState {
        public SuperByteBuffer top;
        public float lidAngle;
        public float yRot;
        public DepotItemState[] incoming;
        public List<DepotOutputItemState> outputs;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            top.center().rotateY(yRot).uncenter();
            top.translate(pivot).rotateX(lidAngle).translateBack(pivot);
            top.light(lightCoords);
            top.renderInto(matricesEntry, vertexConsumer);
        }
    }
}
