package com.zurrtum.create.client.content.logistics.packagePort.frogport;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer.NameplateRenderState;
import com.zurrtum.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7923;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class FrogportRenderer implements class_827<FrogportBlockEntity, FrogportRenderer.FrogportRenderState> {
    public FrogportRenderer(class_5614.class_5615 context) {
    }

    @Override
    public FrogportRenderState method_74335() {
        return new FrogportRenderState();
    }

    @Override
    public void extractRenderState(
        FrogportBlockEntity be,
        FrogportRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_1937 world = be.method_10997();
        String filter = be.addressFilter;
        boolean support = VisualizationManager.supportsVisualization(world);
        boolean name = filter != null && !filter.isBlank();
        if (support && !name) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        if (name) {
            state.name = SmartBlockEntityRenderer.getNameplateRenderState(
                be,
                state.field_62673,
                cameraPos,
                class_2561.method_43470(filter),
                1,
                state.field_62676
            );
        }
        if (support) {
            return;
        }
        FrogportRenderData data = state.data = new FrogportRenderData();
        data.layer = class_12249.method_75972();
        data.body = CachedBuffers.partial(AllPartialModels.FROGPORT_BODY, state.field_62674);
        class_243 diff;
        float tongueLength, headPitch, headPitchModifier;
        boolean animating = be.isAnimationInProgress();
        boolean depositing = be.currentlyDepositing;
        if (be.target != null) {
            diff = be.target.getExactTargetLocation(be, world, state.field_62673).method_1023(0, animating && depositing ? 0 : 0.75, 0)
                .method_1020(class_243.method_24953(state.field_62673));
            float tonguePitch = (float) class_3532.method_15349(diff.field_1351, diff.method_18805(1, 0, 1).method_1033() + (3 / 16f)) * class_3532.field_29848;
            tongueLength = Math.max((float) diff.method_1033(), 1);
            headPitch = class_3532.method_15363(tonguePitch * 2, 60, 100);
            data.tonguePitch = class_3532.field_29847 * tonguePitch;
        } else {
            diff = class_243.field_1353;
            tongueLength = 0;
            headPitch = 80;
        }
        if (animating) {
            float progress = be.animationProgress.getValue(tickProgress);
            float scale, itemDistance;
            if (depositing) {
                double modifier = Math.max(0, 1 - Math.pow((progress - 0.25) * 4 - 1, 4));
                itemDistance = (float) Math.max(tongueLength * Math.min(1, (progress - 0.25) * 3), tongueLength * modifier);
                tongueLength *= (float) Math.max(0, 1 - Math.pow((progress * 1.25 - 0.25) * 4 - 1, 4));
                headPitchModifier = (float) Math.max(0, 1 - Math.pow((progress * 1.25) * 2 - 1, 4));
                scale = 0.25f + progress * 3 / 4;

            } else {
                tongueLength *= (float) Math.pow(Math.max(0, 1 - progress * 1.25), 5);
                headPitchModifier = 1 - (float) Math.min(1, Math.max(0, (Math.pow(progress * 1.5, 2) - 0.5) * 2));
                scale = (float) Math.max(0.5, 1 - progress * 1.25);
                itemDistance = tongueLength;
            }
            if (be.animatedPackage != null && scale >= 0.45) {
                class_2960 key = class_7923.field_41178.method_10221(be.animatedPackage.method_7909());
                if (key != class_7923.field_41178.method_10137()) {
                    data.box = CachedBuffers.partial(AllPartialModels.PACKAGES.get(key), state.field_62674);
                    data.boxOffset = diff.method_1029().method_1021(itemDistance).method_1023(0, depositing ? 0.75 : 0, 0);
                    data.boxScale = scale;
                    if (depositing) {
                        data.rig = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(key), state.field_62674);
                    }
                }
            }
        } else {
            tongueLength = 0;
            float anticipation = be.anticipationProgress.getValue(tickProgress);
            headPitchModifier = anticipation > 0 ? (float) Math.max(0, 1 - Math.pow((anticipation * 1.25) * 2 - 1, 4)) : 0;
        }
        headPitch *= headPitchModifier;
        float openProgress = be.manualOpenAnimationProgress.getValue(tickProgress);
        data.headPitch = class_3532.field_29847 * Math.max(headPitch, openProgress * 60);
        tongueLength = Math.max(tongueLength, openProgress * 0.25f);
        data.yRot = class_3532.field_29847 * be.getYaw();
        data.head = CachedBuffers.partial(be.goggles ? AllPartialModels.FROGPORT_HEAD_GOGGLES : AllPartialModels.FROGPORT_HEAD, state.field_62674);
        data.tongue = CachedBuffers.partial(AllPartialModels.FROGPORT_TONGUE, state.field_62674);
        data.tongueScale = tongueLength / (7 / 16f);
        data.light = state.field_62676;
    }

    @Override
    public void submit(FrogportRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.name != null) {
            state.name.render(matrices, queue, cameraState);
        }
        if (state.data != null) {
            queue.method_73483(matrices, state.data.layer, state.data);
        }
    }

    public static class FrogportRenderState extends class_11954 {
        public NameplateRenderState name;
        public FrogportRenderData data;
    }

    public static class FrogportRenderData implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer body;
        public float tonguePitch;
        public float yRot;
        public SuperByteBuffer head;
        public float headPitch;
        public SuperByteBuffer tongue;
        public float tongueScale;
        public SuperByteBuffer rig;
        public SuperByteBuffer box;
        public class_243 boxOffset;
        public float boxScale;
        public int light;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            body.center().rotateY(yRot).uncenter().light(light).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            head.center().rotateY(yRot).uncenter().translate(0.5f, 0.625f, 0.6875f).rotateX(headPitch).translate(-0.5f, -0.625f, -0.6875f)
                .light(light).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            tongue.center().rotateY(yRot).uncenter().translate(0.5f, 0.625f, 0.6875f).rotateX(tonguePitch).scale(1, 1, tongueScale)
                .translate(-0.5f, -0.625f, -0.6875f).light(light).overlay(class_4608.field_21444).renderInto(matricesEntry, vertexConsumer);
            if (box != null) {
                box.translate(0, 0.1875f, 0).translate(boxOffset).center().scale(boxScale).uncenter().light(light).overlay(class_4608.field_21444)
                    .renderInto(matricesEntry, vertexConsumer);
            }
            if (rig != null) {
                rig.translate(0, 0.1875f, 0).translate(boxOffset).center().scale(boxScale).uncenter().light(light).overlay(class_4608.field_21444)
                    .renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}
