package com.zurrtum.create.client.content.logistics.packager;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class PackagerRenderer implements class_827<PackagerBlockEntity, PackagerRenderer.PackagerRenderState> {
    protected final class_10442 itemModelManager;

    public PackagerRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public PackagerRenderState method_74335() {
        return new PackagerRenderState();
    }

    @Override
    public void extractRenderState(
        PackagerBlockEntity be,
        PackagerRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_1937 world = be.method_10997();
        boolean support = VisualizationManager.supportsVisualization(world);
        class_1799 renderedBox = be.getRenderedBox();
        boolean empty = renderedBox.method_7960();
        if (support && empty) {
            return;
        }
        class_11954.method_74399(be, state, crumblingOverlay);
        class_2350 facing = state.field_62674.method_11654(PackagerBlock.field_10927).method_10153();
        float trayOffset = be.getTrayOffset(tickProgress);
        state.trayOffset = class_243.method_24954(facing.method_62675()).method_1021(trayOffset);
        state.trayYRot = class_3532.field_29847 * facing.method_10144();
        if (!support) {
            state.layer = class_12249.method_75972();
            state.hatch = CachedBuffers.partial(getHatchModel(be), state.field_62674);
            state.hatchOffset = class_243.method_24954(facing.method_62675()).method_1021(.49999f);
            state.hatchYRot = class_3532.field_29847 * AngleHelper.horizontalAngle(facing);
            state.hatchXRot = class_3532.field_29847 * AngleHelper.verticalAngle(facing);
            state.tray = CachedBuffers.partial(getTrayModel(state.field_62674), state.field_62674);
        }
        if (!empty) {
            class_10444 item = new class_10444();
            item.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(item, renderedBox, item.field_55337, world, null, 0);
            state.item = item;
        }
    }

    @Override
    public void submit(PackagerRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.layer != null) {
            queue.method_73483(matrices, state.layer, state);
        }
        if (state.item != null) {
            matrices.method_61958(state.trayOffset);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(state.trayYRot));
            matrices.method_46416(0, 0.125f, 0);
            matrices.method_22905(1.49f, 1.49f, 1.49f);
            state.item.method_65604(matrices, queue, state.field_62676, class_4608.field_21444, 0);
        }
    }

    public static PartialModel getTrayModel(class_2680 blockState) {
        return blockState.method_27852(AllBlocks.PACKAGER) ? AllPartialModels.PACKAGER_TRAY_REGULAR : AllPartialModels.PACKAGER_TRAY_DEFRAG;
    }

    public static PartialModel getHatchModel(PackagerBlockEntity be) {
        return isHatchOpen(be) ? AllPartialModels.PACKAGER_HATCH_OPEN : AllPartialModels.PACKAGER_HATCH_CLOSED;
    }

    public static boolean isHatchOpen(PackagerBlockEntity be) {
        return be.animationTicks > (be.animationInward ? 1 : 5) && be.animationTicks < PackagerBlockEntity.CYCLE - (be.animationInward ? 5 : 1);
    }

    public static class PackagerRenderState extends class_11954 implements class_11659.class_11660 {
        public class_243 trayOffset;
        public float trayYRot;
        public class_1921 layer;
        public SuperByteBuffer hatch;
        public class_243 hatchOffset;
        public float hatchYRot;
        public float hatchXRot;
        public SuperByteBuffer tray;
        public class_10444 item;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            hatch.translate(hatchOffset).rotateYCentered(hatchYRot).rotateXCentered(hatchXRot).light(field_62676)
                .renderInto(matricesEntry, vertexConsumer);
            tray.translate(trayOffset).rotateYCentered(trayYRot).light(field_62676).renderInto(matricesEntry, vertexConsumer);
        }
    }
}