package com.zurrtum.create.client.content.logistics.redstoneRequester;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterBlockEntity;
import com.zurrtum.create.content.logistics.redstoneRequester.RedstoneRequesterMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.RedstoneRequesterConfigurationPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_768;
import net.minecraft.class_9129;

public class RedstoneRequesterScreen extends AbstractSimiContainerScreen<RedstoneRequesterMenu> {

    private AddressEditBox addressBox;
    private IconButton confirmButton;
    private List<class_768> extraAreas = Collections.emptyList();
    private List<Integer> amounts = new ArrayList<>();

    private IconButton dontAllowPartial;
    private IconButton allowPartial;
    private ElementWidget renderedItem;

    public RedstoneRequesterScreen(RedstoneRequesterMenu container, class_1661 inv, class_2561 title) {
        super(container, inv, title);

        for (int i = 0; i < 9; i++)
            amounts.add(1);

        List<BigItemStack> stacks = field_2797.contentHolder.encodedRequest.stacks();
        for (int i = 0; i < stacks.size(); i++)
            amounts.set(i, Math.max(1, stacks.get(i).count));
    }

    public static RedstoneRequesterScreen create(
        class_310 mc,
        MenuType<RedstoneRequesterBlockEntity> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(RedstoneRequesterScreen::new, syncId, inventory, title, getBlockEntity(mc, extraData));
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        addressBox.tick();
        for (int i = 0; i < amounts.size(); i++)
            if (field_2797.ghostInventory.method_5438(i).method_7960())
                amounts.set(i, 1);
    }

    @Override
    protected void method_25426() {
        int bgHeight = AllGuiTextures.REDSTONE_REQUESTER.getHeight();
        int bgWidth = AllGuiTextures.REDSTONE_REQUESTER.getWidth();
        setWindowSize(bgWidth, bgHeight + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.method_25426();
        method_37067();

        if (addressBox == null) {
            addressBox = new AddressEditBox(this, new NoShadowFontWrapper(field_22793), field_2776 + 55, field_2800 + 68, 110, 10, false);
            addressBox.method_1852(field_2797.contentHolder.encodedTargetAdress);
            addressBox.method_1868(0xFF555555);
        }
        method_37063(addressBox);

        confirmButton = new IconButton(field_2776 + bgWidth - 30, field_2800 + bgHeight - 25, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> field_22787.field_1724.method_7346());
        method_37063(confirmButton);

        allowPartial = new IconButton(field_2776 + 12, field_2800 + bgHeight - 25, AllIcons.I_PARTIAL_REQUESTS);
        allowPartial.withCallback(() -> {
            allowPartial.green = true;
            dontAllowPartial.green = false;
        });
        allowPartial.green = field_2797.contentHolder.allowPartialRequests;
        allowPartial.setToolTip(CreateLang.translate("gui.redstone_requester.allow_partial").component());
        method_37063(allowPartial);

        dontAllowPartial = new IconButton(field_2776 + 12 + 18, field_2800 + bgHeight - 25, AllIcons.I_FULL_REQUESTS);
        dontAllowPartial.withCallback(() -> {
            allowPartial.green = false;
            dontAllowPartial.green = true;
        });
        dontAllowPartial.green = !field_2797.contentHolder.allowPartialRequests;
        dontAllowPartial.setToolTip(CreateLang.translate("gui.redstone_requester.dont_allow_partial").component());
        method_37063(dontAllowPartial);

        extraAreas = List.of(new class_768(field_2776 + bgWidth, field_2800 + bgHeight - 50, 70, 60));
        renderedItem = new ElementWidget(
            field_2776 + 245,
            field_2800 + 80
        ).showingElement(GuiGameElement.of(AllItems.REDSTONE_REQUESTER.method_7854()).scale(3));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void method_2389(class_332 pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures.REDSTONE_REQUESTER.render(pGuiGraphics, field_2776 + 3, field_2800);
        renderPlayerInventory(pGuiGraphics, field_2776 - 3, field_2800 + 124);

        class_1799 stack = AllItems.REDSTONE_REQUESTER.method_7854();
        class_2561 title = stack.method_7964();
        pGuiGraphics.method_51439(field_22793, title, field_2776 + 117 - field_22793.method_27525(title) / 2, field_2800 + 4, 0xFF3D3C48, false);
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);

        for (int i = 0; i < amounts.size(); i++) {
            int inputX = field_2776 + 27 + i * 20;
            int inputY = field_2800 + 28;
            class_1799 itemStack = field_2797.ghostInventory.method_5438(i);
            if (itemStack.method_7960())
                continue;
            graphics.method_51432(field_22793, itemStack, inputX, inputY, "" + amounts.get(i));
        }

        if (addressBox.method_49606() && !addressBox.method_25370()) {
            if (addressBox.method_1882().isBlank())
                graphics.method_51434(
                    field_22793, List.of(
                        CreateLang.translate("gui.redstone_requester.requester_address").color(ScrollInput.HEADER_RGB).component(),
                        CreateLang.translate("gui.redstone_requester.requester_address_tip").style(class_124.field_1080).component(),
                        CreateLang.translate("gui.redstone_requester.requester_address_tip_1").style(class_124.field_1080).component(),
                        CreateLang.translate("gui.schedule.lmb_edit").style(class_124.field_1063).style(class_124.field_1056).component()
                    ), mouseX, mouseY
                );
            else
                graphics.method_51434(
                    field_22793, List.of(
                        CreateLang.translate("gui.redstone_requester.requester_address_given").color(ScrollInput.HEADER_RGB).component(),
                        CreateLang.text("'" + addressBox.method_1882() + "'").style(class_124.field_1080).component()
                    ), mouseX, mouseY
                );
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (addressBox.method_25401(mouseX, mouseY, scrollX, scrollY))
            return true;

        for (int i = 0; i < amounts.size(); i++) {
            int inputX = field_2776 + 27 + i * 20;
            int inputY = field_2800 + 28;
            if (mouseX >= inputX && mouseX < inputX + 16 && mouseY >= inputY && mouseY < inputY + 16) {
                class_1799 itemStack = field_2797.ghostInventory.method_5438(i);
                if (itemStack.method_7960())
                    return true;
                amounts.set(i, class_3532.method_15340((int) (amounts.get(i) + Math.signum(scrollY) * (AllKeys.hasShiftDown() ? 10 : 1)), 1, 256));
                return true;
            }
        }

        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    protected List<class_2561> method_51454(class_1799 pStack) {
        List<class_2561> tooltip = super.method_51454(pStack);

        if (field_2787 == null || field_2787.field_7871 != field_2797.ghostInventory) {
            return tooltip;
        }
        int slotIndex = field_2787.method_34266();
        if (slotIndex >= amounts.size())
            return tooltip;

        return List.of(
            CreateLang.translate("gui.factory_panel.send_item", CreateLang.itemName(pStack).add(CreateLang.text(" x" + amounts.get(slotIndex))))
                .color(ScrollInput.HEADER_RGB).component(),
            CreateLang.translate("gui.factory_panel.scroll_to_change_amount").style(class_124.field_1063).style(class_124.field_1056)
                .component(),
            CreateLang.translate("gui.scrollInput.shiftScrollsFaster").style(class_124.field_1063).style(class_124.field_1056).component()
        );
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

    @Override
    public void method_25432() {
        field_22787.field_1724.field_3944.method_52787(new RedstoneRequesterConfigurationPacket(
            field_2797.contentHolder.method_11016(),
            addressBox.method_1882(),
            allowPartial.green,
            amounts
        ));
        super.method_25432();
    }

}
