package com.zurrtum.create.client.content.logistics.stockTicker;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.stockTicker.StockKeeperCategoryMenu;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.GhostItemSubmitPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperCategoryEditPacket;
import com.zurrtum.create.infrastructure.packet.c2s.StockKeeperCategoryRefundPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import net.minecraft.class_9129;
import net.minecraft.class_9334;

public class StockKeeperCategoryScreen extends AbstractSimiContainerScreen<StockKeeperCategoryMenu> {

    private static final int CARD_HEADER = 20;
    private static final int CARD_WIDTH = 160;

    private List<class_768> extraAreas = Collections.emptyList();

    private final LerpedFloat scroll = LerpedFloat.linear().startWithValue(0);

    private final List<class_1799> schedule;
    private IconButton confirmButton;
    private class_1799 editingItem;
    private int editingIndex;
    private IconButton editorConfirm;
    private class_342 editorEditBox;
    private ElementWidget renderedItem;

    final int slices = 4;

    public StockKeeperCategoryScreen(StockKeeperCategoryMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title);
        schedule = new ArrayList<>(menu.contentHolder.categories);
        menu.slotsActive = false;
    }

    public static StockKeeperCategoryScreen create(
        class_310 mc,
        MenuType<StockTickerBlockEntity> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(StockKeeperCategoryScreen::new, syncId, inventory, title, getBlockEntity(mc, extraData));
    }

    @Override
    protected void method_25426() {
        AllGuiTextures bg = AllGuiTextures.STOCK_KEEPER_CATEGORY;
        setWindowSize(
            bg.getWidth(),
            bg.getHeight() * slices + AllGuiTextures.STOCK_KEEPER_CATEGORY_HEADER.getHeight() + AllGuiTextures.STOCK_KEEPER_CATEGORY_FOOTER.getHeight()
        );
        super.method_25426();
        method_37067();

        confirmButton = new IconButton(field_2776 + bg.getWidth() - 25, field_2800 + field_2779 - 25, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> field_22787.field_1724.method_7346());
        method_37063(confirmButton);

        stopEditing();

        extraAreas = ImmutableList.of(new class_768(field_2776 + bg.getWidth(), field_2800 + field_2779 - 40, 48, 40));

        renderedItem = new ElementWidget(field_2776 + AllGuiTextures.STOCK_KEEPER_CATEGORY.getWidth() + 12, field_2800 + field_2779 - 39).showingElement(
            GuiGameElement.of(AllItems.STOCK_TICKER.method_7854()).scale(3));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    protected void startEditing(int index) {
        confirmButton.field_22764 = false;

        editorConfirm = new IconButton(field_2776 + 36 + 131, field_2800 + 59, AllIcons.I_CONFIRM);
        field_2797.slotsActive = true;

        editorEditBox = new class_342(field_22793, field_2776 + 47, field_2800 + 28, 124, 10, class_2561.method_43473());
        editorEditBox.method_1868(0xffeeeeee);
        editorEditBox.method_1858(false);
        editorEditBox.method_25365(false);
        editorEditBox.method_25402(new class_11909(0, 0, new class_11910(0, 0)), false);
        editorEditBox.method_1880(28);
        editorEditBox.method_1852(index == -1 || schedule.get(index).method_7960() ? CreateLang.translate("gui.stock_ticker.new_category")
            .string() : schedule.get(index).method_7964().getString());

        editingIndex = index;
        editingItem = index == -1 ? class_1799.field_8037 : schedule.get(index);
        field_2797.proxyInventory.method_5447(0, editingItem);
        field_22787.field_1724.field_3944.method_52787(new GhostItemSubmitPacket(editingItem, 0));

        method_37063(editorConfirm);
        method_37063(editorEditBox);
        field_2779 = 88 + AllGuiTextures.PLAYER_INVENTORY.getHeight();
    }

    protected void stopEditing() {
        confirmButton.field_22764 = true;
        if (editingItem == null)
            return;

        playUiSound(class_3417.field_15015.comp_349(), 1, 1);
        method_37066(editorConfirm);
        method_37066(editorEditBox);

        class_1799 stackInSlot = field_2797.proxyInventory.method_5438(0).method_7972();
        boolean empty = stackInSlot.method_7960();

        if (empty && editingIndex != -1)
            schedule.remove(editingIndex);

        if (!empty) {
            String value = editorEditBox.method_1882();
            boolean blank = value.isBlank() || value.equals(CreateLang.translate("gui.stock_ticker.new_category").string()) || value.equals(
                stackInSlot.method_7964().getString());
            stackInSlot.method_57379(class_9334.field_49631, blank ? null : class_2561.method_43470(value));
            if (editingIndex == -1)
                schedule.add(stackInSlot);
            else
                schedule.set(editingIndex, stackInSlot);
        }

        field_22787.field_1724.field_3944.method_52787(new GhostItemSubmitPacket(class_1799.field_8037, 0));

        editingItem = null;
        editorConfirm = null;
        editorEditBox = null;
        field_2797.slotsActive = false;
        renderedItem.getRenderElement().clear();
        method_25426();
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        scroll.tickChaser();
        if (editorEditBox == null)
            return;
        if (!editorEditBox.method_1882().equals(CreateLang.translate("gui.stock_ticker.new_category").string()))
            return;
        if (field_2797.proxyInventory.method_5438(0).method_57826(class_9334.field_49631))
            editorEditBox.method_1852(field_2797.proxyInventory.method_5438(0).method_7964().getString());
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = AnimationTickHolder.getPartialTicksUI(field_22787.method_61966());

        if (field_2797.slotsActive)
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
        else {
            for (class_4068 widget : field_33816)
                widget.method_25394(graphics, mouseX, mouseY, partialTicks);
            renderForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderCategories(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.method_51448();
        int yOffset = 25;
        List<class_1799> entries = schedule;
        float scrollOffset = -scroll.getValue(partialTicks);

        graphics.method_44379(field_2776 + 3, field_2800 + 16, field_2776 + 187, field_2800 + 19 + (AllGuiTextures.STOCK_KEEPER_CATEGORY.getHeight() * slices));
        for (int i = 0; i <= entries.size(); i++) {
            matrixStack.pushMatrix();
            matrixStack.translate(0, scrollOffset);

            if (i == entries.size()) {
                AllGuiTextures.STOCK_KEEPER_CATEGORY_NEW.render(graphics, field_2776 + 7, field_2800 + yOffset);
                matrixStack.popMatrix();
                break;
            }

            class_1799 scheduleEntry = entries.get(i);
            int cardY = yOffset;
            int cardHeight = renderScheduleEntry(graphics, matrixStack, i, scheduleEntry, cardY);
            yOffset += cardHeight;

            matrixStack.popMatrix();
        }
        graphics.method_44380();
    }

    public int renderScheduleEntry(class_332 graphics, Matrix3x2fStack matrixStack, int i, class_1799 entry, int yOffset) {
        int cardWidth = CARD_WIDTH;
        int cardHeader = CARD_HEADER;

        matrixStack.pushMatrix();
        matrixStack.translate(field_2776 + 7, field_2800 + yOffset);

        AllGuiTextures.STOCK_KEEPER_CATEGORY_ENTRY.render(graphics, 0, 0);

        if (i > 0)
            AllGuiTextures.STOCK_KEEPER_CATEGORY_UP.render(graphics, cardWidth + 12, cardHeader - 18);
        if (i < schedule.size() - 1)
            AllGuiTextures.STOCK_KEEPER_CATEGORY_DOWN.render(graphics, cardWidth + 12, cardHeader - 9);

        graphics.method_51427(entry, 14, 1);
        class_2561 name = entry.method_7964();
        graphics.method_51433(
            field_22793,
            entry.method_7960() ? CreateLang.translate("gui.stock_ticker.empty_category_name_placeholder").string() : name.method_10858(20)
                .stripTrailing() + (name.getString().length() > 20 ? "..." : ""),
            35,
            5,
            0xFF656565,
            false
        );

        matrixStack.popMatrix();
        return cardHeader;
    }

    private final class_2561 clickToEdit = CreateLang.translateDirect("gui.schedule.lmb_edit")
        .method_27695(class_124.field_1063, class_124.field_1056);

    public boolean action(@Nullable class_11907 input, @Nullable class_332 graphics, double mouseX, double mouseY, int click) {
        // Prevent actions outside the window for them
        if (mouseX < this.field_2776 || mouseX >= this.field_2776 + field_2792 || mouseY < this.field_2800 + 15 || mouseY >= this.field_2800 + 99)
            return false;

        if (editingItem != null)
            return false;

        int mx = (int) mouseX;
        int my = (int) mouseY;
        int x = mx - this.field_2776 - 20;
        int y = my - this.field_2800 - 24;
        if (x < 0 || x >= 196)
            return false;
        if (y < 0 || y >= 143)
            return false;
        y += scroll.getValue(0);

        List<class_1799> entries = schedule;
        for (int i = 0; i < entries.size(); i++) {
            class_1799 entry = entries.get(i);
            int cardHeight = CARD_HEADER;

            if (y >= cardHeight) {
                y -= cardHeight;
                if (y < 0)
                    return false;
                continue;
            }

            int fieldSize = 140;
            if (x > 0 && x <= fieldSize && y > 0 && y <= 16) {
                List<class_2561> components = new ArrayList<>();
                components.add(entry.method_7960() ? CreateLang.translate("gui.stock_ticker.empty_category_name_placeholder")
                    .component() : entry.method_7964());
                components.add(clickToEdit);
                renderActionTooltip(graphics, components, mx, my);
                if (click == 0)
                    startEditing(i);
                return true;
            }

            if (x > fieldSize && x <= fieldSize + 16 && y > 0 && y <= 16) {
                renderActionTooltip(graphics, ImmutableList.of(CreateLang.translate("gui.stock_ticker.delete_category").component()), mx, my);
                if (click == 0) {
                    if (!entry.method_7960())
                        field_22787.field_1724.field_3944.method_52787(new StockKeeperCategoryRefundPacket(field_2797.contentHolder.method_11016(), entry));
                    entries.remove(entry);
                    renderedItem.getRenderElement().clear();
                    method_25426();
                }
                return true;
            }

            if (x > 158 && x < 170) {
                if (y > 2 && y <= 10 && i > 0) {
                    renderActionTooltip(
                        graphics, ImmutableList.of(
                            CreateLang.translateDirect("gui.schedule.move_up"),
                            CreateLang.translate("gui.stock_ticker.shift_moves_top").style(class_124.field_1063).style(class_124.field_1056)
                                .component()
                        ), mx, my
                    );
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add((input != null ? input.method_74239() : AllKeys.hasShiftDown()) ? 0 : i - 1, entry);
                        renderedItem.getRenderElement().clear();
                        method_25426();
                    }
                    return true;
                }
                if (y > 10 && y <= 22 && i < entries.size() - 1) {
                    renderActionTooltip(
                        graphics, ImmutableList.of(
                            CreateLang.translateDirect("gui.schedule.move_down"),
                            CreateLang.translate("gui.stock_ticker.shift_moves_bottom").style(class_124.field_1063).style(class_124.field_1056)
                                .component()
                        ), mx, my
                    );
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add((input != null ? input.method_74239() : AllKeys.hasShiftDown()) ? entries.size() : i + 1, entry);
                        renderedItem.getRenderElement().clear();
                        method_25426();
                    }
                    return true;
                }
            }

            x -= 18;
            y -= 28;

            if (x < 0 || y < 0 || x > 160)
                return false;
        }

        if (x > 0 && x <= 16 && y > 0 && y <= 16) {
            renderActionTooltip(graphics, ImmutableList.of(CreateLang.translate("gui.stock_ticker.new_category").component()), mx, my);
            if (click == 0) {
                playUiSound(class_3417.field_15015.comp_349(), 1f, 1f);
                startEditing(-1);
            }
        }

        return false;
    }

    private void renderActionTooltip(@Nullable class_332 graphics, List<class_2561> tooltip, int mx, int my) {
        if (graphics != null)
            graphics.method_64038(field_22793, tooltip, Optional.empty(), mx, my);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        double pMouseX = click.comp_4798();
        double pMouseY = click.comp_4799();
        if (editorConfirm != null && editorConfirm.method_25405(pMouseX, pMouseY)) {
            stopEditing();
            return true;
        }
        if (action(click, null, pMouseX, pMouseY, click.method_74245())) {
            playUiSound(class_3417.field_15015.comp_349(), 1f, 1f);
            return true;
        }

        boolean wasNotFocused = editorEditBox != null && !editorEditBox.method_25370();
        boolean mouseClicked = super.method_25402(click, doubled);

        if (editorEditBox != null && editorEditBox.method_25405(pMouseX, pMouseY) && wasNotFocused) {
            editorEditBox.method_1872(false);
            editorEditBox.method_1884(0);
        }

        return mouseClicked;
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (editingItem == null)
            return super.method_25404(input);

        int pKeyCode = input.comp_4795();
        boolean hitEscape = pKeyCode == GLFW.GLFW_KEY_ESCAPE;
        boolean hitEnter = method_25399() instanceof class_342 && (pKeyCode == 257 || pKeyCode == 335);
        boolean hitE = method_25399() == null && field_22787.field_1690.field_1822.method_1417(input);
        if (hitE || hitEnter || hitEscape) {
            stopEditing();
            return true;
        }

        return super.method_25404(input);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (editingItem != null)
            return super.method_25401(mouseX, mouseY, scrollX, scrollY);

        float chaseTarget = scroll.getChaseTarget();
        float max = 40 - (3 + AllGuiTextures.STOCK_KEEPER_CATEGORY.getHeight() * slices);
        max += schedule.size() * CARD_HEADER + 24;
        if (max > 0) {
            chaseTarget -= (float) (scrollY * 12);
            chaseTarget = class_3532.method_15363(chaseTarget, 0, max);
            scroll.chase((int) chaseTarget, 0.7f, Chaser.EXP);
        } else
            scroll.chase(0, 0.7f, Chaser.EXP);

        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(graphics, mouseX, mouseY, partialTicks);

        action(null, graphics, mouseX, mouseY, -1);

        if (editingItem == null)
            return;

        if (field_2787 != null && field_2787.field_7871 == field_2797.proxyInventory && field_2787.method_7677().method_7960()) {
            graphics.method_51434(
                field_22793, List.of(
                    CreateLang.translate("gui.stock_ticker.category_filter").color(ScrollInput.HEADER_RGB).component(),
                    CreateLang.translate("gui.stock_ticker.category_filter_tip").style(class_124.field_1080).component(),
                    CreateLang.translate("gui.stock_ticker.category_filter_tip_1").style(class_124.field_1080).component()
                ), mouseX, mouseY
            );
        }

        if (editorEditBox != null && editorEditBox.method_49606() && !editorEditBox.method_25370()) {
            graphics.method_51434(
                field_22793,
                List.of(CreateLang.translate("gui.stock_ticker.category_name").color(ScrollInput.HEADER_RGB).component(), clickToEdit),
                mouseX,
                mouseY
            );
        }

    }

    @Override
    protected void method_2389(class_332 graphics, float pPartialTick, int pMouseX, int pMouseY) {
        pPartialTick = AnimationTickHolder.getPartialTicksUI(field_22787.method_61966());
        int y = this.field_2800;
        AllGuiTextures.STOCK_KEEPER_CATEGORY_HEADER.render(graphics, field_2776, y);
        y += AllGuiTextures.STOCK_KEEPER_CATEGORY_HEADER.getHeight();
        for (int i = 0; i < slices; i++) {
            AllGuiTextures.STOCK_KEEPER_CATEGORY.render(graphics, field_2776, y);
            y += AllGuiTextures.STOCK_KEEPER_CATEGORY.getHeight();
        }
        AllGuiTextures.STOCK_KEEPER_CATEGORY_FOOTER.render(graphics, field_2776, y);
        AllGuiTextures.STOCK_KEEPER_CATEGORY_SAYS.render(graphics, field_2776 + field_2792 - 6, y + 7);

        class_5481 formattedcharsequence = field_2797.contentHolder.method_11010().method_26204().method_9518().method_30937();

        int center = field_2776 + (AllGuiTextures.STOCK_KEEPER_CATEGORY.getWidth()) / 2;
        graphics.method_51430(field_22793, formattedcharsequence, (center - field_22793.method_30880(formattedcharsequence) / 2), this.field_2800 + 4, 0xFF3D3C48, false);
        renderCategories(graphics, pMouseX, pMouseY, pPartialTick);

        if (editingItem == null) {
            renderCategories(graphics, pMouseX, pMouseY, pPartialTick);
            return;
        }

        graphics.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);

        y = this.field_2800 - 5;
        AllGuiTextures.STOCK_KEEPER_CATEGORY_HEADER.render(graphics, field_2776, y);
        y += AllGuiTextures.STOCK_KEEPER_CATEGORY_HEADER.getHeight();
        AllGuiTextures.STOCK_KEEPER_CATEGORY_EDIT.render(graphics, field_2776, y);
        y += AllGuiTextures.STOCK_KEEPER_CATEGORY_EDIT.getHeight();
        AllGuiTextures.STOCK_KEEPER_CATEGORY_FOOTER.render(graphics, field_2776, y);

        renderPlayerInventory(graphics, field_2776 + 10, this.field_2800 + 88);

        formattedcharsequence = CreateLang.translate("gui.stock_ticker.category_editor").component().method_30937();
        graphics.method_51430(field_22793, formattedcharsequence, (center - field_22793.method_30880(formattedcharsequence) / 2), this.field_2800 - 1, 0x3D3C48, false);
    }

    @Override
    public void method_25432() {
        super.method_25432();
        field_22787.field_1724.field_3944.method_52787(new StockKeeperCategoryEditPacket(field_2797.contentHolder.method_11016(), schedule));
    }

    @Override
    protected List<class_2561> method_51454(class_1799 pStack) {
        List<class_2561> tooltip = super.method_51454(pStack);
        if (field_2787 == null || field_2787.field_7871 != field_2797.proxyInventory)
            return tooltip;
        if (!tooltip.isEmpty())
            tooltip.set(0, CreateLang.translate("gui.stock_ticker.category_filter").color(ScrollInput.HEADER_RGB).component());
        return tooltip;
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

    public class_327 method_64506() {
        return field_22793;
    }

}
