package com.zurrtum.create.client.content.redstone.displayLink;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import com.zurrtum.create.content.redstone.displayLink.LinkWithBulbBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11785;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class LinkBulbRenderer implements class_827<LinkWithBulbBlockEntity, LinkBulbRenderer.LinkBulbRenderState> {
    public LinkBulbRenderer(class_5614.class_5615 context) {
    }

    @Override
    public LinkBulbRenderState method_74335() {
        return new LinkBulbRenderState();
    }

    @Override
    public void extractRenderState(
        LinkWithBulbBlockEntity be,
        LinkBulbRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        class_2350 face = be.getBulbFacing(state.field_62674);
        state.yRot = class_3532.field_29847 * (AngleHelper.horizontalAngle(face) + 180);
        state.xRot = class_3532.field_29847 * (-AngleHelper.verticalAngle(face) - 90);
        state.offset = be.getBulbOffset(state.field_62674);
        state.tube = CachedBuffers.partial(AllPartialModels.DISPLAY_LINK_TUBE, state.field_62674);
        float glow = be.getGlow(tickProgress);
        if (glow < .125f) {
            state.translucent = class_12249.method_75977();
            return;
        }
        state.translucent = CreateRenderTypes.translucent();
        state.additive = CreateRenderTypes.additive();
        state.glow = CachedBuffers.partial(AllPartialModels.DISPLAY_LINK_GLOW, state.field_62674);
        glow = (float) (1 - (2 * Math.pow(glow - .75f, 2)));
        glow = class_3532.method_15363(glow, -1, 1);
        state.color = (int) (200 * glow);
    }

    @Override
    public void submit(LinkBulbRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        matrices.method_46416(0.5f, 0.5f, 0.5f);
        matrices.method_22907(class_7833.field_40716.rotation(state.yRot));
        matrices.method_22907(class_7833.field_40714.rotation(state.xRot));
        matrices.method_46416(-0.5f, -0.5f, -0.5f);
        class_11785 batchingQueue = ShadersModHelper.isShaderPackInUse() ? queue.method_73529(1) : queue;
        batchingQueue.method_73483(matrices, state.translucent, state::renderTube);
        if (state.glow != null) {
            batchingQueue.method_73483(matrices, state.additive, state::renderGlow);
        }
    }

    public static class LinkBulbRenderState extends class_11954 {
        public class_1921 translucent;
        public class_1921 additive;
        public SuperByteBuffer tube;
        public SuperByteBuffer glow;
        public float yRot;
        public float xRot;
        public class_243 offset;
        public int color;

        public void renderTube(class_4587.class_4665 entry, class_4588 vertexConsumer) {
            tube.translate(offset).light(class_765.field_32767).renderInto(entry, vertexConsumer);
        }

        public void renderGlow(class_4587.class_4665 entry, class_4588 vertexConsumer) {
            glow.translate(offset).light(class_765.field_32767).color(color, color, color, 255).disableDiffuse().renderInto(entry, vertexConsumer);
        }
    }
}
