package com.zurrtum.create.client.content.redstone.link.controller;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.redstone.link.controller.LinkedControllerMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_768;
import net.minecraft.class_9129;

import static com.zurrtum.create.client.foundation.gui.AllGuiTextures.PLAYER_INVENTORY;

public class LinkedControllerScreen extends AbstractSimiContainerScreen<LinkedControllerMenu> {

    protected AllGuiTextures background;
    private List<class_768> extraAreas = Collections.emptyList();

    private IconButton resetButton;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    public LinkedControllerScreen(LinkedControllerMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title);
        this.background = AllGuiTextures.LINKED_CONTROLLER;
    }

    public static LinkedControllerScreen create(
        class_310 mc,
        MenuType<class_1799> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(LinkedControllerScreen::new, syncId, inventory, title, getStack(extraData));
    }

    @Override
    protected void method_25426() {
        setWindowSize(background.getWidth(), background.getHeight() + 4 + PLAYER_INVENTORY.getHeight());
        setWindowOffset(1, 0);
        super.method_25426();

        resetButton = new IconButton(field_2776 + background.getWidth() - 62, field_2800 + background.getHeight() - 24, AllIcons.I_TRASH);
        resetButton.withCallback(() -> {
            field_2797.clearContents();
            field_22787.field_1724.field_3944.method_52787(AllPackets.CLEAR_CONTAINER);
        });
        confirmButton = new IconButton(field_2776 + background.getWidth() - 33, field_2800 + background.getHeight() - 24, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> {
            field_22787.field_1724.method_7346();
        });

        method_37063(resetButton);
        method_37063(confirmButton);

        extraAreas = ImmutableList.of(new class_768(field_2776 + background.getWidth() + 4, field_2800 + background.getHeight() - 44, 64, 56));
        renderedItem = new ElementWidget(field_2776 + background.getWidth() - 4, field_2800 + background.getHeight() - 56).showingElement(GuiGameElement.of(
            field_2797.contentHolder).scale(5));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    @Override
    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = getLeftOfCentered(PLAYER_INVENTORY.getWidth());
        int invY = field_2800 + background.getHeight() + 4;
        renderPlayerInventory(graphics, invX, invY);

        background.render(graphics, field_2776, field_2800);
        graphics.method_51439(field_22793, field_22785, field_2776 + 15, field_2800 + 4, 0xff592424, false);
    }

    @Override
    protected void method_37432() {
        if (!class_1799.method_7973(field_2797.player.method_6047(), field_2797.contentHolder))
            field_22787.field_1724.method_7346();

        super.method_37432();
    }

    @Override
    protected void method_2380(class_332 graphics, int x, int y) {
        if (!field_2797.method_34255().method_7960() || field_2787 == null || field_2787.field_7871 == field_2797.playerInventory) {
            super.method_2380(graphics, x, y);
            return;
        }

        List<class_2561> list = new LinkedList<>();
        if (field_2787.method_7681())
            list = method_51454(field_2787.method_7677());

        graphics.method_51434(field_22793, addToTooltip(list, field_2787.method_34266()), x, y);
    }

    private List<class_2561> addToTooltip(List<class_2561> list, int slot) {
        if (slot < 0 || slot >= 12)
            return list;
        list.add(CreateLang.translateDirect(
            "linked_controller.frequency_slot_" + ((slot % 2) + 1),
            ControlsUtil.getControls().get(slot / 2).method_16007().getString()
        ).method_27692(class_124.field_1065));
        return list;
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}
