package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.content.schematics.client.tools.ToolType;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import org.joml.Matrix3x2fStack;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class ToolSelectionScreen extends class_437 {

    public final String scrollToCycle = CreateLang.translateDirect("gui.toolmenu.cycle").getString();
    public final String holdToFocus = "gui.toolmenu.focusKey";

    protected List<ToolType> tools;
    protected Consumer<ToolType> callback;
    public boolean focused;
    private float yOffset;
    protected int selection;
    private boolean initialized;

    protected int w;
    protected int h;

    public ToolSelectionScreen(class_310 mc, List<ToolType> tools, Consumer<ToolType> callback) {
        super(mc, mc.field_1772, class_2561.method_43470("Tool Selection"));
        this.tools = tools;
        this.callback = callback;
        focused = false;
        yOffset = 0;
        selection = 0;
        initialized = false;

        callback.accept(tools.get(selection));

        w = Math.max(tools.size() * 50 + 30, 220);
        h = 30;
    }

    public void setSelectedElement(ToolType tool) {
        if (!tools.contains(tool))
            return;
        selection = tools.indexOf(tool);
    }

    public void cycle(int direction) {
        selection += (direction < 0) ? 1 : -1;
        selection = (selection + tools.size()) % tools.size();
    }

    private void draw(class_332 graphics, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.method_51448();
        class_1041 mainWindow = field_22787.method_22683();
        int scaledWidth = mainWindow.method_4486();
        int scaledHeight = mainWindow.method_4502();
        if (!initialized)
            method_25423(scaledWidth, scaledHeight);

        int x = (scaledWidth - w) / 2 + 15;
        int y = scaledHeight - h - 75;

        matrixStack.pushMatrix();
        matrixStack.translate(0, -yOffset);

        AllGuiTextures gray = AllGuiTextures.HUD_BACKGROUND;

        graphics.method_25291(
            class_10799.field_56883,
            gray.location,
            x - 15,
            y,
            gray.getStartX(),
            gray.getStartY(),
            w,
            h,
            gray.getWidth(),
            gray.getHeight(),
            focused ? 0xE0FFFFFF : 0x80FFFFFF
        );

        float toolTipAlpha = yOffset / 10;
        List<class_2561> toolTip = tools.get(selection).getDescription();
        int stringAlphaComponent = ((int) (toolTipAlpha * 0xFF)) << 24;

        if (toolTipAlpha > 0.25f) {
            graphics.method_25291(
                class_10799.field_56883,
                gray.location,
                x - 15,
                y + 33,
                gray.getStartX(),
                gray.getStartY(),
                w,
                h + 22,
                gray.getWidth(),
                gray.getHeight(),
                0xB2B2CC | stringAlphaComponent
            );

            if (toolTip.size() > 0)
                graphics.method_51439(field_22793, toolTip.get(0), x - 10, y + 38, 0xEEEEEE | stringAlphaComponent, false);
            if (toolTip.size() > 1)
                graphics.method_51439(field_22793, toolTip.get(1), x - 10, y + 50, 0xCCDDFF | stringAlphaComponent, false);
            if (toolTip.size() > 2)
                graphics.method_51439(field_22793, toolTip.get(2), x - 10, y + 60, 0xCCDDFF | stringAlphaComponent, false);
            if (toolTip.size() > 3)
                graphics.method_51439(field_22793, toolTip.get(3), x - 10, y + 72, 0xCCCCDD | stringAlphaComponent, false);
        }

        if (tools.size() > 1) {
            String keyName = AllKeys.TOOL_MENU.method_16007().getString().toUpperCase();
            if (!focused)
                graphics.method_27534(field_22793, CreateLang.translateDirect(holdToFocus, keyName), scaledWidth / 2, y - 10, 0xFFCCDDFF);
            else
                graphics.method_25300(field_22793, scrollToCycle, scaledWidth / 2, y - 10, 0xFFCCDDFF);
        } else {
            x += 65;
        }


        for (int i = 0; i < tools.size(); i++) {
            matrixStack.pushMatrix();

            float alpha = focused ? 1 : .2f;
            if (i == selection) {
                matrixStack.translate(0, -10);
                graphics.method_25300(field_22793, tools.get(i).getDisplayName().getString(), x + i * 50 + 24, y + 28, 0xFFCCDDFF);
                alpha = 1;
            }
            int color = ((int) (alpha * 0xFF)) << 24;
            tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 12, color);
            tools.get(i).getIcon().render(graphics, x + i * 50 + 16, y + 11, 0xFFFFFF | color);

            matrixStack.popMatrix();
        }

        matrixStack.popMatrix();
    }

    public void update() {
        if (focused)
            yOffset += (10 - yOffset) * .1f;
        else
            yOffset *= .9f;
    }

    public void renderPassive(class_332 graphics, float partialTicks) {
        draw(graphics, partialTicks);
    }

    @Override
    public void method_25419() {
        callback.accept(tools.get(selection));
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        initialized = true;
    }
}