package com.zurrtum.create.client.content.trains.display;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.trains.display.FlapDisplayBlock;
import com.zurrtum.create.content.trains.display.FlapDisplayBlockEntity;
import com.zurrtum.create.content.trains.display.FlapDisplayLayout;
import com.zurrtum.create.content.trains.display.FlapDisplaySection;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_11603;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11767;
import net.minecraft.class_11768;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_327.class_6415;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5223;
import net.minecraft.class_5224;
import net.minecraft.class_5251;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;

public class FlapDisplayRenderer extends KineticBlockEntityRenderer<FlapDisplayBlockEntity, FlapDisplayRenderer.FlapDisplayRenderState> {
    protected final class_327 textRenderer;

    public FlapDisplayRenderer(class_5614.class_5615 context) {
        super(context);
        textRenderer = context.comp_4540();
    }

    @Override
    public FlapDisplayRenderState createRenderState() {
        return new FlapDisplayRenderState();
    }

    @Override
    public void extractRenderState(
        FlapDisplayBlockEntity be,
        FlapDisplayRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (!be.isController) {
            return;
        }
        if (state.support) {
            class_11954.method_74399(be, state, crumblingOverlay);
        }
        FlapDisplayData display = new FlapDisplayData();
        List<FlapDisplayLayout> lines = be.getLines();
        boolean paused = !be.isSpeedRequirementFulfilled();
        class_1937 world = be.method_10997();
        int levelTicks = AnimationTickHolder.getTicks(world);
        int ticks = paused ? 0 : levelTicks;
        float time = paused ? 0 : AnimationTickHolder.getRenderTime(world);
        int size = lines.size();
        float y = 4.5f;
        int light = state.lightCoords;
        for (int j = 0; j < size; j++) {
            List<FlapDisplaySection> line = lines.get(j).getSections();
            int color = getLineColor(be, j);
            float w = 0;
            int count = line.size();
            float[] offsets = new float[count];
            for (int i = 0; i < count; i++) {
                FlapDisplaySection section = line.get(i);
                offsets[i] = w;
                w += section.getSize() + (section.hasGap ? 8 : 1);
            }
            float margin = be.xSize * 16 - w / 2 + 1;
            boolean glowing = be.isLineGlowing(j);
            FlapDisplayRenderOutput renderOutput = new FlapDisplayRenderOutput(
                y,
                textRenderer,
                color,
                j,
                paused,
                ticks,
                time,
                glowing,
                drawable -> display.add(light, glowing, drawable)
            );
            for (int i = 0; i < count; i++) {
                FlapDisplaySection section = line.get(i);
                renderOutput.nextSection(section, margin + offsets[i]);
                String text = section.renderCharsIndividually() || !section.spinning[0] ? section.text : section.cyclingOptions[((levelTicks / 3) + i * 13) % section.cyclingOptions.length];
                class_5223.method_27479(text, class_2583.field_24360, renderOutput);
            }
            y += 16;
        }
        if (display.isEmpty()) {
            return;
        }
        display.yRot = class_3532.field_29847 * AngleHelper.horizontalAngle(state.blockState.getValue(FlapDisplayBlock.HORIZONTAL_FACING));
        state.display = display;
    }

    @Override
    public void submit(FlapDisplayRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.display != null) {
            state.display.render(matrices, queue);
        }
    }

    public static int getLineColor(FlapDisplayBlockEntity be, int line) {
        class_1767 color = be.colour[line];
        return color == null ? 0xFF_D3C6BA : DyeHelper.getDyeColors(color).getFirst() | 0xFF_000000;
    }

    public static class FlapDisplayRenderOutput implements class_5224 {
        final class_327 textRenderer;
        final int color;
        final int r, g, b, a;
        final boolean paused;
        final int ticks;
        final float time;
        final int lineIndex;
        final float y;
        final Consumer<class_11767> consumer;

        FlapDisplaySection section;
        float x;

        public FlapDisplayRenderOutput(
            float y,
            class_327 textRenderer,
            int color,
            int lineIndex,
            boolean paused,
            int ticks,
            float time,
            boolean glowing,
            Consumer<class_11767> consumer
        ) {
            this.y = y;
            this.textRenderer = textRenderer;
            this.lineIndex = lineIndex;
            this.paused = paused;
            this.ticks = ticks;
            this.time = time;
            this.a = glowing ? 0xF8000000 : 0xD8000000;
            this.r = color >> 16 & 255;
            this.g = color >> 8 & 255;
            this.b = color & 255;
            this.color = color;
            this.consumer = consumer;
        }

        public void nextSection(FlapDisplaySection section, float offset) {
            this.section = section;
            x = offset;
        }

        @Override
        public boolean accept(int charIndex, class_2583 style, int glyph) {
            class_5251 textcolor = style.method_10973();
            boolean canDim = textcolor == null;
            boolean dim = false;

            if (section.renderCharsIndividually() && section.spinning[Math.min(charIndex, section.spinning.length)]) {
                float speed = section.spinningTicks > 5 && section.spinningTicks < 20 ? 1.75f : 2.5f;
                float cycle = (time / speed) + charIndex * 16.83f + lineIndex * 0.75f;
                float partial = cycle % 1;
                char cyclingGlyph = section.cyclingOptions[((int) cycle) % section.cyclingOptions.length].charAt(0);
                glyph = paused ? cyclingGlyph : partial > 1 / 2f ? partial > 3 / 4f ? '_' : '-' : cyclingGlyph;
                if (canDim) {
                    dim = true;
                }
            }

            class_11603 glyphProvider = textRenderer.method_72732(style.method_27708());
            class_11768 bakedglyph = glyphProvider.method_72736(glyph);
            float glyphWidth = bakedglyph.method_73398().method_16798(false);

            boolean obfuscated = style.method_10987();
            if (!section.renderCharsIndividually() && section.spinning[0]) {
                if (!obfuscated) {
                    int oldGlyph = glyph;
                    int i = ticks % 3;
                    if (i == 0) {
                        if (glyphWidth == 6) {
                            glyph = '-';
                        } else if (glyphWidth == 1) {
                            glyph = '\'';
                        }
                    } else if (i == 2) {
                        if (glyphWidth == 6) {
                            glyph = '_';
                        } else if (glyphWidth == 1) {
                            glyph = '.';
                        }
                    }
                    if (oldGlyph != glyph) {
                        bakedglyph = glyphProvider.method_72736(glyph);
                    }
                }
                if (canDim && ticks % 3 != 1) {
                    dim = true;
                }
            }

            if (obfuscated && glyph != 32) {
                bakedglyph = glyphProvider.method_72737(textRenderer.field_2001, class_3532.method_15386(glyphWidth));
            }

            int drawColor = a;
            if (textcolor != null) {
                drawColor |= textcolor.method_27716();
            } else if (dim) {
                drawColor |= (r * 0xC0 >> 8 << 16) | (g * 0xC0 >> 8 << 8) | (b * 0xC0 >> 8);
            } else {
                drawColor |= color;
            }

            float standardWidth = section.wideFlaps ? FlapDisplaySection.WIDE_MONOSPACE : FlapDisplaySection.MONOSPACE;

            if (section.renderCharsIndividually()) {
                x += (standardWidth - glyphWidth) / 2f;
            }
            class_11767 textDrawable = bakedglyph.method_73399(x, y, drawColor, 0, style, 0, 0);
            if (textDrawable != null) {
                consumer.accept(textDrawable);
            }
            if (section.renderCharsIndividually()) {
                x += standardWidth - (standardWidth - glyphWidth) / 2f;
            } else {
                x += glyphWidth;
            }
            return true;
        }
    }

    @Override
    protected SuperByteBuffer getRotatedModel(FlapDisplayBlockEntity be, FlapDisplayRenderState state) {
        return CachedBuffers.partialFacingVertical(
            AllPartialModels.SHAFTLESS_COGWHEEL,
            state.blockState,
            state.blockState.getValue(FlapDisplayBlock.HORIZONTAL_FACING)
        );
    }

    @Override
    public boolean method_3563() {
        //        return be.isController;
        return true;
    }

    public static class FlapDisplayRenderState extends KineticRenderState {
        public FlapDisplayData display;
    }

    public static class FlapDisplayData {
        public Map<class_1921, TextRenderState> map = new IdentityHashMap<>();
        public float yRot;

        public void add(int light, boolean glowing, class_11767 textDrawable) {
            map.computeIfAbsent(textDrawable.method_73401(class_6415.field_33993), layer -> new TextRenderState(light)).add(glowing, textDrawable);
        }

        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(yRot));
            matrices.method_46416(-0.5f, 0.5f, 0.3125f);
            matrices.method_22905(0.03125f, -0.03125f, 0.03125f);
            matrices.method_46416(0, 0, 0.5f);
            map.forEach((layer, state) -> queue.method_73483(matrices, layer, state));
            matrices.method_22909();
        }

        public boolean isEmpty() {
            return map.isEmpty();
        }
    }

    public static class TextRenderState implements class_11659.class_11660 {
        public List<class_11767> glowingText = new ArrayList<>();
        public List<class_11767> normalText = new ArrayList<>();
        public int light;

        public TextRenderState(int light) {
            this.light = light;
        }

        public void add(boolean glowing, class_11767 textDrawable) {
            if (glowing) {
                glowingText.add(textDrawable);
            } else {
                normalText.add(textDrawable);
            }
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            Matrix4f pose = matricesEntry.method_23761();
            for (class_11767 glyph : glowingText) {
                glyph.method_73403(pose, vertexConsumer, class_765.field_32767, true);
            }
            for (class_11767 glyph : normalText) {
                glyph.method_73403(pose, vertexConsumer, light, true);
            }
        }
    }
}
