package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.content.trains.entity.Carriage;
import com.zurrtum.create.content.trains.entity.CarriageBogey;
import com.zurrtum.create.content.trains.entity.CarriageContraptionEntity;
import com.zurrtum.create.content.trains.entity.Train;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_12249;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;

public class CarriageCouplingRenderer {
    public static void renderAll(class_310 client, class_4587 ms, class_4597 buffer, class_243 camera) {
        Collection<Train> trains = Create.RAILWAYS.trains.values();
        class_4588 vb = buffer.method_73477(class_12249.method_75965());
        class_2680 air = class_2246.field_10124.method_9564();
        float partialTicks = AnimationTickHolder.getPartialTicks();
        class_1937 level = client.field_1687;

        for (Train train : trains) {
            List<Carriage> carriages = train.carriages;
            for (int i = 0, end = carriages.size() - 1; i < end; i++) {
                Carriage carriage = carriages.get(i);
                CarriageContraptionEntity entity = carriage.getDimensional(level).entity.get();
                Carriage carriage2 = carriages.get(i + 1);
                CarriageContraptionEntity entity2 = carriage.getDimensional(level).entity.get();

                if (entity == null || entity2 == null)
                    continue;

                CarriageBogey bogey1 = carriage.trailingBogey();
                CarriageBogey bogey2 = carriage2.leadingBogey();
                class_243 anchor = bogey1.couplingAnchors.getSecond();
                class_243 anchor2 = bogey2.couplingAnchors.getFirst();

                if (anchor == null || anchor2 == null)
                    continue;
                if (!anchor.method_24802(camera, 64))
                    continue;

                int lightCoords = getPackedLightCoords(entity, partialTicks);
                int lightCoords2 = getPackedLightCoords(entity2, partialTicks);

                double diffX = anchor2.field_1352 - anchor.field_1352;
                double diffY = anchor2.field_1351 - anchor.field_1351;
                double diffZ = anchor2.field_1350 - anchor.field_1350;
                float yRot = AngleHelper.deg(class_3532.method_15349(diffZ, diffX)) + 90;
                float xRot = AngleHelper.deg(Math.atan2(diffY, Math.sqrt(diffX * diffX + diffZ * diffZ)));

                class_243 position = entity.method_30950(partialTicks);
                class_243 position2 = entity2.method_30950(partialTicks);

                ms.method_22903();

                {
                    ms.method_22903();
                    ms.method_22904(anchor.field_1352 - camera.field_1352, anchor.field_1351 - camera.field_1351, anchor.field_1350 - camera.field_1350);
                    CachedBuffers.partial(AllPartialModels.TRAIN_COUPLING_HEAD, air).rotateYDegrees(-yRot).rotateXDegrees(xRot).light(lightCoords)
                        .renderInto(ms.method_23760(), vb);

                    float margin = 3 / 16f;
                    double couplingDistance = train.carriageSpacing.get(i) - 2 * margin - bogey1.type.getConnectorAnchorOffset(bogey1.isUpsideDown()).field_1350 - bogey2.type.getConnectorAnchorOffset(
                        bogey2.isUpsideDown()).field_1350;
                    int couplingSegments = (int) Math.round(couplingDistance * 4);
                    double stretch = ((anchor2.method_1022(anchor) - 2 * margin) * 4) / couplingSegments;
                    for (int j = 0; j < couplingSegments; j++) {
                        CachedBuffers.partial(AllPartialModels.TRAIN_COUPLING_CABLE, air).rotateYDegrees(-yRot + 180).rotateXDegrees(-xRot)
                            .translate(0, 0, margin + 2 / 16f).scale(1, 1, (float) stretch).translate(0, 0, j / 4f).light(lightCoords)
                            .renderInto(ms.method_23760(), vb);
                    }
                    ms.method_22909();
                }

                {
                    ms.method_22903();
                    class_243 translation = position2.method_1020(position).method_1019(anchor2).method_1020(camera);
                    ms.method_22904(translation.field_1352, translation.field_1351, translation.field_1350);
                    CachedBuffers.partial(AllPartialModels.TRAIN_COUPLING_HEAD, air).rotateYDegrees(-yRot + 180).rotateXDegrees(-xRot)
                        .light(lightCoords2).renderInto(ms.method_23760(), vb);
                    ms.method_22909();
                }

                ms.method_22909();
            }
        }

    }

    public static int getPackedLightCoords(class_1297 pEntity, float pPartialTicks) {
        class_2338 blockpos = class_2338.method_49638(pEntity.method_31166(pPartialTicks));
        return class_765.method_23687(getBlockLightLevel(pEntity, blockpos), getSkyLightLevel(pEntity, blockpos));
    }

    protected static int getSkyLightLevel(class_1297 pEntity, class_2338 pPos) {
        return pEntity.method_73183().method_8314(class_1944.field_9284, pPos);
    }

    protected static int getBlockLightLevel(class_1297 pEntity, class_2338 pPos) {
        return pEntity.method_5809() ? 15 : pEntity.method_73183().method_8314(class_1944.field_9282, pPos);
    }
}
