package com.zurrtum.create.client.content.trains.schedule;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllSchedules;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.AllScheduleRenders;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.gui.UIRenderHelper;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.ModularGuiLine;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.Indicator;
import com.zurrtum.create.client.foundation.gui.widget.Indicator.State;
import com.zurrtum.create.client.foundation.gui.widget.Label;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.trains.GlobalRailwayManager;
import com.zurrtum.create.content.trains.graph.EdgePointType;
import com.zurrtum.create.content.trains.graph.TrackGraph;
import com.zurrtum.create.content.trains.schedule.Schedule;
import com.zurrtum.create.content.trains.schedule.ScheduleDataEntry;
import com.zurrtum.create.content.trains.schedule.ScheduleEntry;
import com.zurrtum.create.content.trains.schedule.ScheduleMenu;
import com.zurrtum.create.content.trains.schedule.condition.ScheduleWaitCondition;
import com.zurrtum.create.content.trains.schedule.destination.DestinationInstruction;
import com.zurrtum.create.content.trains.schedule.destination.ScheduleInstruction;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.GhostItemSubmitPacket;
import com.zurrtum.create.infrastructure.packet.c2s.ScheduleEditPacket;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

import java.util.*;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_768;
import net.minecraft.class_8942;
import net.minecraft.class_9129;

import static com.zurrtum.create.Create.LOGGER;

public class ScheduleScreen extends AbstractSimiContainerScreen<ScheduleMenu> {
    private static final int CARD_HEADER = 22;
    private static final int CARD_WIDTH = 195;

    private List<class_768> extraAreas = Collections.emptyList();

    private List<LerpedFloat> horizontalScrolls = new ArrayList<>();
    private LerpedFloat scroll = LerpedFloat.linear().startWithValue(0);
    private ElementWidget renderedItem;

    private Schedule schedule;

    private IconButton confirmButton;
    private IconButton cyclicButton;
    private Indicator cyclicIndicator;

    private IconButton resetProgress;
    private IconButton skipProgress;

    private ScheduleInstruction editingDestination;
    private ScheduleWaitCondition editingCondition;
    private SelectionScrollInput scrollInput;
    private Label scrollInputLabel;
    private IconButton editorConfirm, editorDelete;
    private ModularGuiLine editorSubWidgets;
    private Consumer<Boolean> onEditorClose;

    private DestinationSuggestions destinationSuggestions;

    public ScheduleScreen(ScheduleMenu menu, class_1661 inv, class_2561 title) {
        super(menu, inv, title);
        schedule = new Schedule();
        class_2487 tag = menu.contentHolder.method_58694(AllDataComponents.TRAIN_SCHEDULE);
        if (tag != null && !tag.method_33133()) {
            try (class_8942.class_11340 logging = new class_8942.class_11340(() -> "ScheduleScreen", LOGGER)) {
                class_11368 view = class_11352.method_71417(logging, menu.player.method_56673(), tag);
                schedule = Schedule.read(view);
            }
        }
        menu.slotsActive = false;
        editorSubWidgets = new ModularGuiLine();
    }

    public static ScheduleScreen create(
        class_310 mc,
        MenuType<class_1799> type,
        int syncId,
        class_1661 inventory,
        class_2561 title,
        class_9129 extraData
    ) {
        return type.create(ScheduleScreen::new, syncId, inventory, title, getStack(extraData));
    }

    @Override
    protected void method_25426() {
        AllGuiTextures bg = AllGuiTextures.SCHEDULE;
        setWindowSize(bg.getWidth(), bg.getHeight());
        super.method_25426();
        method_37067();

        confirmButton = new IconButton(field_2776 + bg.getWidth() - 42, field_2800 + bg.getHeight() - 30, AllIcons.I_CONFIRM);
        confirmButton.withCallback(() -> field_22787.field_1724.method_7346());
        method_37063(confirmButton);

        cyclicIndicator = new Indicator(field_2776 + 21, field_2800 + 196, class_5244.field_39003);
        cyclicIndicator.state = schedule.cyclic ? State.ON : State.OFF;

        List<class_2561> tip = new ArrayList<>();
        tip.add(CreateLang.translateDirect("schedule.loop"));
        tip.add(CreateLang.translateDirect("gui.schematicannon.optionDisabled").method_27692(class_124.field_1061));
        tip.add(CreateLang.translateDirect("schedule.loop1").method_27692(class_124.field_1080));
        tip.add(CreateLang.translateDirect("schedule.loop2").method_27692(class_124.field_1080));

        List<class_2561> tipEnabled = new ArrayList<>(tip);
        tipEnabled.set(1, CreateLang.translateDirect("gui.schematicannon.optionEnabled").method_27692(class_124.field_1077));

        cyclicButton = new IconButton(field_2776 + 21, field_2800 + 196, AllIcons.I_REFRESH);
        cyclicButton.withCallback(() -> {
            schedule.cyclic = !schedule.cyclic;
            cyclicButton.green = schedule.cyclic;
            cyclicButton.getToolTip().clear();
            cyclicButton.getToolTip().addAll(schedule.cyclic ? tipEnabled : tip);
        });
        cyclicButton.green = schedule.cyclic;
        cyclicButton.getToolTip().clear();
        cyclicButton.getToolTip().addAll(schedule.cyclic ? tipEnabled : tip);

        method_37063(cyclicButton);

        resetProgress = new IconButton(field_2776 + 45, field_2800 + 196, AllIcons.I_PRIORITY_VERY_HIGH);
        resetProgress.withCallback(() -> {
            schedule.savedProgress = 0;
            resetProgress.field_22763 = false;
        });
        resetProgress.field_22763 = schedule.savedProgress > 0 && !schedule.entries.isEmpty();
        resetProgress.setToolTip(CreateLang.translateDirect("schedule.reset"));
        method_37063(resetProgress);

        skipProgress = new IconButton(field_2776 + 63, field_2800 + 196, AllIcons.I_PRIORITY_LOW);
        skipProgress.withCallback(() -> {
            schedule.savedProgress++;
            schedule.savedProgress %= schedule.entries.size();
            resetProgress.field_22763 = schedule.savedProgress > 0;
        });
        skipProgress.field_22763 = schedule.entries.size() > 1;
        skipProgress.setToolTip(CreateLang.translateDirect("schedule.skip"));
        method_37063(skipProgress);

        stopEditing();
        extraAreas = ImmutableList.of(new class_768(field_2776 + bg.getWidth(), field_2800 + bg.getHeight() - 56, 48, 48));
        horizontalScrolls.clear();
        for (int i = 0; i < schedule.entries.size(); i++)
            horizontalScrolls.add(LerpedFloat.linear().startWithValue(0));

        renderedItem = new ElementWidget(
            field_2776 + AllGuiTextures.SCHEDULE.getWidth(),
            field_2800 + AllGuiTextures.SCHEDULE.getHeight() - 56
        ).showingElement(GuiGameElement.of(field_2797.contentHolder).scale(3));
        method_37063(renderedItem);
    }

    @Override
    public void method_25419() {
        super.method_25419();
        renderedItem.getRenderElement().clear();
    }

    public static <T> List<class_5250> getTypeOptions(List<Pair<class_2960, T>> list) {
        String langSection = list.equals(AllSchedules.INSTRUCTION_TYPES) ? "instruction." : "condition.";
        return list.stream().map(Pair::getFirst).map(rl -> rl.method_12836() + ".schedule." + langSection + rl.method_12832()).map(class_2561::method_43471)
            .toList();
    }

    @SuppressWarnings("unchecked")
    protected <T extends ScheduleDataEntry> void startEditing(IScheduleInput<T> field, T input, Consumer<Boolean> onClose, boolean allowDeletion) {
        onEditorClose = onClose;
        confirmButton.field_22764 = false;
        cyclicButton.field_22764 = false;
        cyclicIndicator.field_22764 = false;
        skipProgress.field_22764 = false;
        resetProgress.field_22764 = false;

        scrollInput = new SelectionScrollInput(field_2776 + 56, field_2800 + 65, 143, 16);
        scrollInputLabel = new Label(field_2776 + 59, field_2800 + 69, class_5244.field_39003).withShadow();
        editorConfirm = new IconButton(field_2776 + 56 + 168, field_2800 + 65 + 22, AllIcons.I_CONFIRM);
        if (allowDeletion)
            editorDelete = new IconButton(field_2776 + 56 - 45, field_2800 + 65 + 22, AllIcons.I_TRASH);
        field_2797.slotsActive = true;
        field_2797.targetSlotsActive = field.slotsTargeted();

        for (int i = 0; i < field.slotsTargeted(); i++) {
            class_1799 item = field.getItem(input, i);
            field_2797.ghostInventory.method_5447(i, item);
            field_22787.field_1724.field_3944.method_52787(new GhostItemSubmitPacket(item, i));
        }

        if (input instanceof ScheduleInstruction instruction) {
            int startIndex = 0;
            for (int i = 0; i < AllSchedules.INSTRUCTION_TYPES.size(); i++)
                if (AllSchedules.INSTRUCTION_TYPES.get(i).getFirst().equals(instruction.getId()))
                    startIndex = i;
            editingDestination = instruction;
            updateEditorSubwidgets((IScheduleInput<ScheduleInstruction>) field, editingDestination);
            scrollInput.forOptions(getTypeOptions(AllSchedules.INSTRUCTION_TYPES)).titled(CreateLang.translateDirect("schedule.instruction_type"))
                .writingTo(scrollInputLabel).calling(index -> {
                    Pair<class_2960, Function<class_2960, ? extends ScheduleInstruction>> pair = AllSchedules.INSTRUCTION_TYPES.get(index);
                    ScheduleInstruction newlyCreated = pair.getSecond().apply(pair.getFirst());
                    if (editingDestination.getId().equals(newlyCreated.getId()))
                        return;
                    editingDestination = newlyCreated;
                    updateEditorSubwidgets(AllScheduleRenders.get(newlyCreated), editingDestination);
                }).setState(startIndex);
        }

        if (input instanceof ScheduleWaitCondition cond) {
            int startIndex = 0;
            for (int i = 0; i < AllSchedules.CONDITION_TYPES.size(); i++)
                if (AllSchedules.CONDITION_TYPES.get(i).getFirst().equals(cond.getId()))
                    startIndex = i;
            editingCondition = cond;
            updateEditorSubwidgets((IScheduleInput<ScheduleWaitCondition>) field, editingCondition);
            scrollInput.forOptions(getTypeOptions(AllSchedules.CONDITION_TYPES)).titled(CreateLang.translateDirect("schedule.condition_type"))
                .writingTo(scrollInputLabel).calling(index -> {
                    Pair<class_2960, Function<class_2960, ? extends ScheduleWaitCondition>> pair = AllSchedules.CONDITION_TYPES.get(index);
                    ScheduleWaitCondition newlyCreated = pair.getSecond().apply(pair.getFirst());
                    if (editingCondition.getId().equals(newlyCreated.getId()))
                        return;
                    editingCondition = newlyCreated;
                    updateEditorSubwidgets(AllScheduleRenders.get(newlyCreated), editingCondition);
                }).setState(startIndex);
        }

        method_37063(scrollInput);
        method_37063(scrollInputLabel);
        method_37063(editorConfirm);
        if (allowDeletion)
            method_37063(editorDelete);
    }

    private void onDestinationEdited(String text) {
        if (destinationSuggestions != null)
            destinationSuggestions.method_23934();
    }

    protected void stopEditing() {
        confirmButton.field_22764 = true;
        cyclicButton.field_22764 = true;
        cyclicIndicator.field_22764 = true;
        skipProgress.field_22764 = true;
        resetProgress.field_22764 = true;

        if (editingCondition == null && editingDestination == null)
            return;

        destinationSuggestions = null;

        method_37066(scrollInput);
        method_37066(scrollInputLabel);
        method_37066(editorConfirm);
        method_37066(editorDelete);

        ScheduleDataEntry input = editingCondition == null ? editingDestination : editingCondition;
        IScheduleInput<ScheduleDataEntry> editing = AllScheduleRenders.get(input);
        for (int i = 0; i < editing.slotsTargeted(); i++) {
            editing.setItem(input, i, field_2797.ghostInventory.method_5438(i));
            field_22787.field_1724.field_3944.method_52787(new GhostItemSubmitPacket(class_1799.field_8037, i));
        }

        editorSubWidgets.saveValues(input.getData());
        editorSubWidgets.forEach(this::method_37066);
        editorSubWidgets.clear();

        editingCondition = null;
        editingDestination = null;
        editorConfirm = null;
        editorDelete = null;
        field_2797.slotsActive = false;
        renderedItem.getRenderElement().clear();
        method_25426();
    }

    protected <T extends ScheduleDataEntry> void updateEditorSubwidgets(IScheduleInput<T> field, T input) {
        destinationSuggestions = null;
        field_2797.targetSlotsActive = field.slotsTargeted();

        editorSubWidgets.forEach(this::method_37066);
        editorSubWidgets.clear();
        field.initConfigurationWidgets(input, new ModularGuiLineBuilder(field_22793, editorSubWidgets, field_2776 + 77, field_2800 + 92).speechBubble());
        editorSubWidgets.loadValues(input.getData(), this::method_37063, this::method_37060);

        if (!(input instanceof DestinationInstruction destinationInstruction))
            return;

        editorSubWidgets.forEach(e -> {
            if (!(e instanceof class_342 destinationBox))
                return;
            destinationSuggestions = new DestinationSuggestions(
                field_22787,
                this,
                destinationBox,
                field_22793,
                getViableStations(destinationInstruction),
                false,
                field_2800 + 33
            );
            destinationSuggestions.method_23933(true);
            destinationSuggestions.method_23934();
            destinationBox.method_1863(this::onDestinationEdited);
        });
    }

    private List<IntAttached<String>> getViableStations(DestinationInstruction field) {
        GlobalRailwayManager railwayManager = Create.RAILWAYS;
        Set<TrackGraph> viableGraphs = new HashSet<>(railwayManager.trackNetworks.values());

        for (ScheduleEntry entry : schedule.entries) {
            if (!(entry.instruction instanceof DestinationInstruction destination))
                continue;
            if (destination == field)
                continue;
            String filter = destination.getFilterForRegex();
            if (filter.isBlank())
                continue;
            Graphs:
            for (Iterator<TrackGraph> iterator = viableGraphs.iterator(); iterator.hasNext(); ) {
                TrackGraph trackGraph = iterator.next();
                for (GlobalStation station : trackGraph.getPoints(EdgePointType.STATION)) {
                    if (station.name.matches(filter))
                        continue Graphs;
                }
                iterator.remove();
            }
        }

        if (viableGraphs.isEmpty())
            viableGraphs = new HashSet<>(railwayManager.trackNetworks.values());

        class_243 position = field_22787.field_1724.method_73189();
        Set<String> visited = new HashSet<>();

        return viableGraphs.stream().flatMap(g -> g.getPoints(EdgePointType.STATION).stream()).filter(station -> station.blockEntityPos != null)
            .filter(station -> visited.add(station.name))
            .map(station -> IntAttached.with((int) class_243.method_24955(station.blockEntityPos).method_1022(position), station.name)).toList();
    }

    @Override
    protected void method_37432() {
        super.method_37432();
        scroll.tickChaser();
        for (LerpedFloat lerpedFloat : horizontalScrolls)
            lerpedFloat.tickChaser();

        if (destinationSuggestions != null)
            destinationSuggestions.tick();

        schedule.savedProgress = schedule.entries.isEmpty() ? 0 : class_3532.method_15340(schedule.savedProgress, 0, schedule.entries.size() - 1);
        resetProgress.field_22763 = schedule.savedProgress > 0;
        skipProgress.field_22763 = schedule.entries.size() > 1;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        partialTicks = field_22787.method_61966().method_60637(false);

        if (field_2797.slotsActive)
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
        else {
            for (class_4068 widget : field_33816)
                widget.method_25394(graphics, mouseX, mouseY, partialTicks);
            renderForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSchedule(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.method_51448();
        UIRenderHelper.drawStretched(graphics, field_2776 + 33, field_2800 + 16, 3, 173, AllGuiTextures.SCHEDULE_STRIP_DARK);

        int yOffset = 25;
        List<ScheduleEntry> entries = schedule.entries;
        float scrollOffset = -scroll.getValue(partialTicks);

        graphics.method_44379(field_2776, field_2800 + 16, field_2776 + 236, field_2800 + 189);

        for (int i = 0; i <= entries.size(); i++) {

            if (schedule.savedProgress == i && !schedule.entries.isEmpty()) {
                matrixStack.pushMatrix();
                float expectedY = scrollOffset + field_2800 + yOffset + 4;
                float actualY = class_3532.method_15363(expectedY, field_2800 + 18, field_2800 + 170);
                matrixStack.translate(0, actualY);
                (expectedY == actualY ? AllGuiTextures.SCHEDULE_POINTER : AllGuiTextures.SCHEDULE_POINTER_OFFSCREEN).render(graphics, field_2776, 0);
                matrixStack.popMatrix();
            }

            matrixStack.pushMatrix();
            matrixStack.translate(0, scrollOffset);
            if (i == 0 || entries.size() == 0)
                UIRenderHelper.drawStretched(graphics, field_2776 + 33, field_2800 + 16, 3, 10, AllGuiTextures.SCHEDULE_STRIP_LIGHT);

            if (i == entries.size()) {
                if (i > 0)
                    yOffset += 9;
                AllGuiTextures.SCHEDULE_STRIP_END.render(graphics, field_2776 + 29, field_2800 + yOffset);
                AllGuiTextures.SCHEDULE_CARD_NEW.render(graphics, field_2776 + 43, field_2800 + yOffset);
                matrixStack.popMatrix();
                break;
            }

            ScheduleEntry scheduleEntry = entries.get(i);
            int cardY = yOffset;
            int cardHeight = renderScheduleEntry(graphics, scheduleEntry, cardY, mouseX, mouseY, partialTicks);
            yOffset += cardHeight;

            if (i + 1 < entries.size()) {
                AllGuiTextures.SCHEDULE_STRIP_DOTTED.render(graphics, field_2776 + 29, field_2800 + yOffset - 3);
                yOffset += 10;
            }

            matrixStack.popMatrix();

            if (!scheduleEntry.instruction.supportsConditions())
                continue;

            float h = cardHeight - 26;
            float y1 = cardY + 24 + scrollOffset;
            float y2 = y1 + h;
            if (y2 > 189)
                h -= y2 - 189;
            if (y1 < 16) {
                float correction = 16 - y1;
                y1 += correction;
                h -= correction;
            }

            if (h <= 0)
                continue;

            graphics.method_44379(field_2776 + 43, 0, field_2776 + 204, 400);
            matrixStack.pushMatrix();
            matrixStack.translate(0, scrollOffset);
            renderScheduleConditions(graphics, scheduleEntry, cardY, mouseX, mouseY, partialTicks, cardHeight, i);
            matrixStack.popMatrix();
            graphics.method_44380();

            if (isConditionAreaScrollable(scheduleEntry)) {
                matrixStack.pushMatrix();
                matrixStack.translate(0, scrollOffset);
                int center = (cardHeight - 8 + CARD_HEADER) / 2;
                float chaseTarget = horizontalScrolls.get(i).getChaseTarget();
                if (!class_3532.method_15347(chaseTarget, 0))
                    AllGuiTextures.SCHEDULE_SCROLL_LEFT.render(graphics, field_2776 + 40, field_2800 + cardY + center);
                if (!class_3532.method_15347(chaseTarget, scheduleEntry.conditions.size() - 1))
                    AllGuiTextures.SCHEDULE_SCROLL_RIGHT.render(graphics, field_2776 + 203, field_2800 + cardY + center);
                matrixStack.popMatrix();
            }
        }

        graphics.method_44380();

        graphics.method_25296(field_2776 + 16, field_2800 + 16, field_2776 + 16 + 220, field_2800 + 16 + 10, 0x77000000, 0x00000000);
        graphics.method_25296(field_2776 + 16, field_2800 + 179, field_2776 + 16 + 220, field_2800 + 179 + 10, 0x00000000, 0x77000000);
    }

    public int renderScheduleEntry(class_332 graphics, ScheduleEntry entry, int yOffset, int mouseX, int mouseY, float partialTicks) {
        int zLevel = 100;
        AllGuiTextures light = AllGuiTextures.SCHEDULE_CARD_LIGHT;
        AllGuiTextures medium = AllGuiTextures.SCHEDULE_CARD_MEDIUM;
        AllGuiTextures dark = AllGuiTextures.SCHEDULE_CARD_DARK;

        int cardWidth = CARD_WIDTH;
        int cardHeader = CARD_HEADER;
        int maxRows = 0;
        for (List<ScheduleWaitCondition> list : entry.conditions)
            maxRows = Math.max(maxRows, list.size());
        ScheduleInstruction instruction = entry.instruction;
        boolean supportsConditions = instruction.supportsConditions();
        int cardHeight = cardHeader + (supportsConditions ? 24 + maxRows * 18 : 4);

        Matrix3x2fStack matrixStack = graphics.method_51448();
        matrixStack.pushMatrix();
        matrixStack.translate(field_2776 + 25, field_2800 + yOffset);

        UIRenderHelper.drawStretched(graphics, 0, 1, cardWidth, cardHeight - 2, light);
        UIRenderHelper.drawStretched(graphics, 1, 0, cardWidth - 2, cardHeight, light);
        UIRenderHelper.drawStretched(graphics, 1, 1, cardWidth - 2, cardHeight - 2, dark);
        UIRenderHelper.drawStretched(graphics, 2, 2, cardWidth - 4, cardHeight - 4, medium);
        UIRenderHelper.drawStretched(graphics, 2, 2, cardWidth - 4, cardHeader, supportsConditions ? light : medium);

        AllGuiTextures.SCHEDULE_CARD_REMOVE.render(graphics, cardWidth - 14, 2);
        AllGuiTextures.SCHEDULE_CARD_DUPLICATE.render(graphics, cardWidth - 14, cardHeight - 14);

        int i = schedule.entries.indexOf(entry);
        if (i > 0)
            AllGuiTextures.SCHEDULE_CARD_MOVE_UP.render(graphics, cardWidth, cardHeader - 14);
        if (i < schedule.entries.size() - 1)
            AllGuiTextures.SCHEDULE_CARD_MOVE_DOWN.render(graphics, cardWidth, cardHeader);

        UIRenderHelper.drawStretched(graphics, 8, 0, 3, cardHeight + 10, AllGuiTextures.SCHEDULE_STRIP_LIGHT);
        (supportsConditions ? AllGuiTextures.SCHEDULE_STRIP_TRAVEL : AllGuiTextures.SCHEDULE_STRIP_ACTION).render(graphics, 4, 6);

        if (supportsConditions)
            AllGuiTextures.SCHEDULE_STRIP_WAIT.render(graphics, 4, 28);

        IScheduleInput<ScheduleInstruction> scheduleInput = AllScheduleRenders.get(instruction);
        Pair<class_1799, class_2561> destination = scheduleInput.getSummary(instruction);
        renderInput(graphics, destination, 26, 5, false, 100);
        scheduleInput.renderSpecialIcon(instruction, graphics, 30, 5);

        matrixStack.popMatrix();

        return cardHeight;
    }

    public void renderScheduleConditions(
        class_332 graphics,
        ScheduleEntry entry,
        int yOffset,
        int mouseX,
        int mouseY,
        float partialTicks,
        int cardHeight,
        int entryIndex
    ) {
        int cardWidth = CARD_WIDTH;
        int cardHeader = CARD_HEADER;

        Matrix3x2fStack matrixStack = graphics.method_51448();
        matrixStack.pushMatrix();
        matrixStack.translate(field_2776 + 25, field_2800 + yOffset);
        int xOffset = 26;
        float scrollOffset = getConditionScroll(entry, partialTicks, entryIndex);

        matrixStack.pushMatrix();
        matrixStack.translate(-scrollOffset, 0);

        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = getConditionColumnWidth(list);
            for (int i = 0; i < list.size(); i++) {
                ScheduleWaitCondition scheduleWaitCondition = list.get(i);
                IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(scheduleWaitCondition);
                Math.max(maxWidth, renderInput(graphics, scheduleInput.getSummary(scheduleWaitCondition), xOffset, 29 + i * 18, i != 0, maxWidth));
                scheduleInput.renderSpecialIcon(scheduleWaitCondition, graphics, xOffset + 4, 29 + i * 18);
            }

            AllGuiTextures.SCHEDULE_CONDITION_APPEND.render(graphics, xOffset + (maxWidth - 10) / 2, 29 + list.size() * 18);
            xOffset += maxWidth + 10;
        }

        AllGuiTextures.SCHEDULE_CONDITION_NEW.render(graphics, xOffset - 3, 29);
        matrixStack.popMatrix();

        if (xOffset + 16 > cardWidth - 26) {
            matrixStack.rotate(class_3532.field_29847 * -90);
            graphics.method_25296(-cardHeight + 2, 18, -2 - cardHeader, 28, 0x44000000, 0x00000000);
            graphics.method_25296(-cardHeight + 2, cardWidth - 26, -2 - cardHeader, cardWidth - 16, 0x00000000, 0x44000000);
        }

        matrixStack.popMatrix();
    }

    private boolean isConditionAreaScrollable(ScheduleEntry entry) {
        int xOffset = 26;
        for (List<ScheduleWaitCondition> list : entry.conditions)
            xOffset += getConditionColumnWidth(list) + 10;
        return xOffset + 16 > CARD_WIDTH - 26;
    }

    private float getConditionScroll(ScheduleEntry entry, float partialTicks, int entryIndex) {
        float scrollOffset = 0;
        float scrollIndex = horizontalScrolls.get(entryIndex).getValue(partialTicks);
        for (List<ScheduleWaitCondition> list : entry.conditions) {
            int maxWidth = getConditionColumnWidth(list);
            float partialOfThisColumn = Math.min(1, scrollIndex);
            scrollOffset += (maxWidth + 10) * partialOfThisColumn;
            scrollIndex -= partialOfThisColumn;
        }
        return scrollOffset;
    }

    private int getConditionColumnWidth(List<ScheduleWaitCondition> list) {
        int maxWidth = 0;
        for (ScheduleWaitCondition scheduleWaitCondition : list) {
            IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(scheduleWaitCondition);
            maxWidth = Math.max(maxWidth, getFieldSize(32, scheduleInput.getSummary(scheduleWaitCondition)));
        }
        return maxWidth;
    }

    protected int renderInput(class_332 graphics, Pair<class_1799, class_2561> pair, int x, int y, boolean clean, int minSize) {
        class_1799 stack = pair.getFirst();
        class_2561 text = pair.getSecond();
        boolean hasItem = !stack.method_7960();
        int fieldSize = Math.min(getFieldSize(minSize, pair), 150);
        Matrix3x2fStack matrixStack = graphics.method_51448();
        matrixStack.pushMatrix();

        AllGuiTextures left = clean ? AllGuiTextures.SCHEDULE_CONDITION_LEFT_CLEAN : AllGuiTextures.SCHEDULE_CONDITION_LEFT;
        AllGuiTextures middle = AllGuiTextures.SCHEDULE_CONDITION_MIDDLE;
        AllGuiTextures item = AllGuiTextures.SCHEDULE_CONDITION_ITEM;
        AllGuiTextures right = AllGuiTextures.SCHEDULE_CONDITION_RIGHT;

        matrixStack.translate(x, y);
        UIRenderHelper.drawStretched(graphics, 0, 0, fieldSize, 16, middle);
        left.render(graphics, clean ? 0 : -3, 0);
        right.render(graphics, fieldSize - 2, 0);
        if (hasItem) {
            item.render(graphics, 3, 0);
            if (stack.method_7909() != class_1802.field_8615)
                graphics.method_51427(stack, 4, 0);
        }

        if (text != null)
            graphics.method_51433(field_22793, field_22793.method_1714(text, 120).getString(), hasItem ? 28 : 8, 4, 0xff_f2f2ee, true);

        matrixStack.popMatrix();
        return fieldSize;
    }

    private class_2561 clickToEdit = CreateLang.translateDirect("gui.schedule.lmb_edit").method_27695(class_124.field_1063, class_124.field_1056);
    private class_2561 rClickToDelete = CreateLang.translateDirect("gui.schedule.rmb_remove")
        .method_27695(class_124.field_1063, class_124.field_1056);

    public boolean action(@Nullable class_332 graphics, double mouseX, double mouseY, int click) {
        if (editingCondition != null || editingDestination != null)
            return false;

        class_2561 empty = class_5244.field_39003;

        int mx = (int) mouseX;
        int my = (int) mouseY;
        int x = mx - this.field_2776 - 25;
        int y = my - this.field_2800 - 25;
        if (x < 0 || x >= 205)
            return false;
        if (y < 0 || y >= 173)
            return false;
        y += scroll.getValue(0);

        List<ScheduleEntry> entries = schedule.entries;
        for (int i = 0; i < entries.size(); i++) {
            ScheduleEntry entry = entries.get(i);
            int maxRows = 0;
            for (List<ScheduleWaitCondition> list : entry.conditions)
                maxRows = Math.max(maxRows, list.size());
            ScheduleInstruction instruction = entry.instruction;
            int cardHeight = CARD_HEADER + (instruction.supportsConditions() ? 24 + maxRows * 18 : 4);

            if (y >= cardHeight + 5) {
                y -= cardHeight + 10;
                if (y < 0)
                    return false;
                continue;
            }

            IScheduleInput<ScheduleInstruction> input = AllScheduleRenders.get(instruction);
            int fieldSize = getFieldSize(100, input.getSummary(instruction));
            if (x > 25 && x <= 25 + fieldSize && y > 4 && y <= 20) {
                List<class_2561> components = new ArrayList<>();
                components.addAll(input.getTitleAs(instruction, "instruction"));
                components.add(empty);
                components.add(clickToEdit);
                renderActionTooltip(graphics, components, mx, my);
                if (click == 0)
                    startEditing(
                        input, instruction, confirmed -> {
                            if (confirmed)
                                entry.instruction = editingDestination;
                        }, false
                    );
                return true;
            }

            if (x > 180 && x <= 192) {
                if (y > 0 && y <= 14) {
                    renderActionTooltip(graphics, ImmutableList.of(CreateLang.translateDirect("gui.schedule.remove_entry")), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        renderedItem.getRenderElement().clear();
                        method_25426();
                    }
                    return true;
                }
                if (y > cardHeight - 14) {
                    renderActionTooltip(graphics, ImmutableList.of(CreateLang.translateDirect("gui.schedule.duplicate")), mx, my);
                    if (click == 0) {
                        entries.add(entries.indexOf(entry), entry.clone(field_22787.field_1687.method_30349()));
                        renderedItem.getRenderElement().clear();
                        method_25426();
                    }
                    return true;
                }
            }

            if (x > 194) {
                if (y > 7 && y <= 20 && i > 0) {
                    renderActionTooltip(graphics, ImmutableList.of(CreateLang.translateDirect("gui.schedule.move_up")), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i - 1, entry);
                        renderedItem.getRenderElement().clear();
                        method_25426();
                    }
                    return true;
                }
                if (y > 20 && y <= 33 && i < entries.size() - 1) {
                    renderActionTooltip(graphics, ImmutableList.of(CreateLang.translateDirect("gui.schedule.move_down")), mx, my);
                    if (click == 0) {
                        entries.remove(entry);
                        entries.add(i + 1, entry);
                        renderedItem.getRenderElement().clear();
                        method_25426();
                    }
                    return true;
                }
            }

            int center = (cardHeight - 8 + CARD_HEADER) / 2;
            if (y > center - 1 && y <= center + 7 && isConditionAreaScrollable(entry)) {
                float chaseTarget = horizontalScrolls.get(i).getChaseTarget();
                if (x > 12 && x <= 19 && !class_3532.method_15347(chaseTarget, 0)) {
                    if (click == 0)
                        horizontalScrolls.get(i).chase(chaseTarget - 1, 0.5f, Chaser.EXP);
                    return true;
                }
                if (x > 177 && x <= 184 && !class_3532.method_15347(chaseTarget, entry.conditions.size() - 1)) {
                    if (click == 0)
                        horizontalScrolls.get(i).chase(chaseTarget + 1, 0.5f, Chaser.EXP);
                    return true;
                }
            }

            x -= 18;
            y -= 28;
            if (x < 0 || y < 0 || x > 160)
                return false;
            x += getConditionScroll(entry, 0, i) - 8;

            List<List<ScheduleWaitCondition>> columns = entry.conditions;
            for (int j = 0; j < columns.size(); j++) {
                List<ScheduleWaitCondition> conditions = columns.get(j);
                if (x < 0)
                    return false;
                int w = getConditionColumnWidth(conditions);
                if (x >= w) {
                    x -= w + 10;
                    continue;
                }

                int row = y / 18;
                if (row < conditions.size() && row >= 0) {
                    boolean canRemove = conditions.size() > 1 || columns.size() > 1;
                    List<class_2561> components = new ArrayList<>();
                    components.add(CreateLang.translateDirect("schedule.condition_type").method_27692(class_124.field_1080));
                    ScheduleWaitCondition condition = conditions.get(row);
                    IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(condition);
                    components.addAll(scheduleInput.getTitleAs(condition, "condition"));
                    components.add(empty);
                    components.add(clickToEdit);
                    if (canRemove)
                        components.add(rClickToDelete);
                    renderActionTooltip(graphics, components, mx, my);
                    if (canRemove && click == 1) {
                        conditions.remove(row);
                        if (conditions.isEmpty())
                            columns.remove(conditions);
                    }
                    if (click == 0)
                        startEditing(
                            scheduleInput, condition, confirmed -> {
                                conditions.remove(row);
                                if (confirmed) {
                                    conditions.add(row, editingCondition);
                                    return;
                                }
                                if (conditions.isEmpty())
                                    columns.remove(conditions);
                            }, canRemove
                        );
                    return true;
                }

                if (y > 18 * conditions.size() && y <= 18 * conditions.size() + 10 && x >= w / 2 - 5 && x < w / 2 + 5) {
                    renderActionTooltip(graphics, ImmutableList.of(CreateLang.translateDirect("gui.schedule.add_condition")), mx, my);
                    if (click == 0) {
                        ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(AllSchedules.DELAY);
                        IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(condition);
                        startEditing(
                            scheduleInput, condition, confirmed -> {
                                if (confirmed)
                                    conditions.add(editingCondition);
                            }, true
                        );
                    }
                    return true;
                }

                return false;
            }

            if (x < 0 || x > 15 || y > 20)
                return false;

            renderActionTooltip(graphics, ImmutableList.of(CreateLang.translateDirect("gui.schedule.alternative_condition")), mx, my);
            if (click == 0) {
                ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(AllSchedules.DELAY);
                IScheduleInput<ScheduleWaitCondition> scheduleInput = AllScheduleRenders.get(condition);
                startEditing(
                    scheduleInput, condition, confirmed -> {
                        if (!confirmed)
                            return;
                        ArrayList<ScheduleWaitCondition> conditions = new ArrayList<>();
                        conditions.add(editingCondition);
                        columns.add(conditions);
                    }, true
                );
            }
            return true;
        }

        if (x < 18 || x > 33 || y > 14)
            return false;

        renderActionTooltip(graphics, ImmutableList.of(CreateLang.translateDirect("gui.schedule.add_entry")), mx, my);
        if (click == 0) {
            ScheduleInstruction instruction = AllSchedules.createScheduleInstruction(AllSchedules.DESTINATION);
            IScheduleInput<ScheduleInstruction> scheduleInput = AllScheduleRenders.get(instruction);
            startEditing(
                scheduleInput, instruction, confirmed -> {
                    if (!confirmed)
                        return;

                    ScheduleEntry entry = new ScheduleEntry();
                    ScheduleWaitCondition condition = AllSchedules.createScheduleWaitCondition(AllSchedules.DELAY);
                    ArrayList<ScheduleWaitCondition> initialConditions = new ArrayList<>();
                    initialConditions.add(condition);
                    entry.instruction = editingDestination;
                    entry.conditions.add(initialConditions);
                    schedule.entries.add(entry);
                }, true
            );
        }
        return true;
    }

    private void renderActionTooltip(@Nullable class_332 graphics, List<class_2561> tooltip, int mx, int my) {
        if (graphics != null)
            graphics.method_64038(field_22793, tooltip, Optional.empty(), mx, my);
    }

    private int getFieldSize(int minSize, Pair<class_1799, class_2561> pair) {
        class_1799 stack = pair.getFirst();
        class_2561 text = pair.getSecond();
        boolean hasItem = !stack.method_7960();
        return Math.max((text == null ? 0 : field_22793.method_27525(text)) + (hasItem ? 20 : 0) + 16, minSize);
    }

    @Override
    public boolean method_25402(class_11909 click, boolean doubled) {
        if (destinationSuggestions != null && destinationSuggestions.method_23922(click))
            return true;
        double pMouseX = click.comp_4798();
        double pMouseY = click.comp_4799();
        if (editorConfirm != null && editorConfirm.method_25405(pMouseX, pMouseY) && onEditorClose != null) {
            onEditorClose.accept(true);
            stopEditing();
            return true;
        }
        if (editorDelete != null && editorDelete.method_25405(pMouseX, pMouseY) && onEditorClose != null) {
            onEditorClose.accept(false);
            stopEditing();
            return true;
        }
        if (action(null, pMouseX, pMouseY, click.method_74245()))
            return true;

        return super.method_25402(click, doubled);
    }

    @Override
    public boolean method_25404(class_11908 input) {
        if (destinationSuggestions != null && destinationSuggestions.method_23924(input))
            return true;
        if (editingCondition == null && editingDestination == null)
            return super.method_25404(input);
        int pKeyCode = input.comp_4795();
        boolean hitEnter = method_25399() instanceof class_342 && (pKeyCode == 257 || pKeyCode == 335);
        boolean hitE = method_25399() == null && field_22787.field_1690.field_1822.method_1417(input);
        if (hitE || hitEnter) {
            onEditorClose.accept(true);
            stopEditing();
            return true;
        }
        return super.method_25404(input);
    }

    @Override
    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (destinationSuggestions != null && destinationSuggestions.method_23921(class_3532.method_15350(pScrollY, -1.0D, 1.0D)))
            return true;
        if (editingCondition != null || editingDestination != null)
            return method_19355(pMouseX, pMouseY).filter(element -> element.method_25401(pMouseX, pMouseY, pScrollX, pScrollY)).isPresent();

        if (AllKeys.hasShiftDown()) {
            List<ScheduleEntry> entries = schedule.entries;
            int y = (int) (pMouseY - this.field_2800 - 25 + scroll.getValue());
            for (int i = 0; i < entries.size(); i++) {
                ScheduleEntry entry = entries.get(i);
                int maxRows = 0;
                for (List<ScheduleWaitCondition> list : entry.conditions)
                    maxRows = Math.max(maxRows, list.size());
                int cardHeight = CARD_HEADER + 24 + maxRows * 18;

                if (y >= cardHeight) {
                    y -= cardHeight + 9;
                    if (y < 0)
                        break;
                    continue;
                }

                if (!isConditionAreaScrollable(entry))
                    break;
                if (y < 24)
                    break;
                if (pMouseX < field_2776 + 25)
                    break;
                if (pMouseX > field_2776 + 205)
                    break;
                float chaseTarget = horizontalScrolls.get(i).getChaseTarget();
                if (pScrollY > 0 && !class_3532.method_15347(chaseTarget, 0)) {
                    horizontalScrolls.get(i).chase(chaseTarget - 1, 0.5f, Chaser.EXP);
                    return true;
                }
                if (pScrollY < 0 && !class_3532.method_15347(chaseTarget, entry.conditions.size() - 1)) {
                    horizontalScrolls.get(i).chase(chaseTarget + 1, 0.5f, Chaser.EXP);
                    return true;
                }
                return false;
            }
        }

        float chaseTarget = scroll.getChaseTarget();
        float max = 40 - 173;
        for (ScheduleEntry scheduleEntry : schedule.entries) {
            int maxRows = 0;
            for (List<ScheduleWaitCondition> list : scheduleEntry.conditions)
                maxRows = Math.max(maxRows, list.size());
            max += CARD_HEADER + 24 + maxRows * 18 + 10;
        }
        if (max > 0) {
            chaseTarget -= pScrollY * 12;
            chaseTarget = class_3532.method_15363(chaseTarget, 0, max);
            scroll.chase((int) chaseTarget, 0.7f, Chaser.EXP);
        } else
            scroll.chase(0, 0.7f, Chaser.EXP);

        return super.method_25401(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Override
    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        Matrix3x2fStack matrixStack = graphics.method_51448();
        if (destinationSuggestions != null) {
            matrixStack.pushMatrix();
            destinationSuggestions.method_23923(graphics, mouseX, mouseY);
            matrixStack.popMatrix();
        }

        super.renderForeground(graphics, mouseX, mouseY, partialTicks);

        action(graphics, mouseX, mouseY, -1);

        if (editingCondition == null && editingDestination == null)
            return;

        int x = this.field_2776 + 53;
        int y = this.field_2800 + 87;
        if (mouseX < x || mouseY < y || mouseX >= x + 120 || mouseY >= y + 18)
            return;

        ScheduleDataEntry entry = editingCondition == null ? editingDestination : editingCondition;
        IScheduleInput<ScheduleDataEntry> rendered = AllScheduleRenders.get(entry);

        for (int i = 0; i < Math.max(1, rendered.slotsTargeted()); i++) {
            List<class_2561> secondLineTooltip = rendered.getSecondLineTooltip(i);
            if (secondLineTooltip == null)
                continue;
            class_1735 slot = field_2797.method_7611(36 + i);
            if (slot == null || !slot.method_7677().method_7960())
                continue;
            if (mouseX < this.field_2776 + slot.field_7873 || mouseX > this.field_2776 + slot.field_7873 + 18)
                continue;
            if (mouseY < this.field_2800 + slot.field_7872 || mouseY > this.field_2800 + slot.field_7872 + 18)
                continue;
            renderActionTooltip(graphics, secondLineTooltip, mouseX, mouseY);
        }
    }

    @Override
    protected void method_2389(class_332 graphics, float pPartialTick, int pMouseX, int pMouseY) {
        pPartialTick = AnimationTickHolder.getPartialTicksUI(field_22787.method_61966());
        AllGuiTextures.SCHEDULE.render(graphics, field_2776, field_2800);
        class_5481 formattedcharsequence = field_22785.method_30937();
        int center = field_2776 + (AllGuiTextures.SCHEDULE.getWidth() - 8) / 2;
        graphics.method_51430(field_22793, formattedcharsequence, center - field_22793.method_30880(formattedcharsequence) / 2, field_2800 + 4, 0xFF505050, false);
        renderSchedule(graphics, pMouseX, pMouseY, pPartialTick);

        if (editingCondition == null && editingDestination == null)
            return;

        graphics.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        AllGuiTextures.SCHEDULE_EDITOR.render(graphics, field_2776 - 2, field_2800 + 40);
        AllGuiTextures.PLAYER_INVENTORY.render(graphics, field_2776 + 38, field_2800 + 122);
        graphics.method_51439(field_22793, field_29347, field_2776 + 46, field_2800 + 128, 0xFF505050, false);

        formattedcharsequence = editingCondition == null ? CreateLang.translateDirect("schedule.instruction.editor")
            .method_30937() : CreateLang.translateDirect("schedule.condition.editor").method_30937();
        graphics.method_51430(field_22793, formattedcharsequence, (center - field_22793.method_30880(formattedcharsequence) / 2), field_2800 + 44, 0xFF505050, false);

        ScheduleDataEntry entry = editingCondition == null ? editingDestination : editingCondition;
        IScheduleInput<ScheduleDataEntry> rendered = AllScheduleRenders.get(entry);

        for (int i = 0; i < rendered.slotsTargeted(); i++)
            AllGuiTextures.SCHEDULE_EDITOR_ADDITIONAL_SLOT.render(graphics, field_2776 + 53 + 20 * i, field_2800 + 87);

        if (rendered.slotsTargeted() == 0 && !rendered.renderSpecialIcon(entry, graphics, field_2776 + 54, field_2800 + 88)) {
            Pair<class_1799, class_2561> summary = rendered.getSummary(entry);
            class_1799 icon = summary.getFirst();
            if (icon.method_7960())
                icon = rendered.getSecondLineIcon();
            if (icon.method_7960())
                AllGuiTextures.SCHEDULE_EDITOR_INACTIVE_SLOT.render(graphics, field_2776 + 53, field_2800 + 87);
            else
                graphics.method_51427(icon, field_2776 + 54, field_2800 + 88);
        }

        Matrix3x2fStack pPoseStack = graphics.method_51448();
        pPoseStack.pushMatrix();
        pPoseStack.translate(0, field_2800 + 87);
        editorSubWidgets.renderWidgetBG(field_2776 + 77, graphics);
        pPoseStack.popMatrix();
    }

    @Override
    public void method_25432() {
        super.method_25432();
        field_22787.field_1724.field_3944.method_52787(new ScheduleEditPacket(schedule));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return extraAreas;
    }

}
