package com.zurrtum.create.client.content.trains.station;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer.DepotItemState;
import com.zurrtum.create.client.content.logistics.depot.DepotRenderer.DepotOutputItemState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.trains.station.GlobalStation;
import com.zurrtum.create.content.trains.station.StationBlock;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour.RenderedTrackOverlayType;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_827;

public class StationRenderer implements class_827<StationBlockEntity, StationRenderer.StationRenderState> {
    protected final class_10442 itemModelManager;

    public StationRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    public StationRenderState method_74335() {
        return new StationRenderState();
    }

    @Override
    public void extractRenderState(
        StationBlockEntity be,
        StationRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        state.field_62673 = be.method_11016();
        state.field_62675 = be.method_11017();
        class_1937 world = be.method_10997();
        state.field_62676 = world != null ? class_761.method_23794(world, state.field_62673) : class_765.field_32767;
        DepotBehaviour depotBehaviour = be.depotBehaviour;
        state.incoming = DepotRenderer.createIncomingStateList(depotBehaviour, itemModelManager, tickProgress, world);
        state.outputs = DepotRenderer.createOutputStateList(depotBehaviour, itemModelManager, world);
        TrackTargetingBehaviour<GlobalStation> target = be.edgePoint;
        class_2338 targetPosition = target.getGlobalPosition();
        class_2680 trackState = world.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock track)) {
            return;
        }
        GlobalStation station = be.getStation();
        boolean isAssembling = be.method_11010().method_11654(StationBlock.ASSEMBLING);
        if (!isAssembling || (station == null || station.getPresentTrain() != null) && !be.isVirtual()) {
            updateFlagState(
                be.flag.getValue(tickProgress) > 0.75f ? AllPartialModels.STATION_ON : AllPartialModels.STATION_OFF,
                be,
                state,
                tickProgress
            );
            TrackBlockRenderer renderer = AllTrackRenders.get(track);
            if (renderer != null) {
                state.block = renderer.getRenderState(
                    world, new class_243(
                        targetPosition.method_10263() - state.field_62673.method_10263(),
                        targetPosition.method_10264() - state.field_62673.method_10264(),
                        targetPosition.method_10260() - state.field_62673.method_10260()
                    ), trackState, targetPosition, target.getTargetDirection(), target.getTargetBezier(), RenderedTrackOverlayType.STATION, 1
                );
            }
            return;
        }
        updateFlagState(AllPartialModels.STATION_ASSEMBLE, be, state, tickProgress);
        if (be.isVirtual() && be.bogeyLocations == null) {
            be.refreshAssemblyInfo();
        }
        TrackBlockRenderer renderer = AllTrackRenders.get(track);
        if (renderer == null) {
            return;
        }
        state.block = renderer.getAssemblyRenderState(
            be, new class_243(
                targetPosition.method_10263() - state.field_62673.method_10263(),
                targetPosition.method_10264() - state.field_62673.method_10264(),
                targetPosition.method_10260() - state.field_62673.method_10260()
            ), world, targetPosition, trackState
        );
    }

    public void updateFlagState(PartialModel flag, StationBlockEntity be, StationRenderState state, float tickProgress) {
        if (be.resolveFlagAngle()) {
            state.layer = class_12249.method_75972();
            state.flag = CachedBuffers.partial(flag, be.method_11010());
            float value = be.flag.getValue(tickProgress);
            float progress = (float) (Math.pow(Math.min(value * 5, 1), 2));
            if (be.flag.getChaseTarget() > 0 && !be.flag.settled() && progress == 1) {
                float wiggleProgress = (value - .2f) / .8f;
                progress += (float) ((Math.sin(wiggleProgress * (2 * class_3532.field_29844) * 4) / 8f) / Math.max(1, 8f * wiggleProgress));
            }
            float nudge = 1 / 512f;
            state.flagYRot = class_3532.field_29847 * be.flagYRot;
            boolean flipped = be.flagFlipped;
            state.flagOffsetZ = flipped ? 14f / 16f - nudge : 2f / 16f + nudge;
            state.flagXRot = class_3532.field_29847 * (flipped ? 1 : -1) * (progress * 90 + 270);
            state.flagYRot2 = flipped ? 0 : class_3532.field_29847 * 180;
        }
    }

    @Override
    public void submit(StationRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.incoming != null || state.outputs != null) {
            DepotRenderer.renderItemsOf(state.incoming, state.outputs, state.field_62673, cameraState.field_63078, queue, matrices, state.field_62676);
        }
        if (state.layer != null) {
            queue.method_73483(matrices, state.layer, state);
        }
        if (state.block != null) {
            state.block.render(matrices, queue);
        }
    }

    @Override
    public boolean method_3563() {
        return true;
    }

    @Override
    public int method_33893() {
        return 96 * 2;
    }

    public static class StationRenderState extends class_11954 implements class_11659.class_11660 {
        public DepotItemState[] incoming;
        public List<DepotOutputItemState> outputs;
        public class_1921 layer;
        public SuperByteBuffer flag;
        public float flagYRot;
        public float flagOffsetZ;
        public float flagXRot;
        public float flagYRot2;
        public TrackBlockRenderState block;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            if (flag != null) {
                flag.center().rotateY(flagYRot).translate(0.001953125f, 0.59375f, flagOffsetZ).uncenter();
                flag.rotateX(flagXRot).translate(0.03125f, 0, 0).rotateY(flagYRot2).translate(-0.03125f, 0, 0);
                flag.light(field_62676).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}
