package com.zurrtum.create.client.content.trains.track;

import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.Affine;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.trains.station.StationBlockEntity;
import com.zurrtum.create.content.trains.track.BezierConnection;
import com.zurrtum.create.content.trains.track.TrackBlock;
import com.zurrtum.create.content.trains.track.TrackBlockEntity;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour.RenderedTrackOverlayType;
import com.zurrtum.create.infrastructure.component.BezierTrackPointLocation;
import net.minecraft.class_12249;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import org.joml.Quaternionf;

public class StandardTrackBlockRenderer implements TrackBlockRenderer {
    @Override
    public <Self extends Affine<Self>> void prepareTrackOverlay(
        Affine<Self> affine,
        class_1922 world,
        class_2338 pos,
        class_2680 state,
        BezierTrackPointLocation bezierPoint,
        class_2352 direction,
        RenderedTrackOverlayType type
    ) {
        class_243 axis = null;
        class_243 diff = null;
        class_243 normal = null;
        if (bezierPoint != null && world.method_8321(pos) instanceof TrackBlockEntity trackBE) {
            BezierConnection bc = trackBE.getConnections().get(bezierPoint.curveTarget());
            if (bc != null) {
                double length = class_3532.method_15357(bc.getLength() * 2);
                int seg = bezierPoint.segment() + 1;
                double t = seg / length;
                double tpre = (seg - 1) / length;
                double tpost = (seg + 1) / length;

                class_243 offset = bc.getPosition(t);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).method_1020(bc.getPosition(tpre)).method_1029();

                affine.translate(offset.method_1020(class_243.method_24955(pos)));
                affine.translate(0, -4 / 16f, 0);
            } else
                return;
        }

        if (normal == null) {
            axis = state.method_11654(TrackBlock.SHAPE).getAxes().get(0);
            diff = axis.method_1021(direction.method_10181()).method_1029();
            normal = state.method_11654(TrackBlock.SHAPE).getNormal();
        }

        class_243 angles = TrackRenderer.getModelAngles(normal, diff);

        affine.center().rotateY((float) angles.field_1351).rotateX((float) angles.field_1352).uncenter();

        if (axis != null)
            affine.translate(0, axis.field_1351 != 0 ? 7 / 16f : 0, axis.field_1351 != 0 ? direction.method_10181() * 2.5f / 16f : 0);
        else {
            affine.translate(0, 4 / 16f, 0);
            if (direction == class_2352.field_11060)
                affine.rotateCentered(class_3532.field_29844, class_2350.field_11036);
        }

        if (bezierPoint == null && world.method_8321(pos) instanceof TrackBlockEntity trackTE && trackTE.isTilted()) {
            double yOffset = 0;
            for (BezierConnection bc : trackTE.getConnections().values())
                yOffset += bc.starts.getFirst().field_1351 - pos.method_10264();
            affine.center().rotateXDegrees((float) (-direction.method_10181() * trackTE.tilt.smoothingAngle.get())).uncenter()
                .translate(0, yOffset / 2, 0);
        }
    }

    @Override
    public TrackBlockRenderState getRenderState(
        class_1937 world,
        class_243 offset,
        class_2680 trackState,
        class_2338 pos,
        class_2352 direction,
        BezierTrackPointLocation bezier,
        RenderedTrackOverlayType type,
        float scale
    ) {
        if (world instanceof SchematicLevel && !(world instanceof PonderLevel)) {
            return null;
        }
        class_243 axis = null;
        class_243 diff = null;
        class_243 normal = null;
        if (bezier != null && world.method_8321(pos) instanceof TrackBlockEntity trackBE) {
            BezierConnection bc = trackBE.getConnections().get(bezier.curveTarget());
            if (bc != null) {
                double length = class_3532.method_15357(bc.getLength() * 2);
                int seg = bezier.segment() + 1;
                double t = seg / length;
                double tpre = (seg - 1) / length;
                double tpost = (seg + 1) / length;
                offset = bc.getPosition(t).method_1020(class_243.method_24955(pos)).method_1019(offset).method_1031(0, -4 / 16f, 0);
                normal = bc.getNormal(t);
                diff = bc.getPosition(tpost).method_1020(bc.getPosition(tpre)).method_1029();
            } else {
                return null;
            }
        }
        if (normal == null) {
            axis = trackState.method_11654(TrackBlock.SHAPE).getAxes().getFirst();
            diff = axis.method_1021(direction.method_10181()).method_1029();
            normal = trackState.method_11654(TrackBlock.SHAPE).getNormal();
        }
        StandardTrackBlockRenderState state = new StandardTrackBlockRenderState();
        state.offset = offset;
        class_243 angles = TrackRenderer.getModelAngles(normal, diff);
        state.yRot = (float) angles.field_1351;
        state.xRot = (float) angles.field_1352;
        if (axis != null) {
            state.offset2 = axis.field_1351 != 0 ? new class_243(0, 7 / 16f, direction.method_10181() * 2.5f / 16f) : class_243.field_1353;
        } else if (direction == class_2352.field_11060) {
            state.negative = true;
        }
        if (bezier == null && world.method_8321(pos) instanceof TrackBlockEntity trackTE && trackTE.isTilted()) {
            double yOffset = 0;
            for (BezierConnection bc : trackTE.getConnections().values()) {
                yOffset += bc.starts.getFirst().field_1351 - pos.method_10264();
            }
            state.xRot2 = class_3532.field_29847 * (float) (-direction.method_10181() * trackTE.tilt.smoothingAngle.get());
            state.offset3 = (float) (yOffset / 2);
        }
        state.layer = class_12249.method_75972();
        PartialModel partial = switch (type) {
            case DUAL_SIGNAL -> AllPartialModels.TRACK_SIGNAL_DUAL_OVERLAY;
            case OBSERVER -> AllPartialModels.TRACK_OBSERVER_OVERLAY;
            case SIGNAL -> AllPartialModels.TRACK_SIGNAL_OVERLAY;
            case STATION -> AllPartialModels.TRACK_STATION_OVERLAY;
        };
        state.model = CachedBuffers.partial(partial, trackState);
        state.scale = scale;
        state.light = class_761.method_23794(world, pos);
        return state;
    }

    @Override
    public TrackBlockRenderState getAssemblyRenderState(StationBlockEntity be, class_243 offset, class_1937 world, class_2338 pos, class_2680 blockState) {
        class_2350 direction = be.assemblyDirection;
        if (direction == null) {
            return null;
        }
        int length = be.assemblyLength;
        if (length == 0) {
            return null;
        }
        int[] locations = be.bogeyLocations;
        if (locations == null) {
            return null;
        }
        StandardTrackAssemblyRenderState state = new StandardTrackAssemblyRenderState();
        state.layer = class_12249.method_75972();
        state.offset = offset;
        state.angle = AngleHelper.rad(AngleHelper.horizontalAngle(direction));
        state.model = CachedBuffers.partial(AllPartialModels.TRACK_ASSEMBLING_OVERLAY, blockState);
        int colorWhenValid = 0x96B5FF;
        int colorWhenCarriage = 0xCAFF96;
        class_2338.class_2339 currentPos = pos.method_25503();
        int[][] data = state.data = new int[length][];
        int index = 0;
        for (int location : locations) {
            if (location == -1) {
                break;
            }
            int i = index;
            index = location;
            for (; i < index; i++) {
                if (be.isValidBogeyOffset(i)) {
                    data[i] = new int[]{colorWhenValid, class_761.method_23794(world, currentPos.method_10104(direction, 1))};
                }
            }
            data[i] = new int[]{colorWhenCarriage, class_761.method_23794(world, currentPos.method_10104(direction, 1))};
            index++;
        }
        for (; index < length; index++) {
            if (be.isValidBogeyOffset(index)) {
                data[index] = new int[]{colorWhenValid, class_761.method_23794(world, currentPos.method_10104(direction, 1))};
            }
        }
        return state;
    }

    public static class StandardTrackBlockRenderState extends TrackBlockRenderState {
        public class_243 offset;
        public float yRot;
        public float xRot;
        public class_243 offset2;
        public float xRot2;
        public Float offset3;
        public boolean negative;
        public SuperByteBuffer model;
        public int light;
        public float scale;

        @Override
        public void transform(class_4587 matrices) {
            matrices.method_61958(offset);
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(yRot));
            matrices.method_22907(class_7833.field_40714.rotation(xRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            if (offset2 != null) {
                if (offset2 != class_243.field_1353) {
                    matrices.method_61958(offset2);
                }
            } else {
                matrices.method_46416(0, 0.25f, 0);
                if (negative) {
                    matrices.method_49278(new Quaternionf().setAngleAxis(Math.PI, 0, 1, 0), 0.5f, 0.5f, 0.5f);
                }
            }
            if (offset3 != null) {
                matrices.method_46416(0.5f, 0.5f, 0.5f);
                matrices.method_22907(class_7833.field_40714.rotation(xRot2));
                matrices.method_46416(-0.5f, -0.5f, -0.5f);
                matrices.method_46416(0, offset3, 0);
            }
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.translate(.5f, 0, .5f).scale(scale).translate(-.5f, 0, -.5f).light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static class StandardTrackAssemblyRenderState extends TrackBlockRenderState {
        public class_243 offset;
        public float angle;
        public SuperByteBuffer model;
        public int[][] data;

        @Override
        public void transform(class_4587 matrices) {
            matrices.method_61958(offset);
            matrices.method_49278(new Quaternionf().setAngleAxis(angle, 0, 1, 0), 0.5f, 0.5f, 0.5f);
        }

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (int[] pair : data) {
                matricesEntry.method_67796(0, 0, 1);
                if (pair != null) {
                    model.color(pair[0]).light(pair[1]).renderInto(matricesEntry, vertexConsumer);
                }
            }
        }
    }
}
