package com.zurrtum.create.client.flywheel.api.visualization;

import com.zurrtum.create.client.flywheel.api.visual.EntityVisual;
import net.minecraft.class_1297;
import net.minecraft.class_897;

/**
 * A visualizer that will be keyed to an entity type.
 *
 * @param <T> The entity type.
 */
public interface EntityVisualizer<T extends class_1297> {
    /**
     * Given an entity and context, constructs a visual for the entity.
     *
     * @param ctx    Context for creating a visual.
     * @param entity The entity to construct a visual for.
     * @return The visual.
     */
    EntityVisual<? super T> createVisual(VisualizationContext ctx, T entity, float partialTick);

    /**
     * Checks if the given entity should not render with the vanilla {@link class_897}.
     *
     * @param entity The entity to check.
     * @return {@code true} if the entity should not render with the vanilla {@link class_897}, {@code false} if it should.
     */
    boolean skipVanillaRender(T entity);
}
