package com.zurrtum.create.client.flywheel.api.visualization;

import com.zurrtum.create.client.flywheel.api.backend.RenderContext;
import com.zurrtum.create.client.flywheel.api.internal.FlwApiLink;
import com.zurrtum.create.client.flywheel.api.visual.Effect;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.SortedSet;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3191;

@ApiStatus.NonExtendable
public interface VisualizationManager {
    static boolean supportsVisualization(@Nullable class_1936 level) {
        return FlwApiLink.INSTANCE.supportsVisualization(level);
    }

    static @Nullable VisualizationManager get(@Nullable class_1936 level) {
        return FlwApiLink.INSTANCE.getVisualizationManager(level);
    }

    static VisualizationManager getOrThrow(@Nullable class_1936 level) {
        return FlwApiLink.INSTANCE.getVisualizationManagerOrThrow(level);
    }

    class_2382 renderOrigin();

    VisualManager<class_2586> blockEntities();

    VisualManager<class_1297> entities();

    VisualManager<Effect> effects();

    /**
     * Get the render dispatcher, which can be used to invoke rendering.
     * <b>This should only be used by mods which heavily rewrite rendering to restore compatibility with Flywheel
     * without mixins.</b>
     */
    RenderDispatcher renderDispatcher();

    @ApiStatus.NonExtendable
    interface RenderDispatcher {
        /**
         * Prepare visuals for render.
         *
         * <p>Guaranteed to be called before {@link #afterEntities} and {@link #beforeCrumbling}.
         * <br>Guaranteed to be called after the render thread has processed all light updates.
         * <br>The caller is otherwise free to choose an invocation site, but it is recommended to call
         * this as early as possible to give the VisualizationManager time to process things off-thread.
         */
        void onStartLevelRender(RenderContext var1);

        /**
         * Render instances.
         *
         * <p>Guaranteed to be called after {@link #onStartLevelRender} and before {@link #beforeCrumbling}.
         * <br>The caller is otherwise free to choose an invocation site, but it is recommended to call
         * this between rendering entities and block entities.
         */
        void afterEntities(RenderContext var1);

        /**
         * Render crumbling block entities.
         *
         * <p>Guaranteed to be called after {@link #onStartLevelRender} and {@link #afterEntities}
         *
         * @param destructionProgress The destruction progress map from {@link net.minecraft.class_761 LevelRenderer}.
         */
        void beforeCrumbling(RenderContext ctx, Long2ObjectMap<SortedSet<class_3191>> destructionProgress);
    }
}
