package com.zurrtum.create.client.flywheel.backend.compile;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.backend.gl.shader.GlProgram;
import com.zurrtum.create.client.flywheel.backend.glsl.SourceComponent;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2960;

public record Pipeline(
    class_2960 vertexMain, class_2960 fragmentMain, InstanceAssembler assembler, String compilerMarker, Consumer<GlProgram> onLink
) {

    @FunctionalInterface
    public interface InstanceAssembler {
        /**
         * Generate the source component necessary to convert a packed {@link Instance} into its shader representation.
         *
         * @return A source component defining functions that unpack a representation of the given instance type.
         */
        SourceComponent assemble(InstanceType<?> instanceType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        @Nullable
        private class_2960 vertexMain;
        @Nullable
        private class_2960 fragmentMain;
        @Nullable
        private InstanceAssembler assembler;
        @Nullable
        private String compilerMarker;
        @Nullable
        private Consumer<GlProgram> onLink;

        public Builder vertexMain(class_2960 shader) {
            this.vertexMain = shader;
            return this;
        }

        public Builder fragmentMain(class_2960 shader) {
            this.fragmentMain = shader;
            return this;
        }

        public Builder assembler(InstanceAssembler assembler) {
            this.assembler = assembler;
            return this;
        }

        public Builder compilerMarker(String compilerMarker) {
            this.compilerMarker = compilerMarker;
            return this;
        }

        public Builder onLink(Consumer<GlProgram> onLink) {
            this.onLink = onLink;
            return this;
        }

        public Pipeline build() {
            Objects.requireNonNull(vertexMain);
            Objects.requireNonNull(fragmentMain);
            Objects.requireNonNull(assembler);
            Objects.requireNonNull(compilerMarker);
            Objects.requireNonNull(onLink);
            return new Pipeline(vertexMain, fragmentMain, assembler, compilerMarker, onLink);
        }
    }
}
