package com.zurrtum.create.client.flywheel.backend.engine;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.zurrtum.create.client.flywheel.backend.Samplers;
import com.zurrtum.create.client.flywheel.backend.gl.GlTextureUnit;
import net.minecraft.class_1044;
import net.minecraft.class_10868;
import net.minecraft.class_12134;
import net.minecraft.class_12137;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_757;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL33C;

import static com.mojang.blaze3d.opengl.GlConst.GL_TEXTURE_2D;

public class TextureBinder {
    public static void bind(class_2960 Identifier) {
        GlStateManager._bindTexture(byName(Identifier));
    }

    public static void bindCrumbling(class_2960 Identifier) {
        class_1044 texture = class_310.method_1551().method_1531().method_4619(Identifier);
        setupTexture(Samplers.CRUMBLING, texture.method_71659(), texture.method_75484());
    }

    public static void bindLightAndOverlay() {
        class_757 gameRenderer = class_310.method_1551().field_1773;
        class_12137 sampler = RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR);
        setupTexture(Samplers.OVERLAY, gameRenderer.method_22975().method_76037(), sampler);
        setupTexture(Samplers.LIGHT, gameRenderer.method_22974().method_71650(), sampler);
    }

    private static void setupTexture(GlTextureUnit unit, GpuTextureView textureView, class_12137 sampler) {
        unit.makeActive();
        class_10868 texture = (class_10868) textureView.texture();
        int target;
        if ((texture.usage() & 16) != 0) {
            target = GL13.GL_TEXTURE_CUBE_MAP;
            GL11.glBindTexture(target, texture.method_68427());
        } else {
            target = GL_TEXTURE_2D;
            GlStateManager._bindTexture(texture.method_68427());
        }
        GL33C.glBindSampler(unit.number, ((class_12134) sampler).method_75285());
        int mipLevel = textureView.baseMipLevel();
        GlStateManager._texParameter(target, GL12.GL_TEXTURE_BASE_LEVEL, mipLevel);
        GlStateManager._texParameter(target, GL12.GL_TEXTURE_MAX_LEVEL, mipLevel + textureView.mipLevels() - 1);
    }

    public static void resetLightAndOverlay() {
    }

    /**
     * Get a built-in texture by its resource location.
     *
     * @param texture The texture's resource location.
     * @return The texture.
     */
    public static int byName(class_2960 texture) {
        return ((class_10868) class_310.method_1551().method_1531().method_4619(texture).method_68004()).method_68427();
    }
}
