package com.zurrtum.create.client.flywheel.backend.engine.uniform;

import com.zurrtum.create.client.flywheel.lib.util.ExtraMemoryOps;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

class UniformWriter {
    static long writeInt(long ptr, int value) {
        MemoryUtil.memPutInt(ptr, value);
        return ptr + 4;
    }

    static long writeFloat(long ptr, float value) {
        MemoryUtil.memPutFloat(ptr, value);
        return ptr + 4;
    }

    static long writeVec2(long ptr, float x, float y) {
        MemoryUtil.memPutFloat(ptr, x);
        MemoryUtil.memPutFloat(ptr + 4, y);
        return ptr + 8;
    }

    static long writeVec3(long ptr, float x, float y, float z) {
        MemoryUtil.memPutFloat(ptr, x);
        MemoryUtil.memPutFloat(ptr + 4, y);
        MemoryUtil.memPutFloat(ptr + 8, z);
        MemoryUtil.memPutFloat(ptr + 12, 0f); // empty component of vec4 because we don't trust std140
        return ptr + 16;
    }

    static long writeVec3(long ptr, Vector3fc vec) {
        return writeVec3(ptr, vec.x(), vec.y(), vec.z());
    }

    static long writeVec4(long ptr, float x, float y, float z, float w) {
        MemoryUtil.memPutFloat(ptr, x);
        MemoryUtil.memPutFloat(ptr + 4, y);
        MemoryUtil.memPutFloat(ptr + 8, z);
        MemoryUtil.memPutFloat(ptr + 12, w);
        return ptr + 16;
    }

    static long writeIVec2(long ptr, int x, int y) {
        MemoryUtil.memPutInt(ptr, x);
        MemoryUtil.memPutInt(ptr + 4, y);
        return ptr + 8;
    }

    static long writeIVec3(long ptr, int x, int y, int z) {
        MemoryUtil.memPutInt(ptr, x);
        MemoryUtil.memPutInt(ptr + 4, y);
        MemoryUtil.memPutInt(ptr + 8, z);
        MemoryUtil.memPutInt(ptr + 12, 0); // empty component of vec4 because we don't trust std140
        return ptr + 16;
    }

    static long writeIVec4(long ptr, int x, int y, int z, int w) {
        MemoryUtil.memPutInt(ptr, x);
        MemoryUtil.memPutInt(ptr + 4, y);
        MemoryUtil.memPutInt(ptr + 8, z);
        MemoryUtil.memPutInt(ptr + 12, w);
        return ptr + 16;
    }

    static long writeMat4(long ptr, Matrix4f mat) {
        ExtraMemoryOps.putMatrix4f(ptr, mat);
        return ptr + 64;
    }

    static long writeInFluidAndBlock(long ptr, class_1937 level, class_2338 blockPos, class_243 pos) {
        class_3610 fluidState = level.method_8316(blockPos);
        class_2680 blockState = level.method_8320(blockPos);
        float height = fluidState.method_15763(level, blockPos);

        if (fluidState.method_15769()) {
            MemoryUtil.memPutInt(ptr, 0);
        } else if (pos.field_1351 < blockPos.method_10264() + height) {
            // TODO: handle custom fluids via defines
            if (fluidState.method_15767(class_3486.field_15517)) {
                MemoryUtil.memPutInt(ptr, 1);
            } else if (fluidState.method_15767(class_3486.field_15518)) {
                MemoryUtil.memPutInt(ptr, 2);
            } else {
                MemoryUtil.memPutInt(ptr, -1);
            }
        }

        if (blockState.method_26215()) {
            MemoryUtil.memPutInt(ptr + 4, 0);
        } else {
            // TODO: handle custom blocks via defines
            if (blockState.method_27852(class_2246.field_27879)) {
                MemoryUtil.memPutInt(ptr + 4, 0);
            } else {
                MemoryUtil.memPutInt(ptr + 4, -1);
            }
        }

        return ptr + 8;
    }
}
