package com.zurrtum.create.client.flywheel.impl;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.zurrtum.create.client.flywheel.api.backend.Backend;
import com.zurrtum.create.client.flywheel.lib.util.ResourceUtil;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2172;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class BackendArgument implements ArgumentType<Backend> {
    private static final List<String> EXAMPLES = List.of("off", "flywheel:off", "instancing");

    private static final DynamicCommandExceptionType ERROR_UNKNOWN_BACKEND = new DynamicCommandExceptionType(arg -> {
        return class_2561.method_43469("argument.flywheel_backend.id.unknown", arg);
    });

    public static final BackendArgument INSTANCE = new BackendArgument();
    public static final class_2319<BackendArgument> INFO = class_2319.method_41999(() -> INSTANCE);

    @Override
    public Backend parse(StringReader reader) throws CommandSyntaxException {
        class_2960 id = ResourceUtil.readFlywheelDefault(reader);
        Backend backend = Backend.REGISTRY.get(id);

        if (backend == null) {
            throw ERROR_UNKNOWN_BACKEND.createWithContext(reader, id.toString());
        }

        return backend;
    }

    @Override
    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        String input = builder.getRemaining().toLowerCase(Locale.ROOT);
        for (class_2960 id : Backend.REGISTRY.getAllIds()) {
            String idStr = id.toString();
            if (class_2172.method_27136(input, idStr) || class_2172.method_27136(input, id.method_12832())) {
                builder.suggest(idStr);
            }
        }
        return builder.buildFuture();
    }

    @Override
    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}
