package com.zurrtum.create.client.flywheel.lib.instance;

import com.zurrtum.create.client.flywheel.api.instance.InstanceHandle;
import com.zurrtum.create.client.flywheel.api.instance.InstanceType;
import com.zurrtum.create.client.flywheel.lib.transform.Rotate;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;

public class OrientedInstance extends ColoredLitOverlayInstance implements Rotate<OrientedInstance> {
    public float posX;
    public float posY;
    public float posZ;
    public float pivotX = 0.5f;
    public float pivotY = 0.5f;
    public float pivotZ = 0.5f;
    public final Quaternionf rotation = new Quaternionf();

    public OrientedInstance(InstanceType<? extends OrientedInstance> type, InstanceHandle handle) {
        super(type, handle);
    }

    public OrientedInstance position(float x, float y, float z) {
        posX = x;
        posY = y;
        posZ = z;
        return this;
    }

    public OrientedInstance position(Vector3fc pos) {
        return position(pos.x(), pos.y(), pos.z());
    }

    public OrientedInstance position(class_2382 pos) {
        return position(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public OrientedInstance position(class_243 pos) {
        return position((float) pos.method_10216(), (float) pos.method_10214(), (float) pos.method_10215());
    }

    public OrientedInstance zeroPosition() {
        return position(0, 0, 0);
    }

    public OrientedInstance translatePosition(float x, float y, float z) {
        posX += x;
        posY += y;
        posZ += z;
        return this;
    }

    public OrientedInstance pivot(float x, float y, float z) {
        pivotX = x;
        pivotY = y;
        pivotZ = z;
        return this;
    }

    public OrientedInstance pivot(Vector3fc pos) {
        return pivot(pos.x(), pos.y(), pos.z());
    }

    public OrientedInstance pivot(class_2382 pos) {
        return pivot(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public OrientedInstance pivot(class_243 pos) {
        return pivot((float) pos.method_10216(), (float) pos.method_10214(), (float) pos.method_10215());
    }

    public OrientedInstance centerPivot() {
        return pivot(0.5f, 0.5f, 0.5f);
    }

    public OrientedInstance translatePivot(float x, float y, float z) {
        pivotX += x;
        pivotY += y;
        pivotZ += z;
        return this;
    }

    public OrientedInstance rotation(Quaternionfc q) {
        rotation.set(q);
        return this;
    }

    public OrientedInstance rotation(float x, float y, float z, float w) {
        rotation.set(x, y, z, w);
        return this;
    }

    public OrientedInstance identityRotation() {
        rotation.identity();
        return this;
    }

    @Override
    public OrientedInstance rotate(Quaternionfc quaternion) {
        rotation.mul(quaternion);
        return this;
    }
}
