package com.zurrtum.create.client.flywheel.lib.model.baked;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.material.Transparency;
import com.zurrtum.create.client.flywheel.api.model.Mesh;
import com.zurrtum.create.client.flywheel.lib.material.CutoutShaders;
import com.zurrtum.create.client.flywheel.lib.material.Materials;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import java.util.*;
import net.minecraft.class_10444;
import net.minecraft.class_11661;
import net.minecraft.class_11788;
import net.minecraft.class_12247;
import net.minecraft.class_12249;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_9801;

public class BakedItemModelBufferer {
    static final Map<BlendFunction, Transparency> TRANSPARENCY = Map.of(
        BlendFunction.ADDITIVE,
        Transparency.ADDITIVE,
        BlendFunction.LIGHTNING,
        Transparency.LIGHTNING,
        BlendFunction.GLINT,
        Transparency.GLINT,
        BlendFunction.TRANSLUCENT,
        Transparency.TRANSLUCENT
    );
    static final List<class_1921> CHUNK_LAYERS = List.of(
        class_4722.method_24073(),
        class_4722.method_24074(),
        class_4722.method_29382(),
        class_12249.method_75995(),
        class_12249.method_75993(),
        class_12249.method_75997()
    );

    public static void bufferItemStack(
        class_1799 stack,
        class_1920 level,
        class_811 displayContext,
        ResultConsumer resultConsumer,
        MeshResultConsumer meshResultConsumer
    ) {
        ThreadLocalObjects objects = THREAD_LOCAL_OBJECTS.get();
        class_4587 poseStack = objects.identityPoseStack;
        class_638 world = level instanceof class_638 clientWorld ? clientWorld : null;
        ItemMeshEmitterProvider provider = objects.provider;
        provider.setResultConsumer(resultConsumer, meshResultConsumer);
        class_10444 state = objects.state;
        class_11661 queue = objects.queue;
        class_310.method_1551().method_65386().method_65598(state, stack, displayContext, world, null, 0);
        state.method_65604(poseStack, queue, 0, class_4608.field_21444, 0);
        for (class_11788 commandQueue : queue.method_73532().values()) {
            ModelCommandRendererHelper.render(poseStack, commandQueue, provider, provider, provider);
            ModelPartCommandRendererHelper.render(poseStack, commandQueue, provider, provider, provider);
            ItemCommandRendererHelper.render(poseStack, commandQueue, provider, provider);
            CustomCommandRendererHelper.render(commandQueue, provider);
        }
        queue.method_72953();
        provider.end();
    }

    public static class ItemMeshEmitterProvider implements class_4597 {
        private final ThreadLocalObjects objects;
        private ResultConsumer resultConsumer;
        private MeshResultConsumer meshResultConsumer;

        private ItemMeshEmitterProvider(ThreadLocalObjects objects) {
            this.objects = objects;
        }

        public void setResultConsumer(ResultConsumer resultConsumer, MeshResultConsumer meshResultConsumer) {
            this.resultConsumer = resultConsumer;
            this.meshResultConsumer = meshResultConsumer;
        }

        private void emitMesh(class_1921 renderType, Mesh mesh) {
            Material material = objects.materials.computeIfAbsent(renderType, ItemMeshEmitterProvider::createMaterial);
            meshResultConsumer.accept(renderType, material, mesh);
        }

        private static Material createMaterial(class_1921 renderLayer) {
            class_12247 state = renderLayer.field_64013;
            Map<String, class_12247.class_12338> textures = state.field_63987;
            class_12247.class_12338 texture = textures.get("Sampler0");
            if (texture != null) {
                SimpleMaterial.Builder builder = SimpleMaterial.builder().texture(texture.comp_5228()).mipmap(false);
                if (!state.field_63991) {
                    builder.useLight(false);
                }
                if (!state.field_63992) {
                    builder.useOverlay(false);
                }
                RenderPipeline pipeline = renderLayer.method_73243();
                Optional<BlendFunction> blendFunction = pipeline.getBlendFunction();
                if (blendFunction.isPresent()) {
                    Transparency transparency = TRANSPARENCY.get(blendFunction.get());
                    if (transparency != null) {
                        builder.transparency(transparency);
                    }
                }
                String cutout = pipeline.getShaderDefines().comp_3103().get("ALPHA_CUTOUT");
                if (cutout != null) {
                    if (cutout.equals("0.1")) {
                        builder.cutout(CutoutShaders.ONE_TENTH);
                    } else if (cutout.equals("0.5")) {
                        builder.cutout(CutoutShaders.HALF);
                    }
                }
                return builder.build();
            }
            return Materials.TRANSLUCENT_ENTITY;
        }

        @Override
        public class_4588 method_73477(class_1921 layer) {
            Integer index = objects.chunkLayers.get(layer);
            ItemMeshEmitter emitter;
            if (index == null) {
                objects.chunkLayers.put(layer, objects.chunkLayers.size());
                emitter = new ItemMeshEmitter(layer);
                emitter.prepare(resultConsumer, this::emitMesh);
                objects.emitters.add(emitter);
            } else {
                emitter = objects.emitters.get(index);
                if (emitter.isEnd()) {
                    emitter.prepare(resultConsumer, this::emitMesh);
                }
            }
            return emitter;
        }

        public void end() {
            for (ItemMeshEmitter emitter : objects.emitters) {
                emitter.end();
            }
        }
    }

    public interface ResultConsumer {
        void accept(class_1921 renderType, boolean shaded, class_9801 data);
    }

    public interface MeshResultConsumer {
        void accept(class_1921 renderType, Material material, Mesh mesh);
    }

    private static final ThreadLocal<ThreadLocalObjects> THREAD_LOCAL_OBJECTS = ThreadLocal.withInitial(ThreadLocalObjects::new);

    public static Map<class_1921, Integer> getChunkLayers() {
        return THREAD_LOCAL_OBJECTS.get().chunkLayers;
    }

    private static class ThreadLocalObjects {
        public final class_4587 identityPoseStack = new class_4587();
        public final class_11661 queue = new class_11661();
        public final class_10444 state = new class_10444();
        public final ItemMeshEmitterProvider provider = new ItemMeshEmitterProvider(this);
        public final Map<class_1921, Material> materials = new HashMap<>();
        public final Map<class_1921, Integer> chunkLayers = new HashMap<>();
        public final List<ItemMeshEmitter> emitters = new ArrayList<>();

        {
            for (int i = 0, size = CHUNK_LAYERS.size(); i < size; i++) {
                class_1921 renderType = CHUNK_LAYERS.get(i);
                chunkLayers.put(renderType, i);
                emitters.add(new ItemMeshEmitter(renderType));
            }
        }
    }
}
