package com.zurrtum.create.client.flywheel.lib.visualization;

import com.zurrtum.create.client.flywheel.api.visual.Effect;
import com.zurrtum.create.client.flywheel.api.visual.Visual;
import com.zurrtum.create.client.flywheel.api.visualization.BlockEntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.EntityVisualizer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizerRegistry;
import org.jetbrains.annotations.Nullable;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_638;

public final class VisualizationHelper {
    private VisualizationHelper() {
    }

    public static void queueAdd(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }

        manager.effects().queueAdd(effect);
    }

    public static void queueRemove(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }

        manager.effects().queueRemove(effect);
    }

    /**
     * Call this when you want to run {@link Visual#update}.
     *
     * @param blockEntity The block entity whose visual you want to update.
     */
    public static void queueUpdate(class_2586 blockEntity) {
        class_1937 level = blockEntity.method_10997();
        VisualizationManager manager = VisualizationManager.get(level);
        if (manager == null) {
            return;
        }

        manager.blockEntities().queueUpdate(blockEntity);
    }

    /**
     * Call this when you want to run {@link Visual#update}.
     *
     * @param entity The entity whose visual you want to update.
     */
    public static void queueUpdate(class_1297 entity) {
        class_1937 level = entity.method_73183();
        VisualizationManager manager = VisualizationManager.get(level);
        if (manager == null) {
            return;
        }

        manager.entities().queueUpdate(entity);
    }

    /**
     * Call this when you want to run {@link Visual#update}.
     *
     * @param effect The effect whose visual you want to update.
     */
    public static void queueUpdate(Effect effect) {
        VisualizationManager manager = VisualizationManager.get(effect.level());
        if (manager == null) {
            return;
        }

        manager.effects().queueUpdate(effect);
    }

    @SuppressWarnings("unchecked")
    @Nullable
    public static <T extends class_2586> BlockEntityVisualizer<? super T> getVisualizer(T blockEntity) {
        return VisualizerRegistry.getVisualizer((class_2591<? super T>) blockEntity.method_11017());
    }

    @SuppressWarnings("unchecked")
    @Nullable
    public static <T extends class_1297> EntityVisualizer<? super T> getVisualizer(T entity) {
        return VisualizerRegistry.getVisualizer((class_1299<? super T>) entity.method_5864());
    }

    /**
     * Checks if the given block entity can be visualized.
     *
     * @param blockEntity The block entity to check.
     * @param <T>         The type of the block entity.
     * @return {@code true} if the block entity can be visualized.
     */
    public static <T extends class_2586> boolean canVisualize(T blockEntity) {
        return getVisualizer(blockEntity) != null;
    }

    /**
     * Checks if the given entity can be visualized.
     *
     * @param entity The entity to check.
     * @param <T>    The type of the entity.
     * @return {@code true} if the entity can be visualized.
     */
    public static <T extends class_1297> boolean canVisualize(T entity) {
        return getVisualizer(entity) != null;
    }

    /**
     * Checks if the given block entity is visualized and should not be rendered normally.
     *
     * @param blockEntity The block entity to check.
     * @param <T>         The type of the block entity.
     * @return {@code true} if the block entity is visualized and should not be rendered normally.
     */
    public static <T extends class_2586> boolean skipVanillaRender(T blockEntity) {
        BlockEntityVisualizer<? super T> visualizer = getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(blockEntity);
    }

    /**
     * Checks if the given entity is visualized and should not be rendered normally.
     *
     * @param entity The entity to check.
     * @param <T>    The type of the entity.
     * @return {@code true} if the entity is visualized and should not be rendered normally.
     */
    public static <T extends class_1297> boolean skipVanillaRender(T entity) {
        EntityVisualizer<? super T> visualizer = getVisualizer(entity);
        if (visualizer == null) {
            return false;
        }
        return visualizer.skipVanillaRender(entity);
    }

    public static Iterator<class_1297> skipVanillaRender(class_638 world, Iterator<class_1297> iterator) {
        if (VisualizationManager.supportsVisualization(world)) {
            return new EntitySkipIterator(iterator);
        }
        return iterator;
    }

    public static <T extends class_2586> boolean tryAddBlockEntity(T blockEntity) {
        class_1937 level = blockEntity.method_10997();
        VisualizationManager manager = VisualizationManager.get(level);
        if (manager == null) {
            return false;
        }

        BlockEntityVisualizer<? super T> visualizer = getVisualizer(blockEntity);
        if (visualizer == null) {
            return false;
        }

        manager.blockEntities().queueAdd(blockEntity);
        return visualizer.skipVanillaRender(blockEntity);
    }

    public static class EntitySkipIterator implements Iterator<class_1297> {
        private final Iterator<class_1297> iterator;
        private class_1297 next;

        public EntitySkipIterator(Iterator<class_1297> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            if (next != null) {
                return true;
            }
            while (iterator.hasNext()) {
                class_1297 entity = iterator.next();
                if (skipVanillaRender(entity)) {
                    continue;
                }
                next = entity;
                return true;
            }
            return false;
        }

        @Override
        public class_1297 next() {
            if (hasNext()) {
                class_1297 entity = next;
                next = null;
                return entity;
            }
            throw new NoSuchElementException();
        }
    }
}
