package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.tunnel.BrassTunnelBlockEntity;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class BrassTunnelTooltipBehaviour extends TooltipBehaviour<BrassTunnelBlockEntity> implements IHaveGoggleInformation {
    public BrassTunnelTooltipBehaviour(BrassTunnelBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        List<class_1799> allStacks = blockEntity.grabAllStacksOfGroup(true);
        if (allStacks.isEmpty())
            return false;

        CreateLang.translate("tooltip.brass_tunnel.contains").style(class_124.field_1068).forGoggles(tooltip);
        for (class_1799 item : allStacks) {
            CreateLang.translate("tooltip.brass_tunnel.contains_entry", item.method_7964().getString(), item.method_7947()).style(class_124.field_1080)
                .forGoggles(tooltip);
        }
        CreateLang.translate("tooltip.brass_tunnel.retrieve").style(class_124.field_1063).forGoggles(tooltip);

        return true;
    }
}
