package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.api.goggles.IHaveGoggleInformation;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.chute.ChuteBlockEntity;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class ChuteTooltipBehaviour extends TooltipBehaviour<ChuteBlockEntity> implements IHaveGoggleInformation {
    public ChuteTooltipBehaviour(ChuteBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        boolean downward = blockEntity.getItemMotion() < 0;
        CreateLang.translate("tooltip.chute.header").forGoggles(tooltip);

        float pull = blockEntity.pull;
        float push = blockEntity.push;
        if (pull == 0 && push == 0)
            CreateLang.translate("tooltip.chute.no_fans_attached").style(class_124.field_1080).forGoggles(tooltip);
        if (pull != 0)
            CreateLang.translate("tooltip.chute.fans_" + (pull > 0 ? "pull_up" : "push_down")).style(class_124.field_1080).forGoggles(tooltip);
        if (push != 0)
            CreateLang.translate("tooltip.chute.fans_" + (push > 0 ? "push_up" : "pull_down")).style(class_124.field_1080).forGoggles(tooltip);

        CreateLang.text("-> ").add(CreateLang.translate("tooltip.chute.items_move_" + (downward ? "down" : "up"))).style(class_124.field_1054)
            .forGoggles(tooltip);
        class_1799 item = blockEntity.getItem();
        if (!item.method_7960())
            CreateLang.translate("tooltip.chute.contains", item.method_7964().getString(), item.method_7947()).style(class_124.field_1060)
                .forGoggles(tooltip);

        return true;
    }
}
