package com.zurrtum.create.client.foundation.blockEntity.renderer;

import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.content.redstone.link.LinkRenderer;
import com.zurrtum.create.client.content.redstone.link.LinkRenderer.LinkRenderState;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer.FilterRenderState;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_239.class_240;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class SmartBlockEntityRenderer<T extends SmartBlockEntity, S extends SmartBlockEntityRenderer.SmartRenderState> implements class_827<T, S> {
    protected final class_10442 itemModelManager;

    public SmartBlockEntityRenderer(class_5614.class_5615 context) {
        itemModelManager = context.comp_4536();
    }

    @Override
    @SuppressWarnings("unchecked")
    public S method_74335() {
        return (S) new SmartRenderState();
    }

    @Override
    public void extractRenderState(
        T be,
        S state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        if (be.method_11015()) {
            return;
        }
        double distance = be.isVirtual() ? -1 : cameraPos.method_1025(VecHelper.getCenterOf(state.field_62673));
        state.filter = FilteringRenderer.getFilterRenderState(be, state.field_62674, itemModelManager, distance);
        state.link = LinkRenderer.getLinkRenderState(be, itemModelManager, distance);
    }

    @Override
    public void submit(S state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (state.filter != null) {
            state.filter.render(state.field_62674, queue, matrices, state.field_62676);
        }
        if (state.link != null) {
            state.link.render(state.field_62674, queue, matrices, state.field_62676);
        }
    }

    public static NameplateRenderState getNameplateRenderState(
        SmartBlockEntity blockEntity,
        class_2338 pos,
        class_243 cameraPos,
        class_2561 tag,
        float yOffset,
        int light
    ) {
        if (blockEntity.isVirtual()) {
            return null;
        }
        double distance = cameraPos.method_1025(class_243.method_24953(pos));
        if (distance > 4096.0f) {
            return null;
        }
        class_239 hitResult = class_310.method_1551().field_1765;
        if (!(hitResult instanceof class_3965 bhr) || bhr.method_17783() == class_240.field_1333 || !bhr.method_17777().equals(pos)) {
            return null;
        }
        class_243 labelPos = new class_243(0.5, yOffset - 0.25, 0.5);
        return new NameplateRenderState(labelPos, tag, light, distance);
    }

    public static class SmartRenderState extends class_11954 {
        public FilterRenderState filter;
        public LinkRenderState link;
    }

    public record NameplateRenderState(class_243 pos, class_2561 label, int light, double distance) {
        public void render(class_4587 matrices, class_11659 queue, class_12075 cameraState) {
            queue.method_73482(matrices, pos, 0, label, true, light, distance, cameraState);
        }
    }
}
