package com.zurrtum.create.client.foundation.item;

import com.google.common.base.Strings;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;

import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;

public class TooltipHelper {

    public static final int MAX_WIDTH_PER_LINE = 200;

    public static class_5250 holdShift(FontHelper.Palette palette, boolean highlighted) {
        return CreateLang.translateDirect("tooltip.holdForDescription", CreateLang.translateDirect("tooltip.keyShift").method_27692(class_124.field_1080))
            .method_27692(class_124.field_1063);
    }

    public static String makeProgressBar(int length, int filledLength) {
        String bar = " ";
        int emptySpaces = length - filledLength;
        for (int i = 0; i < filledLength; i++)
            bar += "\u2588";
        for (int i = 0; i < emptySpaces; i++)
            bar += "\u2592";
        return bar + " ";
    }

    public static class_2583 styleFromColor(class_124 color) {
        return class_2583.field_24360.method_27706(color);
    }

    public static class_2583 styleFromColor(int hex) {
        return class_2583.field_24360.method_36139(hex);
    }

    public static void addHint(List<class_2561> tooltip, String hintKey, Object... messageParams) {
        CreateLang.translate(hintKey + ".title").style(class_124.field_1065).forGoggles(tooltip);
        class_2561 hint = CreateLang.translateDirect(hintKey);
        List<class_2561> cutComponent = cutTextComponent(hint, FontHelper.Palette.GRAY_AND_WHITE);
        for (class_2561 component : cutComponent)
            CreateLang.builder().add(component).forGoggles(tooltip);
    }

    public static List<class_2561> cutStringTextComponent(String s, FontHelper.Palette palette) {
        return cutTextComponent(class_2561.method_43470(s), palette);
    }

    public static List<class_2561> cutTextComponent(class_2561 c, FontHelper.Palette palette) {
        return cutTextComponent(c, palette.primary(), palette.highlight());
    }

    public static List<class_2561> cutStringTextComponent(String s, class_2583 primaryStyle, class_2583 highlightStyle) {
        return cutTextComponent(class_2561.method_43470(s), primaryStyle, highlightStyle);
    }

    public static List<class_2561> cutTextComponent(class_2561 c, class_2583 primaryStyle, class_2583 highlightStyle) {
        return cutTextComponent(c, primaryStyle, highlightStyle, 0);
    }

    public static List<class_2561> cutStringTextComponent(String c, class_2583 primaryStyle, class_2583 highlightStyle, int indent) {
        return cutTextComponent(class_2561.method_43470(c), primaryStyle, highlightStyle, indent);
    }

    public static List<class_2561> cutTextComponent(class_2561 c, class_2583 primaryStyle, class_2583 highlightStyle, int indent) {
        String s = c.getString();

        // Split words
        List<String> words = new LinkedList<>();
        String selected = class_310.method_1551().method_1526().method_4669();
        String[] langSplit = selected.split("_", 2);
        Locale javaLocale = langSplit.length == 1 ? Locale.of(langSplit[0]) : Locale.of(langSplit[0], langSplit[1]);
        BreakIterator iterator = BreakIterator.getLineInstance(javaLocale);
        iterator.setText(s);
        int start = iterator.first();
        for (int end = iterator.next(); end != BreakIterator.DONE; start = end, end = iterator.next()) {
            String word = s.substring(start, end);
            words.add(word);
        }

        // Apply hard wrap
        class_327 font = class_310.method_1551().field_1772;
        List<String> lines = new LinkedList<>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.method_1727(word.replaceAll("_", ""));
            if (width + newWidth > MAX_WIDTH_PER_LINE) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }

        // Format
        class_5250 lineStart = class_2561.method_43470(Strings.repeat(" ", indent));
        lineStart.method_27696(primaryStyle);
        List<class_2561> formattedLines = new ArrayList<>(lines.size());
        Couple<class_2583> styles = Couple.create(highlightStyle, primaryStyle);

        boolean currentlyHighlighted = false;
        for (String string : lines) {
            class_5250 currentComponent = lineStart.method_27662();
            String[] split = string.split("_", -1);
            for (String part : split) {
                currentComponent.method_10852(class_2561.method_43470(part).method_27696(styles.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }

            formattedLines.add(currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }

        return formattedLines;
    }
}