package com.zurrtum.create.client.foundation.model;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.model.NormalsBakedQuad;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_1058;
import net.minecraft.class_10801;
import net.minecraft.class_10817;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5611;
import net.minecraft.class_777;

import static com.zurrtum.create.client.catnip.render.SpriteShiftEntry.getUnInterpolatedU;
import static com.zurrtum.create.client.catnip.render.SpriteShiftEntry.getUnInterpolatedV;

public class BakedModelHelper {
    private static long calcSpriteUv(class_243 diff, long packedUV, class_243 uAxis, class_243 vAxis, float uScale, float vScale, class_1058 sprite) {
        if (diff.method_1027() == 0) {
            return packedUV;
        }
        float u = class_5611.method_76641(packedUV);
        float v = class_5611.method_76642(packedUV);
        u = sprite.method_4580(getUnInterpolatedU(sprite, u) + ((float) uAxis.method_1026(diff) * uScale));
        v = sprite.method_4570(getUnInterpolatedV(sprite, v) + ((float) vAxis.method_1026(diff) * vScale));
        return class_5611.method_76640(u, v);
    }

    public static class_777 cropAndMove(class_777 quad, class_238 crop, class_243 move) {
        class_1058 sprite = quad.comp_3724();

        class_243 xyz0 = new class_243(quad.comp_5238());
        class_243 xyz1 = new class_243(quad.comp_5239());
        class_243 xyz2 = new class_243(quad.comp_5240());
        class_243 xyz3 = new class_243(quad.comp_5241());
        long packedUV0 = quad.comp_5242();
        long packedUV1 = quad.comp_5243();
        long packedUV2 = quad.comp_5244();
        long packedUV3 = quad.comp_5245();

        class_243 uAxis = xyz3.method_1019(xyz2).method_1021(.5);
        class_243 vAxis = xyz1.method_1019(xyz2).method_1021(.5);
        class_243 center = xyz3.method_1019(xyz2).method_1019(xyz0).method_1019(xyz1).method_1021(.25);

        float u0 = class_5611.method_76641(packedUV0);
        float u3 = class_5611.method_76641(packedUV3);
        float v0 = class_5611.method_76642(packedUV0);
        float v1 = class_5611.method_76642(packedUV1);

        float uScale = (float) Math.round((getUnInterpolatedU(sprite, u3) - getUnInterpolatedU(sprite, u0)) / xyz3.method_1022(xyz0));
        float vScale = (float) Math.round((getUnInterpolatedV(sprite, v1) - getUnInterpolatedV(sprite, v0)) / xyz1.method_1022(xyz0));

        if (uScale == 0) {
            float v3 = class_5611.method_76642(packedUV3);
            float u1 = class_5611.method_76641(packedUV1);
            uAxis = xyz1.method_1019(xyz2).method_1021(.5);
            vAxis = xyz3.method_1019(xyz2).method_1021(.5);
            uScale = (float) Math.round((getUnInterpolatedU(sprite, u1) - getUnInterpolatedU(sprite, u0)) / xyz1.method_1022(xyz0));
            vScale = (float) Math.round((getUnInterpolatedV(sprite, v3) - getUnInterpolatedV(sprite, v0)) / xyz3.method_1022(xyz0));
        }

        uAxis = uAxis.method_1020(center).method_1029();
        vAxis = vAxis.method_1020(center).method_1029();

        class_243 min = new class_243(crop.field_1323, crop.field_1322, crop.field_1321);
        class_243 max = new class_243(crop.field_1320, crop.field_1325, crop.field_1324);
        class_243 newXyz0 = VecHelper.componentMin(max, VecHelper.componentMax(xyz0, min));
        class_243 newXyz1 = VecHelper.componentMin(max, VecHelper.componentMax(xyz1, min));
        class_243 newXyz2 = VecHelper.componentMin(max, VecHelper.componentMax(xyz2, min));
        class_243 newXyz3 = VecHelper.componentMin(max, VecHelper.componentMax(xyz3, min));
        class_777 newQuad = new class_777(
            newXyz0.method_1019(move).method_46409(),
            newXyz1.method_1019(move).method_46409(),
            newXyz2.method_1019(move).method_46409(),
            newXyz3.method_1019(move).method_46409(),
            calcSpriteUv(newXyz0.method_1020(xyz0), packedUV0, uAxis, vAxis, uScale, vScale, sprite),
            calcSpriteUv(newXyz1.method_1020(xyz1), packedUV1, uAxis, vAxis, uScale, vScale, sprite),
            calcSpriteUv(newXyz2.method_1020(xyz2), packedUV2, uAxis, vAxis, uScale, vScale, sprite),
            calcSpriteUv(newXyz3.method_1020(xyz3), packedUV3, uAxis, vAxis, uScale, vScale, sprite),
            quad.comp_3722(),
            quad.comp_3723(),
            quad.comp_3724(),
            quad.comp_3725(),
            quad.comp_3726()
        );
        NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
        return newQuad;
    }

    public static class_10801 generateModel(class_10801 template, UnaryOperator<class_1058> spriteSwapper) {
        class_10817.class_10818 builder = new class_10817.class_10818();
        for (class_2350 cullFace : Iterate.directions) {
            List<class_777> quads = template.method_68509(cullFace);
            swapSprites(quads, spriteSwapper).forEach(quad -> builder.method_68053(cullFace, quad));
        }

        List<class_777> quads = template.method_68509(null);
        swapSprites(quads, spriteSwapper).forEach(builder::method_68051);

        class_1058 particleSprite = template.comp_3752();
        class_1058 swappedParticleSprite = spriteSwapper.apply(particleSprite);
        if (swappedParticleSprite != null) {
            particleSprite = swappedParticleSprite;
        }
        return new class_10801(builder.method_68050(), template.comp_3751(), particleSprite);
    }

    public static long calcSpriteUv(long packedUv, class_1058 sprite, class_1058 newSprite) {
        float u = newSprite.method_4580(getUnInterpolatedU(sprite, class_5611.method_76641(packedUv)));
        float v = newSprite.method_4570(getUnInterpolatedV(sprite, class_5611.method_76642(packedUv)));
        return class_5611.method_76640(u, v);
    }

    public static List<class_777> swapSprites(List<class_777> quads, UnaryOperator<class_1058> spriteSwapper) {
        List<class_777> newQuads = new ArrayList<>(quads);
        int size = quads.size();
        for (int i = 0; i < size; i++) {
            class_777 quad = quads.get(i);
            class_1058 sprite = quad.comp_3724();
            class_1058 newSprite = spriteSwapper.apply(sprite);
            if (newSprite == null || sprite == newSprite)
                continue;

            class_777 newQuad = new class_777(
                quad.comp_5238(),
                quad.comp_5239(),
                quad.comp_5240(),
                quad.comp_5241(),
                calcSpriteUv(quad.comp_5242(), sprite, newSprite),
                calcSpriteUv(quad.comp_5243(), sprite, newSprite),
                calcSpriteUv(quad.comp_5244(), sprite, newSprite),
                calcSpriteUv(quad.comp_5245(), sprite, newSprite),
                quad.comp_3722(),
                quad.comp_3723(),
                quad.comp_3724(),
                quad.comp_3725(),
                quad.comp_3726()
            );
            NormalsBakedQuad.setNormals(newQuad, NormalsBakedQuad.getNormals(quad));
            newQuads.set(i, newQuad);
        }
        return newQuads;
    }
}