package com.zurrtum.create.client.foundation.ponder.instruction;

import com.zurrtum.create.client.content.kinetics.deployer.DeployerRenderer;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import com.zurrtum.create.client.ponder.foundation.instruction.TickingInstruction;
import com.zurrtum.create.content.contraptions.bearing.IBearingBlockEntity;
import com.zurrtum.create.content.contraptions.pulley.PulleyBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlockEntity;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2586;

public class AnimateBlockEntityInstruction extends TickingInstruction {

    protected double deltaPerTick;
    protected double totalDelta;
    protected double target;
    protected final class_2338 location;

    private final BiConsumer<PonderLevel, Float> setter;
    private final Function<PonderLevel, Float> getter;

    public static AnimateBlockEntityInstruction bearing(class_2338 location, float totalDelta, int ticks) {
        return new AnimateBlockEntityInstruction(
            location,
            totalDelta,
            ticks,
            (w, f) -> castIfPresent(w, location, IBearingBlockEntity.class).ifPresent(bte -> bte.setAngle(f)),
            (w) -> castIfPresent(w, location, IBearingBlockEntity.class).map(bte -> bte.getInterpolatedAngle(0)).orElse(0f)
        );
    }

    public static AnimateBlockEntityInstruction bogey(class_2338 location, float totalDelta, int ticks) {
        float movedPerTick = totalDelta / ticks;
        return new AnimateBlockEntityInstruction(
            location,
            totalDelta,
            ticks,
            (w, f) -> castIfPresent(
                w,
                location,
                AbstractBogeyBlockEntity.class
            ).ifPresent(bte -> bte.animate(f.equals(totalDelta) ? 0 : movedPerTick)),
            (w) -> 0f
        );
    }

    public static AnimateBlockEntityInstruction pulley(class_2338 location, float totalDelta, int ticks) {
        return new AnimateBlockEntityInstruction(
            location,
            totalDelta,
            ticks,
            (w, f) -> castIfPresent(w, location, PulleyBlockEntity.class).ifPresent(pulley -> pulley.animateOffset(f)),
            (w) -> castIfPresent(w, location, PulleyBlockEntity.class).map(pulley -> pulley.offset).orElse(0f)
        );
    }

    public static AnimateBlockEntityInstruction deployer(class_2338 location, float totalDelta, int ticks) {
        return new AnimateBlockEntityInstruction(
            location,
            totalDelta,
            ticks,
            (w, f) -> castIfPresent(w, location, DeployerBlockEntity.class).ifPresent(deployer -> deployer.setAnimatedOffset(f)),
            (w) -> castIfPresent(w, location, DeployerBlockEntity.class).map(deployer -> DeployerRenderer.getHandOffset(deployer, 1)).orElse(0f)
        );
    }

    protected AnimateBlockEntityInstruction(
        class_2338 location,
        float totalDelta,
        int ticks,
        BiConsumer<PonderLevel, Float> setter,
        Function<PonderLevel, Float> getter
    ) {
        super(false, ticks);
        this.location = location;
        this.setter = setter;
        this.getter = getter;
        this.deltaPerTick = totalDelta * (1d / ticks);
        this.totalDelta = totalDelta;
        this.target = totalDelta;
    }

    @Override
    protected final void firstTick(PonderScene scene) {
        super.firstTick(scene);
        target = getter.apply(scene.getLevel()) + totalDelta;
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        PonderLevel world = scene.getLevel();
        float current = getter.apply(world);
        float next = (float) (remainingTicks == 0 ? target : current + deltaPerTick);
        setter.accept(world, next);
        if (remainingTicks == 0) // lock interpolation
            setter.accept(world, next);
    }

    private static <T> Optional<T> castIfPresent(PonderLevel world, class_2338 pos, Class<T> beType) {
        class_2586 blockEntity = world.method_8321(pos);
        if (beType.isInstance(blockEntity))
            return Optional.of(beType.cast(blockEntity));
        return Optional.empty();
    }

}