package com.zurrtum.create.client.foundation.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_12137;
import net.minecraft.class_12247;
import net.minecraft.class_12247.class_4750;
import net.minecraft.class_12249;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

import static com.zurrtum.create.Create.MOD_ID;

@SuppressWarnings("deprecation")
public class CreateRenderTypes {
    private static final class_1921 TRANSLUCENT = class_1921.method_75940(
        createLayerName("translucent"),
        class_12247.method_75927(class_10799.field_56897).method_75929(256).method_75936().method_75937().method_75928()
            .method_76560("Sampler0", class_1059.field_5275, class_12249.field_64462).method_75932(class_4750.field_21855)
            .method_75938()
    );

    private static final class_1921 ADDITIVE = class_1921.method_75940(
        createLayerName("additive"),
        class_12247.method_75927(AllRenderPipelines.ADDITIVE).method_75929(256).method_75936().method_75937()
            .method_75934("Sampler0", class_1059.field_5275).method_75928().method_75935().method_75932(class_4750.field_21855)
            .method_75938()
    );

    private static final class_1921 ADDITIVE2 = class_1921.method_75940(
        createLayerName("additive2"),
        class_12247.method_75927(AllRenderPipelines.ADDITIVE2).method_75929(256).method_75936().method_75937()
            .method_75934("Sampler0", class_1059.field_5275).method_75928().method_75935().method_75932(class_4750.field_21855)
            .method_75938()
    );

    private static final class_1921 ITEM_GLOWING_SOLID = class_1921.method_75940(
        createLayerName("item_glowing_solid"),
        class_12247.method_75927(AllRenderPipelines.GLOWING).method_75929(256).method_75936().method_75934("Sampler0", class_1059.field_5275)
            .method_75928().method_75935().method_75932(class_4750.field_21855).method_75938()
    );

    private static final class_1921 ITEM_GLOWING_TRANSLUCENT = class_1921.method_75940(
        createLayerName("item_glowing_translucent"),
        class_12247.method_75927(AllRenderPipelines.GLOWING_TRANSLUCENT).method_75929(256).method_75936().method_75937()
            .method_75934("Sampler0", class_1059.field_5275).method_75928().method_75935().method_75932(class_4750.field_21855)
            .method_75938()
    );

    public static final Supplier<class_12137> CHAIN_SAMPLER = () -> RenderSystem.getSamplerCache()
        .method_75293(AddressMode.REPEAT, AddressMode.REPEAT, FilterMode.LINEAR, FilterMode.NEAREST, true);
    private static final Function<class_2960, class_1921> CHAIN = class_156.method_34866((texture) -> class_1921.method_75940(
        "chain_conveyor_chain",
        class_12247.method_75927(class_10799.field_64226).method_75937().method_76560("Sampler0", texture, CHAIN_SAMPLER).method_75928().method_75935()
            .method_75932(class_4750.field_21855).method_75938()
    ));

    public static class_1921 translucent() {
        return TRANSLUCENT;
    }

    public static class_1921 additive() {
        return ADDITIVE;
    }

    public static class_1921 additive2() {
        return ADDITIVE2;
    }

    public static BiFunction<class_2960, Boolean, class_1921> TRAIN_MAP = class_156.method_34865(CreateRenderTypes::getTrainMap);

    private static class_1921 getTrainMap(class_2960 locationIn, boolean linearFiltering) {
        return class_1921.method_75940(
            "create_train_map",
            class_12247.method_75927(class_10799.field_56818).method_75929(256).method_75937().method_75928().method_76560(
                "Sampler0",
                locationIn,
                () -> RenderSystem.getSamplerCache().method_75294(linearFiltering ? FilterMode.LINEAR : FilterMode.NEAREST)
            ).method_75938()
        );
    }

    public static class_1921 itemGlowingSolid() {
        return ITEM_GLOWING_SOLID;
    }

    public static class_1921 itemGlowingTranslucent() {
        return ITEM_GLOWING_TRANSLUCENT;
    }

    public static class_1921 chain(class_2960 pLocation) {
        return CHAIN.apply(pLocation);
    }

    private static String createLayerName(String name) {
        return MOD_ID + ":" + name;
    }
}
