package com.zurrtum.create.client.infrastructure.model;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.content.equipment.extendoGrip.ExtendoGripRenderHandler;
import net.minecraft.class_10419;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_10444.class_10446;
import net.minecraft.class_10515;
import net.minecraft.class_10809;
import net.minecraft.class_10819;
import net.minecraft.class_1086;
import net.minecraft.class_11566;
import net.minecraft.class_11659;
import net.minecraft.class_11890;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_777;
import net.minecraft.class_7775;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.client.renderer.item.*;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

import java.util.List;
import java.util.function.Consumer;

import static com.zurrtum.create.Create.MOD_ID;

public class ExtendoGripModel implements class_10439, class_10515<ExtendoGripModel.RenderData> {
    public static final class_2960 ID = class_2960.method_60655(MOD_ID, "model/extendo_grip");
    public static final class_2960 ITEM_ID = class_2960.method_60655(MOD_ID, "item/extendo_grip/item");
    public static final class_2960 POLE_ID = class_2960.method_60655(MOD_ID, "item/extendo_grip/pole");
    public static final class_2960 COG_ID = class_2960.method_60655(MOD_ID, "item/extendo_grip/cog");
    public static final class_2960 THIN_SHORT_ID = class_2960.method_60655(MOD_ID, "item/extendo_grip/thin_short");
    public static final class_2960 WIDE_SHORT_ID = class_2960.method_60655(MOD_ID, "item/extendo_grip/wide_short");
    public static final class_2960 THIN_LONG_ID = class_2960.method_60655(MOD_ID, "item/extendo_grip/thin_long");
    public static final class_2960 WIDE_LONG_ID = class_2960.method_60655(MOD_ID, "item/extendo_grip/wide_long");
    public static final class_2960 DEPLOYER_HAND_POINTING = class_2960.method_60655(MOD_ID, "block/deployer/hand_pointing");
    public static final class_2960 DEPLOYER_HAND_PUNCHING = class_2960.method_60655(MOD_ID, "block/deployer/hand_punching");
    public static final class_2960 DEPLOYER_HAND_HOLDING = class_2960.method_60655(MOD_ID, "block/deployer/hand_holding");

    private final class_1921 itemLayer = class_4722.method_29382();
    private final class_1921 blockLayer = class_4722.method_76545();
    private final int[] tints = new int[0];
    private final class_10809 settings;
    private final Supplier<Vector3fc[]> vector;
    private final List<class_777> item;
    private final List<class_777> pole;
    private final List<class_777> cog;
    private final List<class_777> thinShort;
    private final List<class_777> wideShort;
    private final List<class_777> thinLong;
    private final List<class_777> wideLong;
    private final List<class_777> pointing;
    private final List<class_777> punching;
    private final List<class_777> holding;

    public ExtendoGripModel(
        class_10809 settings,
        List<class_777> item,
        List<class_777> pole,
        List<class_777> cog,
        List<class_777> thinShort,
        List<class_777> wideShort,
        List<class_777> thinLong,
        List<class_777> wideLong,
        List<class_777> pointing,
        List<class_777> punching,
        List<class_777> holding
    ) {
        this.settings = settings;
        this.item = item;
        this.pole = pole;
        this.vector = Suppliers.memoize(() -> class_10430.method_67990(item));
        this.cog = cog;
        this.thinShort = thinShort;
        this.wideShort = wideShort;
        this.thinLong = thinLong;
        this.wideLong = wideLong;
        this.pointing = pointing;
        this.punching = punching;
        this.holding = holding;
    }

    @Override
    public void method_65584(
        class_10444 state,
        class_1799 stack,
        class_10442 resolver,
        class_811 displayContext,
        @Nullable class_638 world,
        @Nullable class_11566 ctx,
        int seed
    ) {
        state.method_70946(this);
        state.method_70947();

        RenderData data = new RenderData();
        data.animation = 0.25f;
        boolean leftHand = displayContext == class_811.field_4321;
        boolean rightHand = displayContext == class_811.field_4322;
        if (leftHand || rightHand)
            data.animation = class_3532.method_16439(
                AnimationTickHolder.getPartialTicks(),
                ExtendoGripRenderHandler.lastMainHandAnimation,
                ExtendoGripRenderHandler.mainHandAnimation
            );
        data.animation = data.animation * data.animation * data.animation;
        float extensionAngle = class_3532.method_16439(data.animation, 24f, 156f);
        data.state = state.method_65601();
        data.state.method_67992(itemLayer);
        data.state.method_67995(vector);
        settings.method_68000(data.state, displayContext);
        data.state.method_67997().addAll(item);
        data.halfAngle = extensionAngle / 2;
        data.oppositeAngle = 180 - extensionAngle;
        data.hand = (leftHand || rightHand) ? ExtendoGripRenderHandler.holding ? holding : punching : pointing;
        data.angle = AnimationTickHolder.getRenderTime() * -2;
        if (leftHand || rightHand)
            data.angle += 360 * data.animation;
        data.angle %= 360;
        if (stack == null) {
            data.self = true;
        } else if (!stack.method_31574(AllItems.EXTENDO_GRIP)) {
            data.item = new class_10444();
            data.item.field_55337 = displayContext;
            resolver.method_65596(data.item, stack, displayContext, world, ctx, seed);
            class_1306 mainArm = class_1306.field_6183;
            if (ctx instanceof class_11890 entity) {
                mainArm = entity.method_6068();
            } else {
                class_746 player = class_310.method_1551().field_1724;
                if (player != null) {
                    mainArm = player.method_6068();
                }
            }
            data.flip = rightHand ^ mainArm == class_1306.field_6182 ? 1 : -1;
        }
        data.state.method_65617(this, data);
    }

    @Override
    public void submit(
        RenderData data,
        class_811 displayContext,
        class_4587 matrices,
        class_11659 queue,
        int light,
        int overlay,
        boolean glint,
        int i
    ) {
        assert data != null;
        if (data.self) {
            data.self = false;
            matrices.method_22903();
            matrices.method_46416(0.45f, 0.65f, -0.7f - (data.animation * 2.25f));
            settings.comp_3768().method_3503(displayContext).method_23075(displayContext.method_67675(), matrices.method_23760());
            submit(data, displayContext, matrices, queue, light, overlay, glint, i);
            matrices.method_22909();
        } else if (data.item != null) {
            matrices.method_22903();
            matrices.method_46416(0.45f, 0.65f, -0.7f - (data.animation * 2.25f));
            if (data.item.method_65608()) {
                matrices.method_22907(class_7833.field_40716.rotationDegrees(data.flip * 45));
                matrices.method_46416(data.flip * 0.15f, -0.15f, -.05f);
                matrices.method_22905(1.25f, 1.25f, 1.25f);
            }
            data.item.method_65604(matrices, queue, light, overlay, i);
            matrices.method_22909();
        }

        // grip
        class_10446 grip = data.state;
        queue.method_73480(matrices, displayContext, light, overlay, 0, grip.field_55349, grip.field_56964, grip.field_55347, grip.field_55348);
        renderQuads(displayContext, matrices, queue, light, overlay, pole, blockLayer);

        // bits
        matrices.method_22903();
        matrices.method_46416(0, 0.5625f, 0.0625f);
        matrices.method_22905(1, 1, 1 + data.animation);

        matrices.method_22903();
        matrices.method_22907(class_7833.field_40713.rotationDegrees(data.halfAngle));
        renderQuads(displayContext, matrices, queue, light, overlay, thinShort, itemLayer);
        matrices.method_46416(0, 0.34375f, 0);
        matrices.method_22907(class_7833.field_40713.rotationDegrees(data.oppositeAngle));
        renderQuads(displayContext, matrices, queue, light, overlay, wideLong, itemLayer);
        matrices.method_46416(0, 0.6875f, 0);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(data.oppositeAngle));
        matrices.method_46416(0, 0.03125f, 0);
        renderQuads(displayContext, matrices, queue, light, overlay, thinShort, itemLayer);
        matrices.method_22909();

        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-180 + data.halfAngle));
        renderQuads(displayContext, matrices, queue, light, overlay, wideShort, itemLayer);
        matrices.method_46416(0, 0.34375f, 0);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(data.oppositeAngle));
        renderQuads(displayContext, matrices, queue, light, overlay, thinLong, itemLayer);
        matrices.method_46416(0, 0.6875f, 0);
        matrices.method_22907(class_7833.field_40713.rotationDegrees(data.oppositeAngle));
        matrices.method_46416(0, 0.03125f, 0);
        renderQuads(displayContext, matrices, queue, light, overlay, wideShort, itemLayer);

        // hand
        matrices.method_46416(0, 0.34375f, 0);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180 - data.halfAngle));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
        matrices.method_46416(0, 0, -0.25f);
        matrices.method_22905(1, 1, 1 / (1 + data.animation));
        matrices.method_46416(-1f, -0.5f, -0.5f);
        renderQuads(displayContext, matrices, queue, light, overlay, data.hand, blockLayer);
        matrices.method_22909();

        matrices.method_22909();

        // cog
        matrices.method_22903();
        matrices.method_46416(0.5f, 0.5625f, 0.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(data.angle));
        matrices.method_46416(-0.5f, -0.5625f, -0.5f);
        renderQuads(displayContext, matrices, queue, light, overlay, cog, blockLayer);
        matrices.method_22909();
    }

    private void renderQuads(
        class_811 displayContext,
        class_4587 matrices,
        class_11659 queue,
        int light,
        int overlay,
        List<class_777> quads,
        class_1921 layer
    ) {
        queue.method_73480(matrices, displayContext, light, overlay, 0, tints, quads, layer, class_10444.class_10445.field_55341);
    }

    public static class RenderData {
        class_10444 item;
        class_10446 state;
        List<class_777> hand;
        float halfAngle;
        float oppositeAngle;
        float animation;
        float angle;
        boolean self;
        int flip;
    }

    @Override
    public void method_72175(Consumer<Vector3fc> output) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RenderData method_65695(class_1799 stack) {
        throw new UnsupportedOperationException();
    }

    public static class Unbaked implements class_10439.class_10441 {
        public static final MapCodec<com.zurrtum.create.client.infrastructure.model.ExtendoGripModel.Unbaked> CODEC = MapCodec.unit(com.zurrtum.create.client.infrastructure.model.ExtendoGripModel.Unbaked::new);

        @Override
        public MapCodec<com.zurrtum.create.client.infrastructure.model.ExtendoGripModel.Unbaked> method_65585() {
            return CODEC;
        }

        @Override
        public void method_62326(class_10103 resolver) {
            resolver.markDependency(ITEM_ID);
            resolver.markDependency(POLE_ID);
            resolver.markDependency(COG_ID);
            resolver.markDependency(THIN_SHORT_ID);
            resolver.markDependency(WIDE_SHORT_ID);
            resolver.markDependency(THIN_LONG_ID);
            resolver.markDependency(WIDE_LONG_ID);
            resolver.markDependency(DEPLOYER_HAND_POINTING);
            resolver.markDependency(DEPLOYER_HAND_PUNCHING);
            resolver.markDependency(DEPLOYER_HAND_HOLDING);
        }

        @Override
        public class_10439 method_65587(class_10439.class_10440 context) {
            class_7775 baker = context.comp_3390();
            class_10819 model = baker.method_45872(ITEM_ID);
            class_10419 textures = model.method_68045();
            List<class_777> quads = model.method_68034(textures, baker, class_1086.field_63619).method_68048();
            class_10809 settings = class_10809.method_68001(baker, model, textures);
            return new ExtendoGripModel(
                settings,
                quads,
                bakeQuads(baker, POLE_ID),
                bakeQuads(baker, COG_ID),
                bakeQuads(baker, THIN_SHORT_ID),
                bakeQuads(baker, WIDE_SHORT_ID),
                bakeQuads(baker, THIN_LONG_ID),
                bakeQuads(baker, WIDE_LONG_ID),
                bakeQuads(baker, DEPLOYER_HAND_POINTING),
                bakeQuads(baker, DEPLOYER_HAND_PUNCHING),
                bakeQuads(baker, DEPLOYER_HAND_HOLDING)
            );
        }

        private static List<class_777> bakeQuads(class_7775 baker, class_2960 id) {
            class_10819 model = baker.method_45872(id);
            return model.method_68034(model.method_68045(), baker, class_1086.field_63619).method_68048();
        }
    }
}
